/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.execution.EvaluableAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.tools.ui.RaceCalendarTableHolder;
import org.ussamasters.aces.tools.ui.RaceTableRow;

public class RaceSeriesTableHolder
extends RaceCalendarTableHolder {
    public static final String COLUMN_LABEL_COMPLETION_STATUS = "Status";
    public static final String COLUMN_LABEL_SUMMARY_STATUS = "Summary";
    private static final Map<String, Vector<String>> columnLabelsMap = RaceSeriesTableHolder.constructColumnLabelsMap();
    private static final int FIRST_INFO_COLUMN = STANDARD_COLUMN_LABELS.size();
    protected EvaluableAction[] composeInfoColumnActions;

    public RaceSeriesTableHolder(RaceSeries raceSeries, String infoColumnLabel, EvaluableAction composeInfoColumnAction) {
        this(raceSeries, columnLabelsMap.get(infoColumnLabel), new EvaluableAction[]{composeInfoColumnAction});
    }

    public RaceSeriesTableHolder(RaceSeries raceSeries, String[] infoColumnLabels, EvaluableAction[] composeInfoColumnActions) {
        this(raceSeries, RaceTableRow.constructColumnLabels(infoColumnLabels), composeInfoColumnActions);
    }

    public RaceSeriesTableHolder(RaceSeries raceSeries, Vector<String> infoColumnLabels, EvaluableAction[] composeInfoColumnActions) {
        super(raceSeries, infoColumnLabels, composeInfoColumnActions);
    }

    protected Object[] computeInfoColumnValues(RaceIdentifier aRace) {
        int nInfoColumns = this.composeInfoColumnActions.length;
        Object[] values = new Object[nInfoColumns];
        for (int i = 0; i < nInfoColumns; ++i) {
            values[i] = this.composeInfoColumnActions[i].evaluate(aRace);
        }
        return values;
    }

    @Override
    protected RaceTableRow constructRow(RaceIdentifier aRace) {
        return new RaceTableRow(aRace, this.computeInfoColumnValues(aRace));
    }

    @Override
    public void setData(RaceSeries raceSeries, Vector<String> columnLabels, Object subclassData) {
        this.composeInfoColumnActions = (EvaluableAction[])subclassData;
        this.setData(raceSeries, columnLabels);
    }

    public void updateRaceInfo(RaceIdentifier aRace) {
        int raceIndex = this.indexOf(aRace);
        Object[] infoColumnValues = this.computeInfoColumnValues(aRace);
        for (int i = 0; i < infoColumnValues.length; ++i) {
            this.getDataModel().setValueAt(infoColumnValues[i], raceIndex, FIRST_INFO_COLUMN + i);
        }
    }

    protected static Map<String, Vector<String>> constructColumnLabelsMap() {
        HashMap<String, Vector<String>> mappingTable = new HashMap<String, Vector<String>>();
        mappingTable.put(COLUMN_LABEL_COMPLETION_STATUS, RaceTableRow.constructColumnLabels(COLUMN_LABEL_COMPLETION_STATUS));
        mappingTable.put(COLUMN_LABEL_SUMMARY_STATUS, RaceTableRow.constructColumnLabels(COLUMN_LABEL_SUMMARY_STATUS));
        return mappingTable;
    }
}

