/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.mv.swing.ListHolder;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.ussamasters.aces.racedata.models.CourseArrangement;
import org.ussamasters.aces.racedata.models.NamedRacerResult;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassGroup;
import org.ussamasters.aces.racedata.models.RaceDescriptor;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.scoring.RaceStandings;
import org.ussamasters.aces.tools.ui.RaceDataDialog;
import org.ussamasters.aces.tools.ui.RaceSpecificationModel;
import org.ussamasters.aces.tools.ui.ToolUIModelServices;

public class SplitRaceDialog
extends RaceDataDialog {
    public static final String SPLIT_BY_CLASS = "Split by class";
    public static final String SPLIT_BY_GROUP = "Split by group";
    public static final List<String> SPLIT_RACE_OPTIONS = Collections.unmodifiableList(Arrays.asList("Split by class", "Split by group"));
    public static final String DEFAULT_SPLIT_CATEGORY = "Split by class";
    protected RaceResult resultToSplit;
    protected RaceIdentifier splitRaceID;
    protected RaceResult splitResult;
    protected RaceDescriptor splitRaceSpec;
    protected List<? extends RaceClass<?>> raceClasses;
    protected List<RaceClassGroup<?>> raceClassGroups;
    protected RaceSpecificationModel raceSpecificationModel;
    protected DefaultComboBoxModel<String> splitCategoryOptionsHolder;
    protected ListHolder splitCategoriesListHolder;

    public static RaceResult openOn(RaceResult aRaceResult, RaceIdentifier splitRaceID, Window aWindow) {
        SplitRaceDialog aDialog = new SplitRaceDialog(aRaceResult, splitRaceID, aWindow);
        aDialog.openWindow();
        return aDialog.getSplitRace();
    }

    public SplitRaceDialog(RaceResult aRaceResult, RaceIdentifier splitRaceID, Window aWindow) {
        super(aWindow);
        this.resultToSplit = aRaceResult;
        this.splitRaceID = splitRaceID;
        this.initializeModels();
    }

    public void acceptResult() {
        this.splitResult = this.constructSplitResult();
    }

    @Override
    public void clearResult() {
        this.splitResult = null;
    }

    protected List<RacerResult> collectRacerResults() {
        String aSplitOption = this.getSelectedSplitOption();
        List<Object> selectedCategories = this.getSelectedCategories();
        ArrayList<RacerResult> resultsList = new ArrayList<RacerResult>();
        if (aSplitOption.equals("Split by class")) {
            for (RacerResult rr : this.resultToSplit.getRacerResults()) {
                NamedRacerResult aRacerResult = (NamedRacerResult)rr;
                RaceClass<?> aRaceClass = aRacerResult.getRaceClass();
                if (!selectedCategories.contains(aRaceClass)) continue;
                resultsList.add(aRacerResult);
            }
        } else if (aSplitOption.equals(SPLIT_BY_GROUP)) {
            for (RacerResult rr : this.resultToSplit.getRacerResults()) {
                NamedRacerResult aRacerResult = (NamedRacerResult)rr;
                RaceClassGroup<?> aRaceGroup = aRacerResult.getRaceClass().getGroup();
                if (!selectedCategories.contains(aRaceGroup)) continue;
                resultsList.add(aRacerResult);
            }
        } else {
            throw new IllegalStateException("Unknown split category: " + aSplitOption);
        }
        return resultsList;
    }

    protected RaceResult constructSplitResult() {
        this.splitRaceSpec.setCourseArrangement(this.getRaceSpecificationModel().getSelectedCourseArrangement());
        RaceResult aRaceResult = new RaceResult(this.splitRaceSpec, this.collectRacerResults());
        return RaceStandings.computeCanonicalStandings(aRaceResult);
    }

    public RaceSpecificationModel getRaceSpecificationModel() {
        return this.raceSpecificationModel;
    }

    public List<Object> getSelectedCategories() {
        return this.getSplitCategoriesListHolder().getSelectedValues();
    }

    public String getSelectedSplitOption() {
        return (String)this.splitCategoryOptionsHolder.getSelectedItem();
    }

    public RaceResult getSplitRace() {
        return this.splitResult;
    }

    public DefaultComboBoxModel<String> getSplitCategoryOptionsModel() {
        return this.splitCategoryOptionsHolder;
    }

    public ListHolder getSplitCategoriesListHolder() {
        return this.splitCategoriesListHolder;
    }

    protected void initializeModels() {
        ToolUIModelServices toolUIModelServices = this.getToolUIModelServices();
        Class<? extends RaceClass<?>> raceClassClass = this.resultToSplit.getRaceClassClass();
        this.splitRaceSpec = new RaceDescriptor(this.splitRaceID, raceClassClass, this.resultToSplit.getWorldCupPointsType(), CourseArrangement.SINGLE_COURSE);
        HashSet rcSet = new HashSet();
        for (RacerResult racerResult : this.resultToSplit.getRacerResults()) {
            NamedRacerResult namedRacerResult = (NamedRacerResult)racerResult;
            rcSet.add(namedRacerResult.getRaceClass());
        }
        this.raceClasses = new ArrayList(rcSet);
        Collections.sort(this.raceClasses, new Comparator<RaceClass<?>>(){

            @Override
            public int compare(RaceClass<?> rc1, RaceClass<?> rc2) {
                return rc1.name.compareTo(rc2.name);
            }
        });
        HashSet groups = new HashSet();
        for (RaceClass<?> raceClass : this.raceClasses) {
            groups.add(raceClass.getGroup());
        }
        this.raceClassGroups = new ArrayList(groups);
        Collections.sort(this.raceClassGroups, new Comparator<RaceClassGroup<?>>(){

            @Override
            public int compare(RaceClassGroup<?> g1, RaceClassGroup<?> g2) {
                return g1.name.compareTo(g2.name);
            }
        });
        this.raceSpecificationModel = new RaceSpecificationModel(this.splitRaceSpec);
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.raceSpecificationModel.getRaceClassClassModel();
        defaultComboBoxModel.removeAllElements();
        defaultComboBoxModel.addElement(this.resultToSplit.getRaceClassType());
        this.splitCategoryOptionsHolder = toolUIModelServices.constructComboBoxListHolder(SPLIT_RACE_OPTIONS);
        this.splitCategoriesListHolder = new ListHolder(ListHolder.createDefaultDataModel(), ListHolder.createDefaultSelectionModel(2));
        this.selectSplitByClass();
    }

    public void selectedSplitOption() {
        String aSplitOption = this.getSelectedSplitOption();
        if (aSplitOption == null) {
            return;
        }
        this.splitCategoriesListHolder.clear();
        if (aSplitOption.equals("Split by class")) {
            this.splitCategoriesListHolder.addAll(this.raceClasses);
        } else if (aSplitOption.equals(SPLIT_BY_GROUP)) {
            this.splitCategoriesListHolder.addAll(this.raceClassGroups);
        } else {
            throw new IllegalArgumentException("Unknown split category: " + aSplitOption);
        }
    }

    public void selectSplitByClass() {
        this.splitCategoryOptionsHolder.setSelectedItem("Split by class");
        this.splitCategoriesListHolder.clear();
        this.splitCategoriesListHolder.addAll(this.raceClasses);
    }

    public void selectSplitByGroup() {
        this.splitCategoryOptionsHolder.setSelectedItem(SPLIT_BY_GROUP);
        this.splitCategoriesListHolder.clear();
        this.splitCategoriesListHolder.addAll(this.raceClassGroups);
    }
}

