/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.javax.swing.SwingPatches;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.IOException;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.foundation.swing.UserConfirmationValidationResolver;
import org.ussamasters.aces.tools.ui.NewWorkingSetDialog;
import org.ussamasters.aces.tools.ui.swing.WorkingSetSettingsEditorWindow;

public class NewWorkingSetDialogWindow
extends WorkingSetSettingsEditorWindow {
    public static final float DEFAULT_WIDTH_TWIPS = 6780.0f;
    public static final float DEFAULT_HEIGHT_TWIPS = RACE_SERIES_ID_PANEL_HEIGHT_TWIPS + 2940.0f + 405.0f + 840.0f;
    protected Map<String, Object> propertyValueItemMap;

    public NewWorkingSetDialogWindow() {
    }

    public NewWorkingSetDialogWindow(Dialog owner) {
        super(owner);
    }

    public NewWorkingSetDialogWindow(Frame owner) {
        super(owner);
    }

    @Override
    protected void initMainWindow() {
        super.initMainWindow();
        this.dialogWindow.setTitle("New Race Series");
        this.setDefaultWindowSize();
    }

    @Override
    protected void initChildComponents() {
        float leftOffsetValueCol = 1410.0f;
        this.initRaceSeriesIdentificationPanel(leftOffsetValueCol);
        this.initRaceSeriesSettingsPanel(0.0f, RACE_SERIES_ID_PANEL_HEIGHT_TWIPS, leftOffsetValueCol);
        this.initOperationButtonsPanel();
    }

    @Override
    protected float initRacerSeriesNameItems(JPanel raceSeriesIdPanel, float itemTopOffset, float leftOffsetValueCol) {
        this.raceSeriesNameLabel = new JLabel();
        this.raceSeriesNameLabel.setText("Race Series");
        FramerFactory.current.installComponent(this.raceSeriesNameLabel, raceSeriesIdPanel, 1, 136, 0.0f, itemTopOffset, 1230.0f, 315.0f);
        this.raceSeriesNameField = new JTextField();
        this.raceSeriesNameField.setColumns(10);
        FramerFactory.current.installComponent(this.raceSeriesNameField, raceSeriesIdPanel, 1, 168, leftOffsetValueCol, itemTopOffset, 0.0f, 315.0f);
        return 415.0f;
    }

    @Override
    protected float initRaceSeriesDirectoryItems(JPanel raceSeriesIdPanel, float itemTopOffset, float leftOffsetValueCol) {
        this.workingSetDirectoryLabel = new JLabel();
        this.workingSetDirectoryLabel.setText("Directory name");
        FramerFactory.current.installComponent(this.workingSetDirectoryLabel, raceSeriesIdPanel, 1, 136, 0.0f, itemTopOffset, 1305.0f, 315.0f);
        this.workingSetDirectoryNameField = new JTextField();
        this.workingSetDirectoryNameField.setColumns(10);
        FramerFactory.current.installComponent(this.workingSetDirectoryNameField, raceSeriesIdPanel, 1, 168, leftOffsetValueCol, itemTopOffset, 2760.0f, 315.0f);
        return 415.0f;
    }

    public void setDefaultWindowSize() {
        FramerFactory.current.setWindowSize(this, 1, 136, 1530.0f, 1230.0f, 6780.0f, DEFAULT_HEIGHT_TWIPS);
    }

    protected NewWorkingSetDialog myApp() {
        return (NewWorkingSetDialog)this.getAppModel();
    }

    @Override
    protected void initializeWindow() {
        this.propertyValueItemMap = this.constructPropertyValueItemMap();
        this.dialogWindow.setTitle(this.myApp().getTitle());
        this.raceSeriesNameField.setDocument(this.myApp().getSeriesNameHolder());
        this.workingSetDirectoryNameField.setDocument(this.myApp().getSeriesDirectoryNameHolder());
        SwingPatches.installComboBoxModel(this.organizerComboBox, this.myApp().getSeriesOrganizerHolder());
        SwingPatches.installComboBoxModel(this.seriesTypeComboBox, this.myApp().getSeriesTypeHolder());
        this.seasonYearField.setText("" + this.myApp().getSeasonYearHolder().getValue());
        SwingPatches.installComboBoxModel(this.raceClassesComboBox, this.myApp().getSeriesRaceClassHolder());
        SwingPatches.installComboBoxModel(this.worldCupPointsComboBox, this.myApp().getWorldCupPointsHolder());
        SwingPatches.installComboBoxModel(this.courseArrangementComboBox, this.myApp().getStandardCourseArrangementHolder());
        this.configureConnections();
    }

    @Override
    protected void registerPropertyValueItems(Map<String, Object> mappingTable) {
        mappingTable.put("raceSeriesName", this.raceSeriesNameField);
        mappingTable.put("raceSeriesDirectoryName", this.workingSetDirectoryNameField);
        mappingTable.put("raceSeriesSeasonYear", this.seasonYearField);
    }

    protected void configureConnections() {
        this.configureOperationButtonConnections();
    }

    @Override
    protected boolean acceptChanges() {
        try {
            this.myApp().getSeasonYearHolder().setValue(Integer.parseInt(this.seasonYearField.getText().trim()));
        }
        catch (NumberFormatException ex) {
            this.seasonYearField.selectAll();
            this.seasonYearField.requestFocus();
            MessageDialog.displayWarning("Invalid Race Series Definition", "You must enter an integer value for the season year in which the race series occurred.", this.dialogWindow);
            return false;
        }
        UserConfirmationValidationResolver validationResolver = this.myToolServices().constructUserConfirmationValidationResolver(this.dialogWindow);
        ValidationResult validationResult = this.myApp().validateChanges(validationResolver);
        if (validationResult.failed()) {
            Component valueItem = (Component)this.propertyValueItemMap.get(validationResult.getAspect());
            if (valueItem != null) {
                if (valueItem instanceof JTextField) {
                    ((JTextField)valueItem).selectAll();
                }
                valueItem.requestFocus();
            }
            if (validationResolver.numberOfDenials == 0) {
                MessageDialog.displayWarning("Invalid Race Series Definition", validationResult.getMessage(), this.dialogWindow);
            }
            return false;
        }
        try {
            this.myApp().acceptChanges();
        }
        catch (IOException ex) {
            this.reportWorkingSetCreationFailed(ex);
            return false;
        }
        catch (RuntimeException ex) {
            this.reportWorkingSetCreationFailed(ex);
            return false;
        }
        return true;
    }

    protected void reportWorkingSetCreationFailed(Exception ex) {
        DebugSupport.current().dumpStack(ex);
        MessageDialog.displayError("Race Series Creation Failed", "Unable to create new race series: " + ex.getMessage(), this.dialogWindow);
    }
}

