/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.javax.swing.SwingServices;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.ussamasters.aces.racedata.models.ParameterSpecification;
import org.ussamasters.aces.racedata.models.ParameterType;
import org.ussamasters.aces.racedata.models.PolicySpecification;
import org.ussamasters.aces.tools.ui.swing.RSTPanel;
import org.ussamasters.aces.tools.ui.swing.RSTViewBuilder;

public class ParameterSpecificationsPanel
extends RSTPanel {
    public static final float DY_PARM_SPEC_LINE = Math.max(415.0f, 415.0f);
    protected static final int INDEX_PARM_ITEM_CB = 0;
    protected static final int INDEX_PARM_ITEM_LABEL = 1;
    protected static final int INDEX_PARM_ITEM_TEXT = 2;
    protected static final int INDEX_PARM_ITEM_RO_TEXT = 3;
    protected static final int NUM_PARM_ITEMS = 4;
    protected float leftOffsetTextField;
    protected int nItems;
    protected JComponent[][] parmSpecItems;
    protected float heightTwips;

    public static float computePanelHeight(int nItems) {
        return (float)nItems * DY_PARM_SPEC_LINE;
    }

    public ParameterSpecificationsPanel(int nItems, float leftOffsetTextField) {
        this.nItems = nItems;
        this.leftOffsetTextField = leftOffsetTextField;
        this.init();
    }

    protected void init() {
        this.initSelf();
        this.initChildComponents();
    }

    protected void initSelf() {
        this.setLayout(FramerFactory.current.newLayoutManager());
        this.setFont(RSTViewBuilder.current.standardLabelFont());
    }

    protected void initChildComponents() {
        float dxItemSeparation = 100.0f;
        float widthLabel = this.leftOffsetTextField - dxItemSeparation;
        float itemTopOffset = 0.0f;
        this.parmSpecItems = new JComponent[this.nItems][];
        for (int i = 0; i < this.nItems; ++i) {
            JCheckBox parmCB = new JCheckBox();
            JLabel parmLabel = new JLabel();
            JTextField parmText = new JTextField();
            JTextField parmReadonlyText = new JTextField();
            SwingServices.current.applyReadOnlyLookAndFeel(parmReadonlyText);
            FramerFactory.current.installComponent(parmCB, this, 1, 168, 0.0f, itemTopOffset, 0.0f, 315.0f);
            FramerFactory.current.installComponent(parmLabel, this, 1, 136, 0.0f, itemTopOffset, widthLabel, 315.0f);
            FramerFactory.current.installComponent(parmText, this, 1, 168, this.leftOffsetTextField, itemTopOffset, dxItemSeparation, 315.0f);
            FramerFactory.current.installComponent(parmReadonlyText, this, 1, 168, this.leftOffsetTextField, itemTopOffset, dxItemSeparation, 315.0f);
            this.parmSpecItems[i] = new JComponent[]{parmCB, parmLabel, parmText, parmReadonlyText};
            itemTopOffset += DY_PARM_SPEC_LINE;
        }
        this.heightTwips = itemTopOffset;
    }

    public float getMinHeight() {
        return this.heightTwips;
    }

    public void installParameterValues(PolicySpecification policySpec) {
        int i;
        int nParms = policySpec.getNumberOfParameters();
        for (i = 0; i < nParms; ++i) {
            ParameterSpecification parmSpec = policySpec.getParameterSpecification(i);
            JComponent[] parmItems = this.parmSpecItems[i];
            if (parmSpec.typeSpec == ParameterType.BOOLEAN) {
                JCheckBox parmCB = (JCheckBox)parmItems[0];
                parmCB.setText(parmSpec.label);
                parmCB.setSelected((Boolean)parmSpec.value);
                parmCB.setToolTipText(parmSpec.description);
                parmCB.setVisible(true);
                parmCB.setEnabled(parmSpec.modifiable);
                parmItems[1].setVisible(false);
                parmItems[2].setVisible(false);
                parmItems[3].setVisible(false);
                continue;
            }
            JLabel parmLabel = (JLabel)parmItems[1];
            int indexTextField = parmSpec.modifiable ? 2 : 3;
            int indexAltTextField = parmSpec.modifiable ? 3 : 2;
            JTextField parmText = (JTextField)parmItems[indexTextField];
            parmLabel.setText(parmSpec.label);
            parmText.setText(parmSpec.value.toString());
            parmLabel.setToolTipText(parmSpec.description);
            parmText.setToolTipText(parmSpec.description);
            parmLabel.setVisible(true);
            parmLabel.setEnabled(parmSpec.modifiable);
            parmText.setVisible(true);
            parmItems[0].setVisible(false);
            parmItems[indexAltTextField].setVisible(false);
        }
        for (i = nParms; i < this.nItems; ++i) {
            JComponent[] parmItems = this.parmSpecItems[i];
            for (int j = 0; j < 4; ++j) {
                parmItems[j].setVisible(false);
            }
        }
    }

    public boolean collectParameterValues(PolicySpecification policySpec) {
        ParameterSpecification parmSpec;
        int i;
        int nParms = policySpec.getNumberOfParameters();
        Object[] values = new Object[nParms];
        for (i = 0; i < nParms; ++i) {
            parmSpec = policySpec.getParameterSpecification(i);
            JComponent[] parmItems = this.parmSpecItems[i];
            if (!parmSpec.modifiable) continue;
            if (parmSpec.typeSpec == ParameterType.BOOLEAN) {
                JCheckBox parmCB = (JCheckBox)parmItems[0];
                values[i] = parmCB.isSelected();
                continue;
            }
            JTextField parmText = (JTextField)parmItems[2];
            String value = parmText.getText().trim();
            if (value.length() == 0) {
                MessageDialog.displayWarning("Missing Parameter", "You need to provide a value for the " + parmSpec.label + " parameter.", this.getMainWindow());
                return false;
            }
            if (parmSpec.typeSpec == ParameterType.STRING) {
                values[i] = value;
                continue;
            }
            try {
                values[i] = Integer.valueOf(value);
                continue;
            }
            catch (NumberFormatException ex) {
                MessageDialog.displayWarning("Invalid Parameter", "You need to provide an integer value for the " + parmSpec.label + " parameter.", this.getMainWindow());
                return false;
            }
        }
        for (i = 0; i < nParms; ++i) {
            if (values[i] == null) continue;
            parmSpec = policySpec.getParameterSpecification(i);
            parmSpec.value = values[i];
        }
        return true;
    }
}

