/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.javax.swing.SwingPatches;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.ussamasters.aces.racedata.models.CourseArrangement;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.tools.ui.RaceSpecificationModel;
import org.ussamasters.aces.tools.ui.swing.RSTPanel;
import org.ussamasters.aces.tools.ui.swing.RaceIdentifierPanel;

public class RaceSpecificationPanel
extends RSTPanel {
    public static final float DEFAULT_HEIGHT_TWIPS = 2900.0f;
    protected RaceSpecificationModel raceModel;
    protected RaceIdentifierPanel raceIdentifierPanel;
    protected JLabel raceClassesLabel;
    protected JComboBox<RaceClassType> raceClassesComboBox;
    protected JLabel courseArrangementLabel;
    protected JComboBox<CourseArrangement> courseArrangementComboBox;

    public RaceSpecificationPanel() {
        this.init();
    }

    protected void init() {
        this.initSelf();
        this.initChildComponents();
    }

    protected void initSelf() {
        this.setName("raceSpecificationPanel");
        this.setLayout(FramerFactory.current.newLayoutManager());
        this.setBorder(BorderFactory.createTitledBorder("Race Specification"));
    }

    protected void initChildComponents() {
        this.initRaceIdentifierPanel();
        this.initRaceClassesItems();
        this.initCourseArrangementItems();
    }

    protected void initRaceIdentifierPanel() {
        this.raceIdentifierPanel = new RaceIdentifierPanel();
        this.raceIdentifierPanel.init();
        this.add(this.raceIdentifierPanel);
        FramerFactory.current.installComponent(this.raceIdentifierPanel, this, 1, 168, 0.0f, 0.0f, 0.0f, 2130.0f);
    }

    protected void initRaceClassesItems() {
        this.raceClassesLabel = new JLabel();
        this.raceClassesLabel.setName("raceClassesLabel");
        this.raceClassesLabel.setText("Classes");
        FramerFactory.current.installComponent(this.raceClassesLabel, this, 1, 136, 0.0f, 2130.0f, 852.0f, 315.0f);
        this.raceClassesComboBox = new JComboBox();
        this.raceClassesComboBox.setName("raceClassesComboBox");
        this.myToolServices().installRaceClassTypeRenderer(this.raceClassesComboBox);
        FramerFactory.current.installComponent(this.raceClassesComboBox, this, 1, 184, 876.0f, 2130.0f, 0.599f, 300.0f);
    }

    protected void initCourseArrangementItems() {
        this.courseArrangementLabel = new JLabel();
        this.courseArrangementLabel.setName("courseArrangementLabel");
        this.courseArrangementLabel.setText("Courses");
        FramerFactory.current.installComponent(this.courseArrangementLabel, this, 1, 200, 0.42f, 2130.0f, 876.0f, 315.0f);
        this.courseArrangementComboBox = new JComboBox();
        this.courseArrangementComboBox.setName("courseArrangementComboBox");
        this.myToolServices().installConstantDescriptionRenderer(this.courseArrangementComboBox);
        FramerFactory.current.installComponent(this.courseArrangementComboBox, this, 1, 232, 0.559f, 2130.0f, 0.0f, 300.0f);
    }

    protected RaceSpecificationModel myApp() {
        return this.raceModel;
    }

    public void setModel(RaceSpecificationModel raceModel) {
        this.raceModel = raceModel;
        this.initializeWindow();
    }

    protected void initializeWindow() {
        this.raceIdentifierPanel.setModel(this.raceModel);
        SwingPatches.installComboBoxModel(this.raceClassesComboBox, this.raceModel.getRaceClassClassModel());
        SwingPatches.installComboBoxModel(this.courseArrangementComboBox, this.raceModel.getCourseArrangementModel());
    }

    public void addRaceClassChangedListener(final EvaluableAction oneArgAction) {
        this.raceClassesComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    oneArgAction.evaluate(new Object[]{RaceSpecificationPanel.this.myApp().getSelectedRaceClassType()});
                }
            }
        });
    }
}

