/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.javax.swing.OperationAction;
import com.glaivestone.mv.ValueChangeEvent;
import com.glaivestone.mv.ValueChangeListener;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.tools.ui.RacerListEditor;
import org.ussamasters.aces.tools.ui.swing.RSTFrameWindow;
import org.ussamasters.aces.tools.ui.swing.RacerListEditorPanel;

public class RacerListEditorWindow
extends RSTFrameWindow {
    public static final float DEFAULT_WIDTH_TWIPS = 10665.0f;
    public static final float DEFAULT_HEIGHT_TWIPS = 5895.0f;
    protected JMenuBar menuBar;
    protected JButton saveButton;
    protected RacerListEditorPanel racerListEditorPanel;
    protected OperationAction saveAction;

    @Override
    public void initMainWindow() {
        super.initMainWindow();
        this.frameWindow.setTitle("Racer List Editor");
        this.menuBar = new JMenuBar();
        this.setDefaultWindowSize();
    }

    @Override
    public void initContentPanel() {
        super.initContentPanel();
        this.contentPanel.setLayout(FramerFactory.current.newLayoutManager());
    }

    @Override
    public void initChildComponents() {
        this.initRacerListEditorPanel();
        this.initSaveButton();
    }

    protected void initRacerListEditorPanel() {
        this.racerListEditorPanel = new RacerListEditorPanel();
        this.racerListEditorPanel.setName("racerListEditorPanel");
        FramerFactory.current.installComponent(this.racerListEditorPanel, this.contentPanel, 1, 170, 0.0f, 0.0f, 0.0f, 510.0f);
    }

    public void initSaveButton() {
        this.saveButton = new JButton();
        this.saveButton.setName("saveButton");
        this.saveButton.setText("Save");
        this.saveButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.saveButton, this.contentPanel, 1, 66, 0.5f, 315.0f, 825.0f, 0.0f);
    }

    public void setDefaultWindowSize() {
        FramerFactory.current.setWindowSize(this, 1, 136, 930.0f, 735.0f, 10665.0f, 5895.0f);
    }

    protected RacerListEditor myApp() {
        return (RacerListEditor)this.getAppModel();
    }

    @Override
    protected void initializeWindow() {
        this.initOperationActions();
        this.configureAppNameWindowTitle();
        this.racerListEditorPanel.setEditor(this.myApp().getRacerListEditor());
        this.updateSaveOperation();
        this.buildMenuBar();
        this.configureConnections();
    }

    protected void initOperationActions() {
        this.saveAction = this.myToolServices().constructSaveAction("Save competitors list changes.", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RacerListEditorWindow.this.saveChanges();
            }
        });
    }

    protected void buildMenuBar() {
        this.frameWindow.setJMenuBar(this.menuBar);
        this.menuBar.add(this.buildFileMenu());
        this.menuBar.add(this.buildRacerMenu());
        this.menuBar.add(this.myToolServices().buildStandardHelpMenu(this.frameWindow));
    }

    protected JMenu buildFileMenu() {
        JMenu aMenu = this.myToolServices().constructFileMenu();
        this.saveAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.myToolServices().appendApplicationCloseItem(aMenu, this.frameWindow);
        return aMenu;
    }

    protected JMenu buildRacerMenu() {
        JMenu aMenu = new JMenu("Racer");
        this.racerListEditorPanel.appendRacerOperations(aMenu);
        return aMenu;
    }

    protected void configureConnections() {
        this.myApp().getHasChangesHolder().addChangeListener(new ValueChangeListener(){

            @Override
            public void valueChanged(ValueChangeEvent event) {
                RacerListEditorWindow.this.updateSaveOperation();
            }
        });
        this.saveButton.setAction(this.saveAction);
    }

    protected void saveChanges() {
        try {
            this.myApp().saveChanges();
        }
        catch (RaceDataIOException ex) {
            MessageDialog.displayError("Save Changes Failed", "Unable to save racer list changes: " + ex.getMessage(), this.frameWindow);
        }
    }

    protected void updateSaveOperation() {
        this.saveAction.setEnabled(this.myApp().hasUnsavedChanges());
    }

    protected void reportImportFailure(Exception ex) {
        DebugSupport.current().dump("****ERROR: " + ex.getLocalizedMessage());
        DebugSupport.current().dumpStack(ex, 10);
        MessageDialog.displayError("Import Failed", ex.getLocalizedMessage(), this.frameWindow);
    }

    public static void main(String[] args) {
        RacerListEditor.initiateSession();
        RacerListEditor appModel = new RacerListEditor();
        appModel.openWindow(new RacerListEditorWindow());
    }
}

