/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.javax.swing.OperationAction;
import com.glaivestone.mv.ApplicationView;
import com.glaivestone.mv.ValueChangeEvent;
import com.glaivestone.mv.ValueChangeListener;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.tools.ui.ChooseRaceDialog;
import org.ussamasters.aces.tools.ui.ScoredRaceSeriesModel;
import org.ussamasters.aces.tools.ui.swing.RSTPanel;

public class ScoredRaceSeriesPanel
extends RSTPanel {
    protected JScrollPane scoredRacesScrollPane;
    protected JLabel scoredRacesListLabel;
    protected JButton editRacersButton;
    protected JButton reconcileRaceCompetitorsButton;
    protected JButton reconcileAllButton;
    protected JLabel numRacesField;
    protected JTable scoredRacesTable;
    protected JButton addRaceDataButton;
    protected ScoredRaceSeriesModel model;
    protected OperationAction addRaceAction;
    protected OperationAction removeRaceAction;
    protected OperationAction reconcileRaceCompetitorsAction;
    protected OperationAction reconcileAllRacesAction;
    protected OperationAction editRacerListAction;
    protected OperationAction importRacerListAction;
    protected JPopupMenu scoredRacesPanePopupMenu;

    public ScoredRaceSeriesPanel() {
        this.init();
    }

    protected void init() {
        this.initSelf();
        this.initChildComponents();
    }

    protected void initSelf() {
        this.setName("scoredRaceSeriesPanel");
        this.setBorder(BorderFactory.createTitledBorder("Scored Races"));
        this.setLayout(FramerFactory.current.newLayoutManager());
    }

    protected void initChildComponents() {
        this.initScoredRacesListItems();
        this.initNumRacesField();
        this.initAddRaceDataButton();
        this.initValidateRaceButton();
        this.initValidateAllButton();
        this.initEditRacersButton();
    }

    protected void initScoredRacesListItems() {
        this.scoredRacesListLabel = new JLabel();
        this.scoredRacesListLabel.setName("scoredRacesListLabel");
        this.scoredRacesListLabel.setText("Scored Races:");
        FramerFactory.current.installComponent(this.scoredRacesListLabel, this, 1, 136, 0.0f, 0.0f, 1365.0f, 315.0f);
        this.scoredRacesScrollPane = new JScrollPane();
        this.scoredRacesScrollPane.setName("scoredRacesScrollPane");
        FramerFactory.current.installComponent(this.scoredRacesScrollPane, this, 1, 170, 0.0f, 360.0f, 1440.0f, 465.0f);
        this.scoredRacesTable = new JTable();
        this.scoredRacesTable.setName("scoredRacesTable");
        this.scoredRacesScrollPane.setViewportView(this.scoredRacesTable);
    }

    protected void initNumRacesField() {
        this.numRacesField = new JLabel();
        this.numRacesField.setName("numRacesField");
        this.numRacesField.setText("Number of races: <nn>");
        FramerFactory.current.installComponent(this.numRacesField, this, 1, 130, 0.0f, 315.0f, 2295.0f, 0.0f);
    }

    protected void initAddRaceDataButton() {
        this.addRaceDataButton = new JButton();
        this.addRaceDataButton.setName("addRaceDataButton");
        this.addRaceDataButton.setText("Add...");
        this.addRaceDataButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.addRaceDataButton, this, 1, 40, 825.0f, 360.0f, 9.0f, 315.0f);
    }

    protected void initValidateRaceButton() {
        this.reconcileRaceCompetitorsButton = new JButton();
        this.reconcileRaceCompetitorsButton.setName("reconcileRaceCompetitorsAction");
        this.reconcileRaceCompetitorsButton.setText("Validate");
        this.reconcileRaceCompetitorsButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.reconcileRaceCompetitorsButton, this, 1, 40, 825.0f, 825.0f, 0.0f, 315.0f);
    }

    protected void initValidateAllButton() {
        this.reconcileAllButton = new JButton();
        this.reconcileAllButton.setName("reconcileAllButton");
        this.reconcileAllButton.setText("Validate All");
        this.reconcileAllButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.reconcileAllButton, this, 1, 34, 1200.0f, 315.0f, 0.0f, 465.0f);
    }

    protected void initEditRacersButton() {
        this.editRacersButton = new JButton();
        this.editRacersButton.setName("editRacersButton");
        this.editRacersButton.setText("Edit Racer List");
        this.editRacersButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.editRacersButton, this, 1, 34, 1590.0f, 315.0f, 0.0f, 0.0f);
    }

    protected ScoredRaceSeriesModel myApp() {
        return this.model;
    }

    protected void setModel(ScoredRaceSeriesModel model) {
        this.model = model;
        this.initializeWindow();
    }

    public JPopupMenu getScoredRacesPanePopupMenu() {
        return this.scoredRacesPanePopupMenu;
    }

    protected void initializeWindow() {
        this.initOperationActions();
        this.scoredRacesTable.setModel(this.myApp().getRaceSeriesTableHolder().getDataModel());
        this.scoredRacesTable.setSelectionModel(this.myApp().getRaceSeriesTableHolder().getSelectionModel());
        this.myToolServices().installNoDirectEditLAF(this.scoredRacesTable);
        this.updateRaceSeriesItems();
        this.updateSelectedRaceOperations();
        this.scoredRacesPanePopupMenu = this.buildScoredRacesPanePopupMenu();
        this.configureConnections();
    }

    protected void initOperationActions() {
        final Window frameWindow = this.getMainWindow();
        this.addRaceAction = new OperationAction("Add race...", "Add a race to the list of scored races", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ScoredRaceSeriesPanel.this.addRaceData();
            }
        });
        this.removeRaceAction = new OperationAction("Remove", "Remove the selected race from the list of scored races", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ScoredRaceSeriesPanel.this.removeRace();
            }
        });
        this.reconcileRaceCompetitorsAction = this.myToolServices().constructReconcileRaceCompetitorsAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ScoredRaceSeriesPanel.this.myToolServices().reconcileRaceResult(ScoredRaceSeriesPanel.this.myApp().getSelectedRaceResult(), frameWindow);
            }
        });
        this.reconcileAllRacesAction = new OperationAction("Reconcile All", "Reconcile the competitors in all scored races against the registered racers list", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ScoredRaceSeriesPanel.this.myToolServices().reconcileAllSeriesRaces(ScoredRaceSeriesPanel.this.myApp().getRaceSeries(), true, frameWindow);
            }
        });
        this.editRacerListAction = this.myToolServices().constructLaunchRacerListEditorAction();
        this.importRacerListAction = this.myToolServices().constructImportRacerListAction((ApplicationView)((Object)frameWindow));
    }

    public JMenu buildSeriesMenu(OperationAction[] clientActions) {
        JMenu aMenu = new JMenu("Series");
        aMenu.setToolTipText("Scored race series operations");
        if (clientActions != null) {
            for (int i = 0; i < clientActions.length; ++i) {
                clientActions[i].appendTo(aMenu);
            }
            aMenu.addSeparator();
        }
        this.addRaceAction.appendTo(aMenu);
        this.removeRaceAction.appendTo(aMenu);
        this.reconcileRaceCompetitorsAction.appendTo(aMenu);
        this.reconcileAllRacesAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.importRacerListAction.appendTo(aMenu);
        this.editRacerListAction.appendTo(aMenu);
        return aMenu;
    }

    protected JPopupMenu buildScoredRacesPanePopupMenu() {
        JPopupMenu aMenu = new JPopupMenu();
        this.addRaceAction.appendTo(aMenu);
        this.removeRaceAction.appendTo(aMenu);
        this.reconcileRaceCompetitorsAction.appendTo(aMenu);
        this.reconcileAllRacesAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.editRacerListAction.appendTo(aMenu);
        return aMenu;
    }

    protected void configureConnections() {
        this.myToolServices().registerPanePopupHandler(this.scoredRacesTable, this.scoredRacesPanePopupMenu);
        this.myApp().getRaceSeriesTableHolder().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                ScoredRaceSeriesPanel.this.updateSelectedRaceOperations();
            }
        });
        String label = this.addRaceDataButton.getText();
        this.addRaceDataButton.setAction(this.addRaceAction);
        this.addRaceDataButton.setText(label);
        this.reconcileRaceCompetitorsButton.setAction(this.reconcileRaceCompetitorsAction);
        this.reconcileAllButton.setAction(this.reconcileAllRacesAction);
        this.editRacersButton.setAction(this.editRacerListAction);
        this.myApp().getNumberOfRacesHolder().addChangeListener(new ValueChangeListener(){

            @Override
            public void valueChanged(ValueChangeEvent event) {
                ScoredRaceSeriesPanel.this.updateRaceSeriesItems();
            }
        });
    }

    public void enableEventOperations(boolean enabled) {
        this.addRaceAction.setEnabled(enabled);
        this.reconcileAllRacesAction.setEnabled(enabled);
    }

    protected void updateSelectedRaceOperations() {
        boolean hasRaceSelection = this.myApp().getSelectedRaceResult() != null;
        this.removeRaceAction.setEnabled(hasRaceSelection);
        this.reconcileRaceCompetitorsAction.setEnabled(hasRaceSelection);
    }

    protected void updateRaceSeriesItems() {
        int nRaces = this.myApp().getNumberOfRacesHolder().getValue();
        this.numRacesField.setText("Number of races: " + nRaces);
        this.reconcileAllButton.setEnabled(nRaces > 0);
    }

    protected void addRaceData() {
        RaceSeries candidateRaces = this.myApp().getCandidateRaceAdditions();
        if (candidateRaces.size() == 0) {
            MessageDialog.displayWarning("No Additional Races Available", "There are no completed races on the schedule which can be added to the scoring series at this time.", this.getMainWindow());
            return;
        }
        RaceIdentifier selectedRace = ChooseRaceDialog.openOn(candidateRaces, this.getMainWindow());
        if (selectedRace == null) {
            return;
        }
        try {
            this.myApp().addRace(selectedRace);
        }
        catch (RaceDataIOException ex) {
            this.reportAddRaceFailure(ex);
            return;
        }
        catch (RuntimeException ex) {
            this.reportAddRaceFailure(ex);
            return;
        }
    }

    protected void removeRace() {
        RaceIdentifier selectedRace = this.myApp().getSelectedRace();
        if (selectedRace == null) {
            return;
        }
        String msg = "Are you sure you want to remove " + selectedRace.toDescriptionString() + " from the races being scored?";
        if (!MessageDialog.confirm(msg, this.getMainWindow())) {
            return;
        }
        try {
            this.myApp().removeRace(selectedRace);
        }
        catch (RaceDataIOException ex) {
            this.reportRemoveRaceFailure(ex);
            return;
        }
        catch (RuntimeException ex) {
            this.reportRemoveRaceFailure(ex);
            return;
        }
    }

    protected void reportAddRaceFailure(Exception ex) {
        DebugSupport.current().dump("***ERROR ADDING RACE: " + ex.getMessage());
        DebugSupport.current().dumpStack(ex);
        MessageDialog.displayError("Add Race Failed", "Unable to load race result data: " + ex.getMessage(), this.getMainWindow());
    }

    protected void reportRemoveRaceFailure(Exception ex) {
        DebugSupport.current().dump("***ERROR REMOVING RACE: " + ex.getMessage());
        DebugSupport.current().dumpStack(ex);
        MessageDialog.displayError("REmove Race Failed", "Unable to remove race: " + ex.getMessage(), this.getMainWindow());
    }
}

