/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.events;

import org.w3c.dom.events.EventListener;

public class EventListenerList {
    private Entry first;
    private int n = 0;

    public EventListener[] getEventListeners() {
        if (this.first == null) {
            return null;
        }
        EventListener[] listeners = new EventListener[this.n];
        Entry current = this.first;
        int i = 0;
        while (i < this.n) {
            listeners[i] = current.listener;
            ++i;
            current = current.next;
        }
        return listeners;
    }

    public void add(EventListener listener) {
        this.first = new Entry(listener, this.first);
        ++this.n;
    }

    public void remove(EventListener listener) {
        if (this.first == null) {
            return;
        }
        if (this.first.listener == listener) {
            this.first = this.first.next;
            --this.n;
        } else {
            Entry prev = this.first;
            Entry e = this.first.next;
            while (e != null && e.listener != listener) {
                prev = e;
                e = e.next;
            }
            if (e != null) {
                prev.next = e.next;
                --this.n;
            }
        }
    }

    public boolean contains(EventListener listener) {
        Entry e = this.first;
        while (e != null) {
            if (listener == e.listener) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public int size() {
        return this.n;
    }

    private static class Entry {
        EventListener listener;
        Entry next;

        public Entry(EventListener listener, Entry next) {
            this.listener = listener;
            this.next = next;
        }
    }
}

