/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.devx;

import com.glaivestone.javax.devx.AssertionException;
import com.glaivestone.javax.execution.SessionManager;

public class Assert {
    public static boolean evaluateAssertions = true;
    public static boolean continueIfAssertionFails = false;
    public static boolean exitSystemOnAssertionFailure = true;
    public static boolean clientHandlesAssertionExceptions = false;
    public static int terminationStackDumpDepth = 8;
    public static int continuableStackDumpDepth = 4;
    public static final String SESSION_OPTION_EVALUATE_ASSERTIONS = "Assert.evaluateAssertions";
    public static final String SESSION_OPTION_CONTINUE_IF_ASSERTION_FAILS = "Assert.continueIfAssertionFails";
    public static final String SESSION_OPTION_EXIT_SYSTEM_ON_ASSERTION_FAILURE = "Assert.exitSystemOnAssertionFailure";
    protected static final String STANDARD_ASSERTION_FAILURE_MESSAGE = "*****Assertion Failed*****";

    private Assert() {
    }

    public static void equals(Object aValue, Object anotherValue, String failureMessage) {
        if (!evaluateAssertions) {
            return;
        }
        if (aValue == null ? anotherValue != null : !aValue.equals(anotherValue)) {
            Assert.reportAssertionFailure("*****Assertion Failed***** " + failureMessage, continueIfAssertionFails);
        }
    }

    public static void expected(boolean condition, String failureMessage) {
        if (!evaluateAssertions) {
            return;
        }
        if (!condition) {
            Assert.reportAssertionFailure("*****Assertion Failed***** " + failureMessage, true);
        }
    }

    public static void isNull(Object aValue, String failureMessage) {
        if (!evaluateAssertions) {
            return;
        }
        if (aValue != null) {
            Assert.reportAssertionFailure("*****Assertion Failed***** " + failureMessage, continueIfAssertionFails);
        }
    }

    public static void isTrue(boolean condition) {
        if (!evaluateAssertions) {
            return;
        }
        if (!condition) {
            Assert.reportAssertionFailure(STANDARD_ASSERTION_FAILURE_MESSAGE, continueIfAssertionFails);
        }
    }

    public static void isTrue(boolean condition, String failureMessage) {
        if (!evaluateAssertions) {
            return;
        }
        if (!condition) {
            Assert.reportAssertionFailure("*****Assertion Failed***** " + failureMessage, continueIfAssertionFails);
        }
    }

    public static void notNull(Object aValue, String failureMessage) {
        if (!evaluateAssertions) {
            return;
        }
        if (aValue == null) {
            Assert.reportAssertionFailure("*****Assertion Failed***** " + failureMessage, continueIfAssertionFails);
        }
    }

    public static void sameObject(Object aValue, Object anotherValue, String failureMessage) {
        if (!evaluateAssertions) {
            return;
        }
        if (aValue != anotherValue) {
            Assert.reportAssertionFailure("*****Assertion Failed***** " + failureMessage, continueIfAssertionFails);
        }
    }

    public static void shouldNotBe() {
        if (!evaluateAssertions) {
            return;
        }
        Assert.reportAssertionFailure(STANDARD_ASSERTION_FAILURE_MESSAGE, true);
    }

    public static void shouldNotBe(String failureMessage) {
        if (!evaluateAssertions) {
            return;
        }
        Assert.reportAssertionFailure("*****Assertion Failed***** " + failureMessage, true);
    }

    static void reportAssertionFailure(String message, boolean continueExecution) {
        if (clientHandlesAssertionExceptions) {
            throw new AssertionException(message);
        }
        try {
            throw new AssertionException(message);
        }
        catch (AssertionException ex) {
            StackTraceElement[] callStack = ex.getStackTrace();
            int nTopEntriesToSkip = 2;
            int nEntriesToDump = Math.min(continueExecution ? continuableStackDumpDepth : terminationStackDumpDepth, callStack.length - nTopEntriesToSkip);
            System.err.println();
            System.err.println(ex.getMessage());
            for (int i = nTopEntriesToSkip; i < nTopEntriesToSkip + nEntriesToDump; ++i) {
                System.err.println(callStack[i].toString());
            }
            if (continueExecution || !exitSystemOnAssertionFailure) {
                return;
            }
            System.out.println("\nExecution terminated by " + Assert.class.getName());
            SessionManager.current.shutdown();
            return;
        }
    }

    public static void processSessionOptions() {
        Boolean optionValue = (Boolean)SessionManager.current.getOption(SESSION_OPTION_EVALUATE_ASSERTIONS);
        if (optionValue != null) {
            evaluateAssertions = optionValue;
        }
        if ((optionValue = (Boolean)SessionManager.current.getOption(SESSION_OPTION_CONTINUE_IF_ASSERTION_FAILS)) != null) {
            continueIfAssertionFails = optionValue;
        }
        if ((optionValue = (Boolean)SessionManager.current.getOption(SESSION_OPTION_EXIT_SYSTEM_ON_ASSERTION_FAILURE)) != null) {
            exitSystemOnAssertionFailure = optionValue;
        }
    }
}

