/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.devx;

import com.glaivestone.javax.lang.SystemConstants;
import java.io.PrintStream;

public class DebugSupport {
    public static final int DEFAULT_STACK_TRACE_DEPTH = 8;
    public static final int STACK_DEPTH_ALL = Integer.MAX_VALUE;
    public static final DebugSupport CURRENT = new DebugSupport();
    public static boolean debugEnabled = false;
    public static int defaultStackTraceDepth = 8;

    public static DebugSupport current() {
        return CURRENT;
    }

    protected DebugSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(byte[] bytes) {
        if (this.isDebugLoggingEnabled()) {
            PrintStream ps;
            PrintStream printStream = ps = this.getDebugTarget();
            synchronized (printStream) {
                ps.print("[");
                for (int i = 0; i < bytes.length - 1; ++i) {
                    ps.print(" " + bytes[i] + ",");
                }
                ps.print(" " + bytes[bytes.length - 1] + " ]");
                ps.print(SystemConstants.NEW_LINE);
            }
        }
    }

    public void dump(Object obj) {
        this.println(obj.toString());
    }

    public void dump(String aString) {
        this.println(aString);
    }

    public void dumpStack(Throwable thrown) {
        if (this.isDebugLoggingEnabled()) {
            DebugSupport.printStackTrace(thrown, Integer.MAX_VALUE, 0, this.getDebugTarget());
        }
    }

    public void dumpStack(Throwable thrown, int nLevels) {
        this.dumpStack(thrown, nLevels, 0);
    }

    public void dumpStack(Throwable thrown, int nLevels, int nLevelsToSkip) {
        if (this.isDebugLoggingEnabled()) {
            DebugSupport.printStackTrace(thrown, nLevels, nLevelsToSkip, this.getDebugTarget());
        }
    }

    protected PrintStream getDebugTarget() {
        return System.out;
    }

    protected boolean isDebugLoggingEnabled() {
        return DebugSupport.isDebugEnabled();
    }

    public void print(String aString) {
        if (this.isDebugLoggingEnabled()) {
            this.getDebugTarget().print(aString);
        }
    }

    public void println(String aString) {
        if (this.isDebugLoggingEnabled()) {
            this.getDebugTarget().println(aString);
        }
    }

    public static void disableDebug() {
        debugEnabled = false;
    }

    public static void enableDebug() {
        debugEnabled = true;
    }

    public static boolean isDebugEnabled() {
        return debugEnabled;
    }

    public static void printStackTrace(Throwable anException) {
        DebugSupport.printStackTrace(anException, defaultStackTraceDepth, 0);
    }

    public static void printStackTrace(Throwable anException, int nLevels) {
        DebugSupport.printStackTrace(anException, nLevels, 0);
    }

    public static void printStackTrace(Throwable anException, int nLevels, int nLevelsToSkip) {
        DebugSupport.printStackTrace(anException, nLevels, nLevelsToSkip, System.err);
    }

    protected static void printStackTrace(Throwable anException, int nLevels, int nLevelsToSkip, PrintStream ps) {
        StackTraceElement[] callStack = anException.getStackTrace();
        int nEntriesToDump = Math.min(nLevels, callStack.length - nLevelsToSkip);
        ps.println();
        ps.println(anException.getMessage());
        for (int i = nLevelsToSkip; i < nLevelsToSkip + nEntriesToDump; ++i) {
            System.err.println(callStack[i].toString());
        }
    }
}

