/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.toolbox.settings;

import com.glaivestone.toolbox.settings.Settings;
import com.glaivestone.toolbox.settings.SettingsHolder;
import com.glaivestone.toolbox.settings.SettingsSection;
import com.glaivestone.toolbox.settings.SettingsSectionCache;
import com.glaivestone.toolbox.settings.SettingsSectionHolder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class SettingsFileHolder
extends SettingsHolder {
    protected File backingFile;
    protected SettingsSectionCache sectionCache;

    public SettingsFileHolder() {
    }

    public SettingsFileHolder(File backingFile) throws IOException {
        this();
        this.loadSettings(backingFile);
    }

    public SettingsFileHolder(Settings settings) {
        super(settings);
    }

    public SettingsFileHolder(Settings settings, File backingFile) {
        this(settings);
        this.setFile(backingFile);
    }

    protected SettingsSectionCache constructSectionCache() {
        return new SettingsSectionCache(this);
    }

    protected SettingsSection createDefaultSection(String sectionName) {
        return this.getSettingsSection().createSection(sectionName);
    }

    public boolean equals(Object anObject) {
        return this.getClass().equals(anObject.getClass()) && this.getFile() != null && this.getFile().equals(((SettingsFileHolder)anObject).getFile());
    }

    @Override
    protected File fileSystemReferenceDirectory() {
        return this.getDirectory();
    }

    public SettingsSection findOrCreateSection(String sectionName) {
        SettingsSection sectionSettings = this.getSettingsSection().getSection(sectionName);
        if (sectionSettings == null) {
            sectionSettings = this.createDefaultSection(sectionName);
        }
        return sectionSettings;
    }

    public File getDirectory() {
        return this.backingFile == null ? null : this.backingFile.getParentFile();
    }

    @Override
    public File getFile() {
        return this.backingFile;
    }

    @Override
    public SettingsFileHolder getFileHolder() {
        return this;
    }

    public String getFileName() {
        return this.backingFile == null ? null : this.backingFile.getName();
    }

    public SettingsSectionHolder getSection(String sectionName, Class<?> sectionHolderClass) {
        return this.getSectionCache().getSection(sectionName, sectionHolderClass);
    }

    protected SettingsSectionCache getSectionCache() {
        if (this.sectionCache == null) {
            this.sectionCache = this.constructSectionCache();
        }
        return this.sectionCache;
    }

    public int hashCode() {
        return this.getFile() != null ? this.getFile().hashCode() : super.hashCode();
    }

    public void loadSettings() throws IOException {
        if (this.getFile() == null) {
            return;
        }
        if (!this.getFile().exists()) {
            throw new FileNotFoundException("No such file: " + this.getFile().getAbsolutePath());
        }
        this.setSettings(this.loadSettingsFromBackingFile(this.getFile()));
    }

    public void loadSettings(File aFile) throws IOException {
        this.setFile(aFile);
        this.loadSettings();
    }

    protected Settings loadSettingsFromBackingFile(File aFile) throws IOException {
        this.subclassResponsibility();
        return null;
    }

    public void saveSettings() throws IOException {
        if (this.getFile() == null) {
            throw new FileNotFoundException("No backing file specified for saving " + this);
        }
        this.saveSettingsToBackingFile(this.getFile());
    }

    public void saveSettings(File aFile) throws IOException {
        this.setFile(aFile);
        this.saveSettings();
    }

    protected void saveSettingsToBackingFile(File aFile) throws IOException {
        this.subclassResponsibility();
    }

    public void setFile(File aFile) {
        this.backingFile = aFile;
    }

    @Override
    public String settingsDescription() {
        String settingsDescription = this.getSettings() != null ? this.getSettings().getDescription() : null;
        String fileDescription = this.getFileHolder() != null ? this.getFileHolder().getFile().getAbsolutePath() : "null";
        String description = settingsDescription != null ? settingsDescription + " from " + fileDescription : fileDescription;
        return description;
    }
}

