/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.toolbox.settings;

import com.glaivestone.javax.io.FileConstants;
import com.glaivestone.javax.io.FileSystemReference;
import com.glaivestone.javax.io.FileSystemServices;
import com.glaivestone.toolbox.settings.Settings;
import com.glaivestone.toolbox.settings.SettingsConstants;
import com.glaivestone.toolbox.settings.SettingsFileHolder;
import com.glaivestone.toolbox.settings.SettingsSection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SettingsHolder {
    protected static final String FILE_LIST_STRING_SEPARATOR = ";";
    protected Settings settings;

    public SettingsHolder() {
    }

    public SettingsHolder(Settings settings) {
        this();
        this.setSettings(settings);
    }

    public List<File> fileValueListFromString(String aSpecificationString) {
        return this.fileValueListFromString(aSpecificationString, this.fileSystemReferenceDirectory());
    }

    public List<File> fileValueListFromString(String aSpecificationString, File referenceDirectory) {
        StringTokenizer tokenizer = new StringTokenizer(aSpecificationString, FILE_LIST_STRING_SEPARATOR);
        ArrayList<File> values = new ArrayList<File>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            String fsReference = tokenizer.nextToken();
            File fsElement = SettingsHolder.resolvePathNameValue(fsReference, referenceDirectory);
            values.add(fsElement);
        }
        return values;
    }

    public String fileValueListToString(List<File> values) {
        return this.fileValueListToString(values, this.fileSystemReferenceDirectory());
    }

    public String fileValueListToString(List<File> values, File referenceDirectory) {
        StringBuffer buffer = new StringBuffer();
        for (File fsElement : values) {
            String fsReference = SettingsHolder.asPathNameValue(fsElement, referenceDirectory);
            if (buffer.length() > 0) {
                buffer.append(FILE_LIST_STRING_SEPARATOR);
            }
            buffer.append(fsReference);
        }
        return buffer.toString();
    }

    protected File fileSystemReferenceDirectory() {
        this.subclassResponsibility();
        return null;
    }

    public File getFile() {
        SettingsFileHolder aFileHolder = this.getFileHolder();
        return aFileHolder == null ? null : aFileHolder.getFile();
    }

    public SettingsFileHolder getFileHolder() {
        return null;
    }

    public File getFileValue(String name) {
        return this.getFileValue(name, this.fileSystemReferenceDirectory());
    }

    public File getFileValue(String name, File referenceDirectory) {
        String fsReference = this.getSettings().getStringValue(name);
        return fsReference == null ? null : SettingsHolder.resolvePathNameValue(fsReference, referenceDirectory);
    }

    public List<File> getFileValueList(String name) {
        return this.getFileValueList(name, this.fileSystemReferenceDirectory());
    }

    public List<File> getFileValueList(String name, File referenceDirectory) {
        List<String> referencesList = this.getSettings().getStringValueList(name);
        if (referencesList == null) {
            return new ArrayList<File>(0);
        }
        ArrayList<File> values = new ArrayList<File>(referencesList.size());
        for (String fsReference : referencesList) {
            File fsElement = SettingsHolder.resolvePathNameValue(fsReference, referenceDirectory);
            values.add(fsElement);
        }
        return values;
    }

    public Object getNormalizedValue(String name) {
        String aValue = this.getSettings().getStringValue(name);
        return aValue == null ? null : this.normalizeValue(aValue);
    }

    public SettingsSection getSection(String sectionName) {
        return this.getSettingsSection().getSection(sectionName);
    }

    public SettingsSection getOptionalSection(String sectionName) {
        return this.getSettingsSection().getOptionalSection(sectionName);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public SettingsSection getSettingsSection() {
        return (SettingsSection)this.settings;
    }

    public String getStringValue(String name) {
        return this.getSettings().getStringValue(name, "");
    }

    public String getStringValueOrNull(String name) {
        String value = this.getSettings().getStringValue(name);
        return value != null && value.length() > 0 ? value : null;
    }

    protected Object normalizeBooleanValue(String aValue) {
        if (aValue.equals(SettingsConstants.VALUE_TRUE)) {
            return Boolean.TRUE;
        }
        if (aValue.equals(SettingsConstants.VALUE_FALSE)) {
            return Boolean.FALSE;
        }
        return aValue;
    }

    protected Object normalizeIntegerValue(String aValue) {
        try {
            return Integer.valueOf(aValue);
        }
        catch (NumberFormatException ex) {
            return aValue;
        }
    }

    protected Object normalizeValue(String aValue) {
        if (aValue == null || aValue.length() == 0 || aValue.equals("null")) {
            return null;
        }
        Object normalizedValue = this.normalizeBooleanValue(aValue);
        if (normalizedValue != aValue) {
            return normalizedValue;
        }
        normalizedValue = this.normalizeIntegerValue(aValue);
        if (normalizedValue != aValue) {
            return normalizedValue;
        }
        return aValue;
    }

    public void setFileValue(String name, File fsElement) {
        this.setFileValue(name, fsElement, this.fileSystemReferenceDirectory());
    }

    public void setFileValue(String name, File fsElement, File referenceDirectory) {
        String fsReference = SettingsHolder.asPathNameValue(fsElement, referenceDirectory);
        this.getSettings().setStringValue(name, fsReference);
    }

    public void setFileValueList(String name, List<File> values) {
        this.setFileValueList(name, values, this.fileSystemReferenceDirectory());
    }

    public void setFileValueList(String name, List<File> values, File referenceDirectory) {
        ArrayList<String> referencesList = new ArrayList<String>(values.size());
        for (File fsElement : values) {
            String fsReference = SettingsHolder.asPathNameValue(fsElement, referenceDirectory);
            referencesList.add(fsReference);
        }
        this.getSettings().setStringValueList(name, referencesList);
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    protected void subclassResponsibility() {
        throw new UnsupportedOperationException("My subclass should have implemented this method");
    }

    public String toString() {
        return String.format("%s<%s>", this.getClass().getSimpleName(), this.settingsDescription());
    }

    public String settingsDescription() {
        return this.getSettings() != null ? this.getSettings().getDescription() : "null";
    }

    public static String asPathNameValue(File aFileSystemElement) {
        return "-a-" + SettingsHolder.normalizePathReference(aFileSystemElement.getAbsolutePath());
    }

    public static String asPathNameValue(File aFileSystemElement, File aDirectory) {
        String relativePathName = FileSystemReference.computeRelativePath(aFileSystemElement, aDirectory);
        return relativePathName == null ? SettingsHolder.asPathNameValue(aFileSystemElement) : "-r-" + SettingsHolder.normalizePathReference(relativePathName);
    }

    public static String localizePathReference(String fsReference) {
        char hostSeparator = FileConstants.NAME_SEPARATOR_CHAR;
        char standardSeparator = '/';
        return hostSeparator == standardSeparator ? fsReference : fsReference.replace(standardSeparator, hostSeparator);
    }

    public static String normalizePathReference(String fsReference) {
        char hostSeparator = FileConstants.NAME_SEPARATOR_CHAR;
        char standardSeparator = '/';
        return hostSeparator == standardSeparator ? fsReference : fsReference.replace(hostSeparator, standardSeparator);
    }

    public static String[] parsePathNameValue(String aPathNameValue) {
        String[] pathNameParts = new String[]{aPathNameValue, "-a-"};
        int nChars = aPathNameValue.length();
        String prefix = "-a-";
        if (aPathNameValue.startsWith(prefix)) {
            pathNameParts[0] = aPathNameValue.substring(prefix.length(), nChars);
            pathNameParts[1] = prefix;
        }
        if (aPathNameValue.startsWith(prefix = "-r-")) {
            pathNameParts[0] = aPathNameValue.substring(prefix.length(), nChars);
            pathNameParts[1] = prefix;
        }
        return pathNameParts;
    }

    public static File resolveDirectoryReference(String aPathNameValue, File referenceDirectory, boolean createIfNotThere) {
        if (aPathNameValue == null) {
            return null;
        }
        File aDirectory = SettingsHolder.resolvePathNameValue(aPathNameValue.trim(), referenceDirectory);
        if (aDirectory == null) {
            return null;
        }
        try {
            if (!aDirectory.exists()) {
                if (!createIfNotThere) {
                    return null;
                }
                try {
                    aDirectory = FileSystemServices.getCurrent().realizeDirectory(aDirectory);
                    if (aDirectory == null) {
                        return null;
                    }
                }
                catch (IOException ex) {
                    return null;
                }
            }
            return aDirectory.getCanonicalFile();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static File resolvePathNameValue(String aPathNameValue, File referenceDirectory) {
        return SettingsHolder.resolvePathNameValue(SettingsHolder.parsePathNameValue(aPathNameValue), referenceDirectory);
    }

    public static File resolvePathNameValue(String[] pathNameParts, File referenceDirectory) {
        String fsReference = SettingsHolder.localizePathReference(pathNameParts[0]);
        return "-r-".equals(pathNameParts[1]) ? FileSystemReference.resolveRelativePath(referenceDirectory, fsReference) : new File(fsReference);
    }
}

