/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.toolbox.settings;

import com.glaivestone.toolbox.settings.Settings;
import com.glaivestone.toolbox.settings.SettingsCollection;
import com.glaivestone.toolbox.settings.StandardSettingsCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StandardSettings
implements Settings {
    protected static final List<Object> EMPTY_LIST_VALUE = Collections.unmodifiableList(new ArrayList());
    protected static final List<String> EMPTY_STRING_LIST_VALUE = Collections.unmodifiableList(new ArrayList());
    protected SettingsCollection settingsValues;

    public StandardSettings() {
        this.initialize();
    }

    public String getValuesDescription() {
        return this.settingsValues.toString();
    }

    protected SettingsCollection constructSettingsValues() {
        return new StandardSettingsCollection();
    }

    @Override
    public boolean containsSetting(String name) {
        return this.settingsValues.containsSetting(name);
    }

    protected List<Object> emptyList() {
        return new ArrayList<Object>();
    }

    protected List<String> emptyStringList() {
        return new ArrayList<String>();
    }

    protected void initialize() {
        this.settingsValues = this.constructSettingsValues();
    }

    @Override
    public String getDescription() {
        return String.format(" values", this.settingsValues.size());
    }

    @Override
    public List<String> getSettingsNames() {
        return this.settingsValues.getNames();
    }

    @Override
    public boolean getBooleanValue(String name) {
        return this.getBooleanValue(name, false);
    }

    @Override
    public boolean getBooleanValue(String name, boolean valueIfAbsent) {
        String aString = this.getStringValue(name);
        return aString == null ? valueIfAbsent : Boolean.valueOf(aString);
    }

    @Override
    public File getFileValue(String name) {
        return this.getFileValue(name, null);
    }

    @Override
    public File getFileValue(String name, File valueIfAbsent) {
        String fsReference = this.getStringValue(name);
        return fsReference == null ? valueIfAbsent : new File(fsReference);
    }

    @Override
    public int getIntValue(String name) {
        return this.getIntValue(name, -1);
    }

    @Override
    public int getIntValue(String name, int valueIfAbsent) {
        String aString = this.getStringValue(name);
        return aString == null ? valueIfAbsent : Integer.valueOf(aString);
    }

    @Override
    public String getStringValue(String name) {
        return this.getStringValue(name, null);
    }

    @Override
    public String getStringValue(String name, String valueIfAbsent) {
        String value = this.settingsValues.getStringValue(name);
        return value == null ? valueIfAbsent : value;
    }

    @Override
    public List<String> getStringValueList(String name) {
        return this.getStringValueList(name, EMPTY_STRING_LIST_VALUE);
    }

    @Override
    public List<String> getStringValueList(String name, List<String> valueIfAbsent) {
        List<Object> aSequence = this.getValueList(name);
        if (aSequence == null) {
            return valueIfAbsent == EMPTY_STRING_LIST_VALUE ? this.emptyStringList() : valueIfAbsent;
        }
        ArrayList<String> values = new ArrayList<String>(aSequence.size());
        for (Object aValue : aSequence) {
            values.add((String)aValue);
        }
        return values;
    }

    @Override
    public Object getValue(String name) {
        return this.settingsValues.getSimpleValue(name);
    }

    @Override
    public Object getValue(String name, Object valueIfAbsent) {
        Object aValue = this.settingsValues.getSimpleValue(name);
        return aValue == null ? valueIfAbsent : aValue;
    }

    @Override
    public List<Object> getValueList(String name) {
        return this.getValueList(name, EMPTY_LIST_VALUE);
    }

    @Override
    public List<Object> getValueList(String name, List<Object> valueIfAbsent) {
        List<Object> aSequence = this.settingsValues.getListValue(name);
        if (aSequence == null) {
            return valueIfAbsent == EMPTY_LIST_VALUE ? this.emptyList() : valueIfAbsent;
        }
        return new ArrayList<Object>(aSequence);
    }

    @Override
    public void removeValue(String name) {
        this.settingsValues.removeSetting(name);
    }

    @Override
    public void setBooleanValue(String name, boolean value) {
        this.setValue(name, new Boolean(value).toString());
    }

    @Override
    public void setFileValue(String name, File value) {
        this.setValue(name, value.getAbsolutePath());
    }

    @Override
    public void setIntValue(String name, int value) {
        this.setValue(name, Integer.toString(value));
    }

    @Override
    public void setStringValue(String name, String value) {
        this.setValue(name, value);
    }

    @Override
    public void setStringValueList(String name, List<String> values) {
        this.settingsValues.setValue(name, values);
    }

    @Override
    public void setValue(String name, Object value) {
        this.settingsValues.setValue(name, value);
    }
}

