/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.toolbox.settings;

import com.glaivestone.toolbox.settings.Settings;
import com.glaivestone.toolbox.settings.SettingsSection;
import com.glaivestone.toolbox.settings.StandardSettingsSection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class StandardSettingsTextBackingAccessor {
    protected static final String whiteSpaceChars = " \t\r\n\f";
    protected static final String strictKeyValueSeparators = "=:";
    protected static final String keyValueSeparators = "=: \t\r\n\f";
    protected static final String commentChars = "#!";
    protected static final String specialSaveChars = "=: \t\r\n\f#!";
    protected static final String DEFAULT_COMMENT_LINE_PREFIX = "# ";
    protected static final String DEFAULT_VALUE_SEPARATOR = ": ";
    protected static final char SECTION_START_BRACKET = '[';
    protected static final char SECTION_END_BRACKET = ']';
    protected static final String LIST_NAME_SUFFIX = "[]";
    protected static final String LIST_ELEMENT_NAME_PREFIX = "__";
    protected static final String LIST_ELEMENT_NAME_SUFFIX = "_elt";
    protected static final String LATIN_CHARACTER_SET = "8859_1";
    protected static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected static final SettingsSection EMPTY_DEFAULTS = new StandardSettingsSection();
    protected SettingsSection settings;
    protected SettingsSection defaults;

    protected static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static SettingsSection loadFromFile(File aFile) throws IOException {
        StandardSettingsSection settings = new StandardSettingsSection();
        StandardSettingsTextBackingAccessor accessor = new StandardSettingsTextBackingAccessor(settings);
        try (FileInputStream fs = new FileInputStream(aFile);){
            accessor.load(fs);
        }
        return settings;
    }

    public static SettingsSection loadFromString(String settingsText) throws IOException {
        StandardSettingsSection settings = new StandardSettingsSection();
        StandardSettingsTextBackingAccessor accessor = new StandardSettingsTextBackingAccessor(settings);
        try (StringReader input = new StringReader(settingsText);){
            accessor.load(new BufferedReader(input));
        }
        return settings;
    }

    public static void writeToFile(SettingsSection settings, File aFile) throws IOException {
        StandardSettingsTextBackingAccessor.writeToFile(settings, aFile, aFile.getName());
    }

    public static void writeToFile(SettingsSection settings, File aFile, String header) throws IOException {
        StandardSettingsTextBackingAccessor accessor = new StandardSettingsTextBackingAccessor(settings);
        try (FileWriter fs = new FileWriter(aFile);){
            accessor.store(new BufferedWriter(fs), header);
        }
    }

    public static String writeToString(SettingsSection settings) throws IOException {
        return StandardSettingsTextBackingAccessor.writeToString(settings, "Settings");
    }

    public static String writeToString(SettingsSection settings, String header) throws IOException {
        StandardSettingsTextBackingAccessor accessor = new StandardSettingsTextBackingAccessor(settings);
        String result = null;
        try (StringWriter sw = new StringWriter();){
            accessor.store(new BufferedWriter(sw), header);
            result = sw.toString();
        }
        return result;
    }

    public StandardSettingsTextBackingAccessor(SettingsSection settings) {
        this.settings = settings;
        this.defaults = EMPTY_DEFAULTS;
    }

    protected String convertFromStoreString(String aString) {
        int nChars = aString.length();
        StringBuffer sb = new StringBuffer(nChars);
        int i = 0;
        while (i < nChars) {
            int aChar;
            if ((aChar = aString.charAt(i++)) == 92) {
                if ((aChar = aString.charAt(i++)) == 117) {
                    int charCode = 0;
                    block6: for (int j = 0; j < 4; ++j) {
                        aChar = aString.charAt(i++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                charCode = (charCode << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                charCode = (charCode << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                charCode = (charCode << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    aChar = (char)charCode;
                } else if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
            }
            sb.append((char)aChar);
        }
        return sb.toString();
    }

    protected String convertToStoreString(String aString) {
        int nChars = aString.length();
        StringBuffer sb = new StringBuffer(nChars * 2);
        block8: for (int i = 0; i < nChars; ++i) {
            char aChar = aString.charAt(i);
            switch (aChar) {
                case '\\': {
                    sb.append('\\');
                    sb.append('\\');
                    continue block8;
                }
                case '\t': {
                    sb.append('\\');
                    sb.append('t');
                    continue block8;
                }
                case '\n': {
                    sb.append('\\');
                    sb.append('n');
                    continue block8;
                }
                case '\r': {
                    sb.append('\\');
                    sb.append('r');
                    continue block8;
                }
                case '\f': {
                    sb.append('\\');
                    sb.append('f');
                    continue block8;
                }
                case ' ': {
                    sb.append(' ');
                    continue block8;
                }
                default: {
                    if (aChar < '\u0014' || aChar > '\u007f') {
                        sb.append('\\');
                        sb.append('u');
                        sb.append(StandardSettingsTextBackingAccessor.toHex(aChar >> 12 & 0xF));
                        sb.append(StandardSettingsTextBackingAccessor.toHex(aChar >> 8 & 0xF));
                        sb.append(StandardSettingsTextBackingAccessor.toHex(aChar >> 4 & 0xF));
                        sb.append(StandardSettingsTextBackingAccessor.toHex(aChar >> 0 & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        sb.append('\\');
                    }
                    sb.append(aChar);
                }
            }
        }
        return sb.toString();
    }

    protected int indexOfKeyValueSeparator(String aLine, int keyStartIndex) {
        for (int index = keyStartIndex; index < aLine.length(); ++index) {
            if (keyValueSeparators.indexOf(aLine.charAt(index)) == -1) continue;
            return index;
        }
        return -1;
    }

    protected int indexOfNonWhitespace(String aLine, int startIndex) {
        for (int index = startIndex; index < aLine.length(); ++index) {
            if (whiteSpaceChars.indexOf(aLine.charAt(index)) != -1) continue;
            return index;
        }
        return -1;
    }

    protected boolean isBlankOrCommentLine(String aLine) {
        if (aLine.length() == 0) {
            return true;
        }
        char firstChar = aLine.charAt(0);
        if (firstChar == '#' || firstChar == '!') {
            return true;
        }
        return this.indexOfNonWhitespace(aLine, 0) == -1;
    }

    protected boolean hasContinuationLine(String aLine) {
        int nTrailingSlashes = 0;
        int index = aLine.length() - 1;
        while (index >= 0 && aLine.charAt(index--) == '\\') {
            ++nTrailingSlashes;
        }
        return nTrailingSlashes % 2 == 1;
    }

    public synchronized void load(InputStream inStream) throws IOException {
        this.load(new BufferedReader(new InputStreamReader(inStream, LATIN_CHARACTER_SET)));
    }

    protected void load(BufferedReader aReader) throws IOException {
        String inputLine;
        SettingsSection currentSection = this.settings;
        ArrayList<String> currentList = null;
        String currentListElementName = null;
        while ((inputLine = this.readLine(aReader)) != null) {
            String settingName;
            int nChars = inputLine.length();
            int keyStartIndex = this.indexOfNonWhitespace(inputLine, 0);
            int separatorStartIndex = this.indexOfKeyValueSeparator(inputLine, keyStartIndex);
            String key = separatorStartIndex == -1 ? inputLine.substring(keyStartIndex, nChars) : inputLine.substring(keyStartIndex, separatorStartIndex);
            char firstKeyChar = key.charAt(0);
            char lastKeyChar = key.charAt(key.length() - 1);
            if (firstKeyChar == '[' && lastKeyChar == ']') {
                String sectionName = key.substring(1, key.length() - 1);
                currentSection = this.settings.createSection(sectionName);
                currentList = null;
                currentListElementName = null;
                continue;
            }
            int valueStartIndex = this.indexOfNonWhitespace(inputLine, separatorStartIndex);
            if (valueStartIndex < nChars && strictKeyValueSeparators.indexOf(inputLine.charAt(valueStartIndex)) != -1) {
                ++valueStartIndex;
            }
            valueStartIndex = this.indexOfNonWhitespace(inputLine, valueStartIndex);
            key = this.convertFromStoreString(key);
            String value = this.convertFromStoreString(valueStartIndex < nChars ? inputLine.substring(valueStartIndex, nChars) : "");
            if (key.endsWith(LIST_NAME_SUFFIX)) {
                int nElements;
                settingName = key.substring(0, key.length() - LIST_NAME_SUFFIX.length());
                try {
                    nElements = Integer.parseInt(value);
                }
                catch (NumberFormatException ex) {
                    nElements = 0;
                }
                currentList = new ArrayList<String>(nElements);
                currentListElementName = LIST_ELEMENT_NAME_PREFIX + settingName + LIST_ELEMENT_NAME_SUFFIX;
                currentSection.setValue(settingName, currentList);
                continue;
            }
            settingName = key;
            if (settingName.equals(currentListElementName)) {
                currentList.add(value);
                continue;
            }
            if (currentListElementName != null) {
                currentList = null;
                currentListElementName = null;
            }
            currentSection.setValue(settingName, value);
        }
    }

    protected String readLine(BufferedReader aReader) throws IOException {
        String inputLine;
        do {
            if ((inputLine = aReader.readLine()) != null) continue;
            return null;
        } while (this.isBlankOrCommentLine(inputLine));
        while (this.hasContinuationLine(inputLine)) {
            String loppedInputLine = inputLine.substring(0, inputLine.length() - 1);
            String nextLine = aReader.readLine();
            int continueIndex = nextLine == null ? -1 : this.indexOfNonWhitespace(nextLine, 0);
            inputLine = continueIndex == -1 ? loppedInputLine : new String(loppedInputLine + nextLine.substring(continueIndex, nextLine.length()));
        }
        return this.indexOfNonWhitespace(inputLine, 0) == -1 ? null : inputLine;
    }

    public synchronized void store(OutputStream outStream, String header) throws IOException {
        this.store(new BufferedWriter(new OutputStreamWriter(outStream, LATIN_CHARACTER_SET)), header);
    }

    protected void store(BufferedWriter aWriter, String header) throws IOException {
        this.writeHeaderSection(aWriter, header);
        aWriter.newLine();
        this.writeSettingsValues(aWriter, this.settings, this.defaults);
        for (String sectionName : this.settings.getSectionNames()) {
            SettingsSection aSubsection = this.settings.getSection(sectionName);
            SettingsSection subsectionDefaults = this.defaults.getSection(sectionName);
            if (subsectionDefaults == null) {
                subsectionDefaults = EMPTY_DEFAULTS;
            }
            aWriter.newLine();
            this.writeLine(aWriter, "[" + sectionName + ']');
            this.writeSettingsValues(aWriter, aSubsection, subsectionDefaults);
        }
        aWriter.flush();
    }

    protected void writeHeaderSection(BufferedWriter aWriter, String header) throws IOException {
        if (header != null && header.length() > 0) {
            this.writeCommentLine(aWriter, header);
        }
        this.writeCommentLine(aWriter, new Date().toString());
    }

    protected void writeSetting(BufferedWriter aWriter, String name, String value) throws IOException {
        this.writeLine(aWriter, this.convertToStoreString(name) + DEFAULT_VALUE_SEPARATOR + this.convertToStoreString(value));
    }

    protected void writeSetting(BufferedWriter aWriter, String name, List<String> value) throws IOException {
        String listName = this.convertToStoreString(name);
        String settingName = listName + LIST_NAME_SUFFIX;
        this.writeSetting(aWriter, settingName, "" + value.size());
        settingName = LIST_ELEMENT_NAME_PREFIX + listName + LIST_ELEMENT_NAME_SUFFIX;
        for (String anElement : value) {
            this.writeSetting(aWriter, settingName, anElement);
        }
    }

    protected void writeSettingsValues(BufferedWriter aWriter, Settings settingsValues, Settings defaultSettings) throws IOException {
        Object value;
        List<String> settings = settingsValues.getSettingsNames();
        for (String name : settings) {
            value = settingsValues.getValue(name);
            if (value instanceof List) continue;
            this.writeSetting(aWriter, name, (String)value);
        }
        for (String name : settings) {
            value = settingsValues.getValue(name);
            if (!(value instanceof List)) continue;
            this.writeSetting(aWriter, name, (List)value);
        }
    }

    protected void writeCommentLine(BufferedWriter aWriter, String line) throws IOException {
        this.writeLine(aWriter, DEFAULT_COMMENT_LINE_PREFIX + line);
    }

    protected void writeLine(BufferedWriter aWriter, String line) throws IOException {
        aWriter.write(line);
        aWriter.newLine();
    }

    public static void main(String[] args) {
        String settingsText = "foo: value1\nbar: value2\n\n\nzippie= doo da day\n\nhobbies[]: 2\n__hobbies_elt: jogging\n__hobbies_elt: eating\nbazooklie: true\n\n\n[Roots]\nsystemDir: -r-System\n\nclassLoadList[]: 1\n__classLoadList_elt: personal.djl.debug.Assert\n\n[Debug]\ndebug: true\n";
        System.out.println("\n***TEST SETTINGS***");
        System.out.println("STARTING TEXT:");
        System.out.println(settingsText);
        System.out.println("\nROUND TRIP LOAD/STORE:");
        try {
            SettingsSection settings = StandardSettingsTextBackingAccessor.loadFromString(settingsText);
            System.out.println("...loaded " + settings.getSettingsNames().size() + " values, " + settings.getSectionNames().size() + " subsections");
            StandardSettingsTextBackingAccessor.writeToFile(settings, new File("$TestSettings.ini"));
            System.out.println(StandardSettingsTextBackingAccessor.writeToString(settings));
        }
        catch (IOException ex) {
            System.out.println("***ERROR:");
            ex.printStackTrace();
        }
        System.out.println("--end test--");
    }
}

