/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata;

import com.glaivestone.javax.execution.StaticMethodAction;
import com.glaivestone.javax.lang.ConstantValue;
import java.util.List;
import org.ussamasters.javax.io.ResourceFileAccessor;

public class RaceDataSessionManager {
    private static final Class<RaceDataSessionManager> THIS_CLASS = RaceDataSessionManager.class;
    private static final String CONFIG_DIR_REF = "/" + THIS_CLASS.getPackage().getName().replaceAll("\\.", "/") + "/configuration";
    private static boolean initialized = false;
    public static final String INITALIZER_SPECS = CONFIG_DIR_REF + "/initializers/constant-classes.txt";
    public static boolean TRACE_INITIALIZERS = false;

    private RaceDataSessionManager() {
    }

    public static void initializeSession() {
        if (initialized) {
            return;
        }
        List<String> specs = ResourceFileAccessor.readFileLines(INITALIZER_SPECS);
        for (String entry : specs) {
            String className;
            String[] values = entry.split(",");
            if (values.length == 1) {
                className = values[0];
                if (TRACE_INITIALIZERS) {
                    System.out.println("Load class " + className);
                }
                try {
                    Class<?> constantClass;
                    List<ConstantValue<?>> constants;
                    Class<?> loadedClass = Class.forName(className);
                    if (!ConstantValue.class.isAssignableFrom(loadedClass) || (constants = ConstantValue.getConstantValues(constantClass = loadedClass)).size() != 0) continue;
                    throw new RuntimeException("No values registered for constants class " + className);
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                    throw new RuntimeException(ex);
                }
            }
            if (values.length == 2) {
                className = values[0];
                String selector = values[1];
                if (TRACE_INITIALIZERS) {
                    System.out.println("Run initializer " + className + "." + selector + "()");
                }
                try {
                    Class[] emptyParmTypes = new Class[]{};
                    Class<?> loadedClass = Class.forName(className);
                    StaticMethodAction initializer = StaticMethodAction.create(loadedClass, selector, emptyParmTypes);
                    initializer.evaluate();
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                    throw new RuntimeException(ex);
                }
            }
            throw new RuntimeException("Invalid session bootstrap spec: " + entry);
        }
        initialized = true;
    }

    public static void main(String[] args) {
        TRACE_INITIALIZERS = true;
        RaceDataSessionManager.initializeSession();
    }

    static {
        RaceDataSessionManager.initializeSession();
    }
}

