/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.interchange;

import com.glaivestone.javax.io.FileType;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;
import org.ussamasters.aces.racedata.interchange.FISXMLConstants;
import org.ussamasters.aces.racedata.interchange.SplitSecondConstants;
import org.ussamasters.aces.racedata.interchange.TimingSystemDataImporter;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.RaceDataXMLReader;
import org.ussamasters.aces.racedata.models.CompetitorResultValue;
import org.ussamasters.aces.racedata.models.RaceDate;
import org.ussamasters.aces.racedata.models.RaceTime;
import org.ussamasters.aces.racedata.models.RaceType;
import org.ussamasters.aces.racedata.models.UnqualifiedResult;

public class FISXMLReader
extends RaceDataXMLReader {
    private static final String[][] COMPETITOR_INFO_FIELD_SPECS = new String[][]{{"LastName", "Lastname"}, {"FirstName", "Firstname"}, {"USSANumber", "NAT_code"}, {"Class", "Class"}, {"Nation", "Nation"}, {"YearBorn", "Yearofbirth"}, {"Gender", "Gender"}};
    protected Element headerSection;
    protected Element dataSection;
    protected String sector;
    protected String genderIdentifier;
    protected String defaultGender;
    protected String dataSectionName;

    public static boolean isSupportedFormat(String textData) {
        return new FISXMLReader().isSupportedFormatX(textData);
    }

    public FISXMLReader() {
        this.loadHeaderOnly = false;
    }

    @Override
    protected Object resolveColValue(String colName, String value) {
        if (colName.equals("Gender") && value.equals("L")) {
            return "F";
        }
        return value;
    }

    protected Map<String, Object> competitorEntryValuesFromElement(Element compEntryElement, boolean isRanked) throws RaceDataIOException {
        boolean isQualified;
        UnqualifiedResult notRankedStatus;
        String elementName;
        HashMap<String, Object> compEntryValues = new HashMap<String, Object>();
        String value = compEntryElement.getChildTextTrim("Bib");
        compEntryValues.put("Bib", value);
        Element compElement = compEntryElement.getChild("Competitor");
        for (String[] spec : COMPETITOR_INFO_FIELD_SPECS) {
            String colName = spec[0];
            elementName = spec[1];
            if (colName.equals("Gender")) {
                elementName = this.genderIdentifier;
            }
            this.collectCompElementValue(compElement, elementName, colName, compEntryValues);
        }
        String competitorDescription = String.format("%s, %s - bib %s", compEntryValues.get("LastName"), compEntryValues.get("FirstName"), compEntryValues.get("Bib"));
        String attributeName = "Status";
        String status = compEntryElement.getAttributeValue(attributeName);
        if (status == null || status.isEmpty()) {
            this.throwInvalidXmlException(String.format("missing required result %s attribute for competitor %s", attributeName, competitorDescription));
        }
        UnqualifiedResult unqualifiedResult = notRankedStatus = !(isQualified = status.equals("QLF")) ? UnqualifiedResult.getConstant(status) : null;
        if (!isQualified && notRankedStatus == null) {
            this.throwInvalidXmlException(String.format("invalid result %s attribute '%s' for competitor %s", attributeName, value, competitorDescription));
        }
        int notQualifiedRun = 0;
        if (!isQualified) {
            elementName = "Run";
            value = compEntryElement.getChildTextTrim(elementName);
            if (value == null) {
                this.throwInvalidXmlException(String.format("missing required <%s> for unranked competitor %s", elementName, competitorDescription));
            }
            try {
                notQualifiedRun = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                this.throwInvalidXmlException(String.format("invalid %s '%s' for unranked competitor %s", elementName, value, competitorDescription));
            }
        }
        String resultElementName = this.sector + "_result";
        Element resultElement = compEntryElement.getChild(resultElementName);
        CompetitorResultValue<UnqualifiedResult> result = null;
        CompetitorResultValue<UnqualifiedResult> resultRun2 = null;
        UnqualifiedResult resultRun1 = null;
        if (this.raceType.nRuns == 1) {
            resultRun1 = this.competitorRunTimeFromElement(resultElement.getChild("Timerun1"), competitorDescription, null);
            resultRun2 = null;
            if (isQualified) {
                result = this.competitorRunTimeFromElement(resultElement.getChild("Totaltime"), competitorDescription, resultRun1);
            } else {
                if (resultRun1 == null) {
                    resultRun1 = notRankedStatus;
                }
                result = resultRun1;
            }
            if (isQualified) {
                // empty if block
            }
        } else if (this.raceType.nRuns == 2) {
            resultRun1 = this.competitorRunTimeFromElement(resultElement.getChild("Timerun1"), competitorDescription, null);
            resultRun2 = this.competitorRunTimeFromElement(resultElement.getChild("Timerun2"), competitorDescription, null);
            if (isQualified) {
                result = this.competitorRunTimeFromElement(resultElement.getChild("Totaltime"), competitorDescription, null);
            } else {
                if (resultRun1 == null) {
                    resultRun1 = notQualifiedRun == 1 ? notRankedStatus : UnqualifiedResult.DNS;
                }
                if (resultRun2 == null) {
                    resultRun2 = notQualifiedRun == 2 ? notRankedStatus : UnqualifiedResult.DNS;
                }
                result = TimingSystemDataImporter.computeUnqualifiedResultStatus(resultRun1, resultRun2, status);
            }
        } else {
            this.throwInvalidXmlException("Race with " + this.raceType.nRuns + " not yet supported");
        }
        compEntryValues.put("Status", status);
        compEntryValues.put("FirstRun", resultRun1);
        if (resultRun2 != null) {
            compEntryValues.put("SecondRun", resultRun2);
        }
        compEntryValues.put("Total", result);
        if (!compEntryValues.containsKey("Gender")) {
            if (this.defaultGender != null) {
                compEntryValues.put("Gender", this.defaultGender);
            } else {
                this.throwInvalidXmlException(String.format("required gender value missing for competitor %s", competitorDescription));
            }
        }
        return compEntryValues;
    }

    protected CompetitorResultValue<?> competitorRunTimeFromElement(Element compTimeElement, String competitorDescription, CompetitorResultValue<?> valueIfAbsent) throws RaceDataIOException {
        if (compTimeElement == null) {
            return valueIfAbsent;
        }
        String value = compTimeElement.getTextTrim();
        if (value.isEmpty()) {
            return valueIfAbsent;
        }
        CompetitorResultValue<UnqualifiedResult> resultValue = UnqualifiedResult.getConstant(value);
        if (resultValue == null) {
            try {
                resultValue = RaceTime.fromString(value);
            }
            catch (IllegalArgumentException ex) {
                throw new RaceDataIOException(String.format("Invalid competitor result entry: invalid <%s> result '%s' for %s", compTimeElement.getName(), value, competitorDescription));
            }
        }
        return resultValue;
    }

    public List<Map<String, Object>> getCompetitorEntries() {
        return this.competitorEntries;
    }

    protected List<Map<String, Object>> loadCompetitorEntries() throws RaceDataIOException {
        String classifiedCompetitorsSection = this.sector + "_classified";
        String unclassifiedCompetitorsSection = this.sector + "_notclassified";
        ArrayList<Map<String, Object>> competitors = new ArrayList<Map<String, Object>>();
        competitors.addAll(this.loadCompetitorEntries(this.dataSection.getChild(classifiedCompetitorsSection), true));
        competitors.addAll(this.loadCompetitorEntries(this.dataSection.getChild(unclassifiedCompetitorsSection), false));
        return competitors;
    }

    protected List<Map<String, Object>> loadCompetitorEntries(Element competitorsSection, boolean isClassified) throws RaceDataIOException {
        String entryElementName = isClassified ? this.sector + "_ranked" : this.sector + "_notranked";
        List resultElements = competitorsSection.getChildren(entryElementName);
        int nEntries = resultElements.size();
        if (nEntries == 0) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> competitorEntries = new ArrayList<Map<String, Object>>(nEntries);
        for (Element compElement : resultElements) {
            Map<String, Object> compEntryValues = this.competitorEntryValuesFromElement(compElement, isClassified);
            competitorEntries.add(compEntryValues);
        }
        return competitorEntries;
    }

    @Override
    protected void loadData() throws RaceDataIOException {
        this.validateFormat();
        if (this.loadHeaderOnly) {
            this.headerSection = null;
            this.dataSection = null;
            this.document = null;
            return;
        }
        this.raceType = this.resolveRaceType();
        this.raceDate = this.resolveRaceDate();
        this.raceLocation = this.resolveRaceLocation();
        this.competitorEntries = this.loadCompetitorEntries();
    }

    protected RaceDate resolveRaceDate() throws RaceDataIOException {
        String raceheaderElementName = "Raceheader";
        String elementName = "Racedate";
        Element dateElement = this.headerSection.getChild(elementName);
        if (dateElement == null) {
            this.throwInvalidXmlException(String.format("missing required <%s> in <%s>", elementName, "Raceheader"));
        }
        String day = dateElement.getChildTextTrim("Day");
        String monthIndex = dateElement.getChildTextTrim("Month");
        String year = dateElement.getChildTextTrim("Year");
        RaceDate raceDate = null;
        try {
            raceDate = new RaceDate(Integer.parseInt(year), Integer.parseInt(monthIndex), Integer.parseInt(day));
        }
        catch (NumberFormatException ex) {
            this.throwInvalidXmlException(String.format("invalid race date yyyy-mm-dd='%s-%s-%s'", this.normalizeDateValue(year, 4, "?"), this.normalizeDateValue(monthIndex, 2, "?"), this.normalizeDateValue(day, 2, "?")));
        }
        return raceDate;
    }

    protected String normalizeDateValue(String value, int nDigits, String fillChar) {
        String normalizedValue = "";
        if (value == null || value.length() == 0) {
            for (int i = 0; i < nDigits; ++i) {
                normalizedValue = normalizedValue + "?";
            }
        } else {
            normalizedValue = value;
            while (normalizedValue.length() < nDigits) {
                normalizedValue = fillChar + normalizedValue;
            }
        }
        return normalizedValue;
    }

    protected String resolveRaceLocation() {
        String raceLocationName = this.headerSection.getChildTextTrim("Place");
        return raceLocationName;
    }

    protected RaceType resolveRaceType() throws RaceDataIOException {
        int nRunsStandard;
        RaceType raceType;
        int nRuns;
        String raceheaderElementName = "Raceheader";
        String elementName = "Discipline";
        String discipline = this.headerSection.getChildTextTrim(elementName);
        if (discipline == null) {
            this.throwInvalidXmlException(String.format("missing required <%s> element in <%s>", elementName, "Raceheader"));
        }
        if ((nRuns = this.dataSection.getChildren(elementName = "Course").size()) == 0) {
            this.throwInvalidXmlException(String.format("missing required <%s> elements with run data in <%s>", elementName, this.dataSectionName));
        }
        if ((raceType = RaceType.getConstant(discipline)) == null) {
            this.throwInvalidXmlException(String.format("unknown discipline '%s' in <%s>", discipline, "Raceheader"));
        }
        if (nRuns != (nRunsStandard = raceType.nRuns)) {
            try {
                raceType = raceType.getRunCountVariant(nRuns);
            }
            catch (IllegalArgumentException ex) {
                this.throwInvalidXmlException(String.format(" %s race with %s runs not supported (%s expected)", discipline, nRuns, nRunsStandard));
            }
        }
        return raceType;
    }

    protected void throwInvalidXmlException(String reason) throws RaceDataIOException {
        throw new RaceDataIOException("Invalid FIS XML file: " + reason);
    }

    protected void validateFormat() throws RaceDataIOException {
        String attributeName;
        String attributeValue;
        String fisresultsDocumentRootName = "Fisresults";
        String raceheaderElementName = "Raceheader";
        Element rootElement = this.getRootElement();
        String elementName = "Fisresults";
        if (rootElement == null || !rootElement.getName().equals(elementName)) {
            this.throwInvalidXmlException(String.format("not a <%s> document", elementName));
        }
        elementName = "Raceheader";
        this.headerSection = rootElement.getChild(elementName);
        if (this.headerSection == null) {
            this.throwInvalidXmlException(String.format("missing required <%s> element of <%s>", elementName, "Fisresults"));
        }
        if ((attributeValue = this.headerSection.getAttributeValue(attributeName = "Sector")) == null) {
            this.throwInvalidXmlException(String.format("missing required %s attribute for <%s>", attributeName, "Raceheader"));
        }
        if (!FISXMLConstants.SUPPORTED_SECTORS.contains(attributeValue)) {
            this.throwInvalidXmlException(String.format("invalid %s '%s' for <%s>", attributeName, attributeValue, "Raceheader"));
        }
        this.sector = attributeValue;
        attributeName = "Gender";
        attributeValue = this.headerSection.getAttributeValue(attributeName);
        if (attributeValue == null) {
            attributeName = "Sex";
            attributeValue = this.headerSection.getAttributeValue(attributeName);
        }
        if (attributeValue == null) {
            this.throwInvalidXmlException(String.format("missing required %s attribute for <%s>", "Gender", "Raceheader"));
        }
        if (!FISXMLConstants.SUPPORTED_HEADER_GENDERS.contains(attributeValue)) {
            this.throwInvalidXmlException(String.format("invalid %s '%s' for <%s>", attributeName, attributeValue, "Raceheader"));
        }
        this.genderIdentifier = attributeName;
        if (FISXMLConstants.SUPPORTED_COMP_GENDERS.contains(attributeValue)) {
            if (attributeValue.equals("L")) {
                attributeValue = "W";
            }
            this.defaultGender = attributeValue;
        } else {
            this.defaultGender = null;
        }
        elementName = this.sector + "_race";
        this.dataSection = rootElement.getChild(elementName);
        if (this.dataSection == null) {
            this.throwInvalidXmlException(String.format("missing required <%s> element of <%s>", elementName, "Fisresults"));
        }
        this.dataSectionName = elementName;
    }

    public static void describeRace(File aFile, PrintStream out) {
        out.println("\nFIS XML file: " + aFile.getName());
        try {
            FISXMLReader dataReader = new FISXMLReader();
            dataReader.loadFile(aFile);
            RaceType raceType = dataReader.raceType;
            RaceDate raceDate = dataReader.raceDate;
            String location = dataReader.raceLocation;
            out.println("...header: " + (raceType != null ? raceType.name : "<undefined discipline>") + " on " + (raceDate != null ? raceDate.toStandardString() : "<no date>") + " at " + (location != null ? location : "<no location>"));
            out.println("...competitors: " + dataReader.competitorEntries.size());
        }
        catch (Exception ex) {
            out.println("***ERROR: " + ex.toString() + "\n");
        }
    }

    public static void main(String[] args) {
        File sstDir = SplitSecondConstants.SST_ALPINE_DATA_DIR;
        File dataDir = new File(sstDir, "aaaTestSkiXML");
        Object[] files = dataDir.listFiles();
        Arrays.sort(files);
        System.out.println("\n###TEST FIS XML READER###");
        for (int i = 0; i < files.length; ++i) {
            Object aFile = files[i];
            String fileName = ((File)aFile).getName();
            if (!((File)aFile).isFile() || !FileType.XML.sameExtension((File)aFile) || fileName.toLowerCase().startsWith("aaatest")) continue;
            FISXMLReader.describeRace((File)aFile, System.out);
        }
        System.out.println("...done");
    }
}

