/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.interchange;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.interchange.SplitSecondAlpineDataReader;
import org.ussamasters.aces.racedata.interchange.TimingSystemXMLDataImporter;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceDescriptor;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;

public class SplitSecondAlpineImporter
extends TimingSystemXMLDataImporter {
    protected boolean processNonStarters = false;

    public static SplitSecondAlpineImporter importCompetitorData(String timingData, Map<String, String> bibNumberMappingTable, Class<? extends RaceClass<?>> ageClassClass, SeasonIdentifier season, boolean processNonStarters) throws RaceDataIOException {
        SplitSecondAlpineImporter loader = new SplitSecondAlpineImporter();
        loader.processNonStarters = processNonStarters;
        loader.loadCompetitorData(timingData, bibNumberMappingTable, ageClassClass, season);
        return loader;
    }

    public static SplitSecondAlpineImporter importTimingData(String timingData, Map<String, String> bibNumberMappingTable, Map<String, String> startGroupCodesMap, RaceDescriptor raceSpecification, SeasonIdentifier season) throws RaceDataIOException {
        SplitSecondAlpineImporter loader = new SplitSecondAlpineImporter();
        loader.loadData(timingData, bibNumberMappingTable, startGroupCodesMap, raceSpecification, season);
        return loader;
    }

    public static boolean isSupportedFormat(String timingData) {
        boolean ENABLE_XML = false;
        if (ENABLE_XML) {
            return SplitSecondAlpineDataReader.isSupportedFormat(timingData);
        }
        return false;
    }

    protected SplitSecondAlpineDataReader constructTimingDataReader() {
        return new SplitSecondAlpineDataReader();
    }

    protected boolean isStarter(Map<String, Object> entryValues) {
        boolean disabled = true;
        if (disabled) {
            throw new UnsupportedOperationException("FIX THIS - sort out datatypes");
        }
        String competitorStatus = "";
        return competitorStatus.startsWith("DNS") ? "DNS2".equals(competitorStatus) : true;
    }

    public void loadCompetitorData(String timingData, Map<String, String> bibNumberMappingTable, Class<? extends RaceClass<?>> ageClassClass, SeasonIdentifier season) throws RaceDataIOException {
        this.processCompetitorData(this.loadUnprocessedTimingData(timingData), bibNumberMappingTable, ageClassClass, season);
    }

    public void loadData(String timingData, Map<String, String> bibNumberMappingTable, Map<String, String> startGroupCodesMap, RaceDescriptor aRaceSpecification, SeasonIdentifier season) throws RaceDataIOException {
        if (aRaceSpecification == null) {
            throw new IllegalArgumentException("Race specification not provided");
        }
        this.processTimingData(this.loadUnprocessedTimingData(timingData), bibNumberMappingTable, startGroupCodesMap, aRaceSpecification, season);
    }

    protected SplitSecondAlpineDataReader loadUnprocessedTimingData(String data) throws RaceDataIOException {
        SplitSecondAlpineDataReader dataReader = this.constructTimingDataReader();
        try {
            dataReader.load(data);
        }
        catch (RuntimeException ex) {
            throw new RaceDataIOException((Exception)ex, "Error loading race data: " + ex.getMessage());
        }
        return dataReader;
    }

    protected void processCompetitorData(SplitSecondAlpineDataReader dataReader, Map<String, String> bibNumberMappingTable, Class<? extends RaceClass<?>> ageClassClass, SeasonIdentifier season) throws RaceDataIOException {
        throw new UnsupportedOperationException("Loading racer entries from XML not yet implemented");
    }

    protected void processTimingData(SplitSecondAlpineDataReader dataReader, Map<String, String> bibNumberMappingTable, Map<String, String> startGroupCodesMap, RaceDescriptor aRaceSpecification, SeasonIdentifier season) throws RaceDataIOException {
        this.setResults(null, null);
        this.initLoadSpecifications(aRaceSpecification, season, bibNumberMappingTable, startGroupCodesMap);
        this.validateLoadSpecifications();
        this.validateRaceSpecification(dataReader);
        List<Map<String, Object>> competitorEntries = dataReader.getCompetitorEntries();
        RacerList competitors = this.constructEmptyRacerList();
        ArrayList<RacerResult> resultsList = new ArrayList<RacerResult>(competitorEntries.size());
        for (Map<String, Object> entryValues : competitorEntries) {
            if (!this.shouldProcessCompetitorEntry(entryValues)) continue;
            Racer aRacer = this.racerFromCompetitorEntry(entryValues);
            RaceEntryResult racerResult = this.racerResultFromCompetitorEntry(entryValues, aRacer);
            competitors.add(aRacer);
            resultsList.add(racerResult);
        }
        this.setResults(this.constructRaceResult(resultsList), competitors);
    }

    protected Racer racerFromCompetitorEntry(Map<String, Object> entryValues) throws RaceDataIOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected RaceEntryResult racerResultFromCompetitorEntry(Map<String, Object> entryValues, Racer aRacer) throws RaceDataIOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected boolean shouldProcessCompetitorEntry(Map<String, Object> entryValues) {
        if (this.processNonStarters) {
            return true;
        }
        return this.isStarter(entryValues);
    }

    protected void validateRaceSpecification(SplitSecondAlpineDataReader dataReader) throws RaceDataIOException {
        this.validateRaceSpecification(dataReader.getRaceType(), dataReader.getRaceDate(), dataReader.getRaceLocation());
    }
}

