/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.interchange;

import com.glaivestone.javax.util.PropagatedException;
import com.glaivestone.toolbox.text.csv.CSVFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.interchange.TimingSystemDataImporter;
import org.ussamasters.aces.racedata.interchange.USSASkiDataReader;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.models.Country;
import org.ussamasters.aces.racedata.models.CourseArrangement;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceDescriptor;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.USSALicense;

public class USSASkiDataImporter
extends TimingSystemDataImporter {
    public static final String[] COMPETITOR_ENTRY_COLUMN_NAMES = new String[]{"tag", "Gender", "Result", "position", "Bib", "startNumber (optional)", "FISNumber", "LastName", "FirstName", "YearBorn", "nationality/team", "FIS points", "Total", "RacePoints", "FirstRun", "SecondRun", "USSANumber", "USSA points", "Club (optional)"};
    protected boolean processNonStarters = false;

    public static USSASkiDataImporter importCompetitorData(String timingData, Map<String, String> bibNumberMappingTable, Class<? extends RaceClass<?>> ageClassClass, SeasonIdentifier season, boolean processNonStarters) throws RaceDataIOException {
        USSASkiDataImporter loader = new USSASkiDataImporter();
        loader.processNonStarters = processNonStarters;
        loader.loadCompetitorData(timingData, bibNumberMappingTable, ageClassClass, season);
        return loader;
    }

    public static USSASkiDataImporter importTimingData(String timingData, Map<String, String> bibNumberMappingTable, Map<String, String> startGroupCodesMap, RaceDescriptor raceSpecification, SeasonIdentifier season) throws RaceDataIOException {
        USSASkiDataImporter loader = new USSASkiDataImporter();
        loader.loadData(timingData, bibNumberMappingTable, startGroupCodesMap, raceSpecification, season);
        return loader;
    }

    public static boolean isSupportedFormat(String timingData) {
        return USSASkiDataReader.isSupportedFormat(timingData);
    }

    protected USSASkiDataReader constructTimingDataReader() {
        return new USSASkiDataReader();
    }

    protected boolean isStarter(String[] entryValues) {
        String competitorStatus = entryValues[2];
        return competitorStatus.startsWith("DNS") ? "DNS2".equals(competitorStatus) : true;
    }

    public void loadCompetitorData(String timingData, Map<String, String> bibNumberMappingTable, Class<? extends RaceClass<?>> ageClassClass, SeasonIdentifier season) throws RaceDataIOException {
        this.processCompetitorData(this.loadUnprocessedTimingData(timingData), bibNumberMappingTable, ageClassClass, season);
    }

    public void loadData(String timingData, Map<String, String> bibNumberMappingTable, Map<String, String> startGroupCodesMap, RaceDescriptor aRaceSpecification, SeasonIdentifier season) throws RaceDataIOException {
        if (aRaceSpecification == null) {
            throw new IllegalArgumentException("Race specification not provided");
        }
        this.processTimingData(this.loadUnprocessedTimingData(timingData), bibNumberMappingTable, startGroupCodesMap, aRaceSpecification, season);
    }

    protected USSASkiDataReader loadUnprocessedTimingData(String data) throws RaceDataIOException {
        USSASkiDataReader dataReader = this.constructTimingDataReader();
        try {
            dataReader.loadData(data);
        }
        catch (RuntimeException ex) {
            throw new RaceDataIOException((Exception)ex, "Error loading race results timing data: " + ex.getMessage());
        }
        return dataReader;
    }

    protected void processCompetitorData(USSASkiDataReader dataReader, Map<String, String> bibNumberMappingTable, Class<? extends RaceClass<?>> ageClassClass, SeasonIdentifier season) throws RaceDataIOException {
        this.setResults(null, null);
        this.initLoadSpecifications(ageClassClass, season, bibNumberMappingTable, null);
        this.validateLoadSpecifications();
        RaceIdentifier raceID = new RaceIdentifier(dataReader.getRaceDate(), dataReader.getRaceLocation(), dataReader.getRaceType(), null);
        this.raceSpecification = new RaceDescriptor(raceID, ageClassClass, null, CourseArrangement.UNKNOWN);
        List<String[]> competitorEntries = dataReader.getCompetitorEntries();
        RacerList competitors = this.constructEmptyRacerList();
        for (String[] entryValues : competitorEntries) {
            if (!this.shouldProcessCompetitorEntry(entryValues)) continue;
            Racer aRacer = this.racerFromCompetitorEntry(entryValues);
            competitors.add(aRacer);
        }
        this.setResults(null, competitors);
    }

    protected void processTimingData(USSASkiDataReader dataReader, Map<String, String> bibNumberMappingTable, Map<String, String> startGroupCodesMap, RaceDescriptor aRaceSpecification, SeasonIdentifier season) throws RaceDataIOException {
        this.setResults(null, null);
        this.initLoadSpecifications(aRaceSpecification, season, bibNumberMappingTable, startGroupCodesMap);
        this.validateLoadSpecifications();
        this.validateRaceSpecification(dataReader);
        List<String[]> competitorEntries = dataReader.getCompetitorEntries();
        RacerList competitors = this.constructEmptyRacerList();
        ArrayList<RacerResult> resultsList = new ArrayList<RacerResult>(competitorEntries.size());
        for (String[] entryValues : competitorEntries) {
            if (!this.shouldProcessCompetitorEntry(entryValues)) continue;
            Racer aRacer = this.racerFromCompetitorEntry(entryValues);
            RaceEntryResult racerResult = this.racerResultFromCompetitorEntry(entryValues, aRacer);
            competitors.add(aRacer);
            resultsList.add(racerResult);
        }
        this.setResults(this.constructRaceResult(resultsList), competitors);
    }

    protected Racer racerFromCompetitorEntry(String[] entryValues) throws RaceDataIOException {
        Racer aRacer;
        String valueDescription = null;
        String fieldValue = null;
        try {
            RaceClass<?> nationalClass;
            valueDescription = "gender";
            fieldValue = entryValues[1];
            Gender gender = Gender.getConstant(fieldValue);
            if (gender == null) {
                throw this.constructRacerDataException("Invalid gender - '" + fieldValue + "' must be M or F", entryValues);
            }
            valueDescription = "bib";
            fieldValue = entryValues[4];
            int bibNumber = this.resolveBibNumber(fieldValue, entryValues);
            if (bibNumber < 0) {
                throw this.constructRacerDataException("Racer entry has missing or invalid bib number", entryValues);
            }
            valueDescription = "lastName";
            String lastName = entryValues[7];
            valueDescription = "firstName";
            String firstName = entryValues[8];
            if (lastName == null || lastName.trim().length() == 0) {
                throw this.constructRacerDataException("Racer entry has no name", entryValues);
            }
            if (firstName == null || firstName.trim().length() == 0) {
                boolean nameOrderLastFirst = true;
                String[] nameElements = this.parseNameField(lastName, nameOrderLastFirst);
                if (nameElements[RaceDataIOServices.INDEX_FIRST_NAME] != "") {
                    lastName = nameElements[RaceDataIOServices.INDEX_LAST_NAME];
                    firstName = nameElements[RaceDataIOServices.INDEX_FIRST_NAME];
                } else {
                    firstName = "(unknown)";
                }
            }
            valueDescription = "yearBorn";
            fieldValue = entryValues[9];
            int yearBorn = this.resolveYearBorn(fieldValue, entryValues);
            valueDescription = "age class (from gender/yearBorn)";
            RaceClass<?> ageClass = this.resolveRaceClassFromYOB(gender, yearBorn);
            if (ageClass != null) {
                nationalClass = this.resolveRaceClassFromYOB(gender, yearBorn, this.nationalClassClass);
            } else {
                ageClass = RaceClass.getUnknownClass(this.raceClassClass, gender);
                nationalClass = RaceClass.getUnknownClass(this.nationalClassClass, gender);
            }
            valueDescription = "USSA number";
            String ussaNumber = entryValues[16].toUpperCase();
            RaceOrganization licenseAffiliation = USSALicense.getAffiliation(ussaNumber);
            RaceOrganization affiliation = null;
            if (licenseAffiliation == null || licenseAffiliation == RaceOrganization.FOREIGN) {
                valueDescription = "affiliation";
                if (licenseAffiliation == RaceOrganization.FOREIGN) {
                    fieldValue = entryValues[10];
                    Country nationality = Country.getConstant(fieldValue);
                    if (nationality != null && nationality != Country.USA && nationality != Country.UNKNOWN) {
                        affiliation = RaceOrganization.getConstant(nationality.name);
                    }
                } else {
                    fieldValue = entryValues[10];
                    RaceOrganization orgCandidate = RaceOrganization.getConstant(fieldValue);
                    if (orgCandidate != null && orgCandidate.isRecognizedOrganization() && orgCandidate != RaceOrganization.USSA) {
                        affiliation = orgCandidate;
                    } else {
                        fieldValue = entryValues[18];
                        orgCandidate = RaceOrganization.getConstant(fieldValue);
                        if (orgCandidate != null && orgCandidate.isRecognizedOrganization() && orgCandidate != RaceOrganization.USSA) {
                            affiliation = orgCandidate;
                        }
                    }
                }
            }
            aRacer = new Racer(bibNumber, lastName, firstName);
            aRacer.initCompetitionClassValuesLenient(gender, ageClass, nationalClass, yearBorn);
            if (aRacer.getNationalClass().isUnknown() && aRacer.isBirthYearKnown()) {
                aRacer.initNationalClass(this.season);
            }
            aRacer.initLicenseValues(affiliation, ussaNumber);
        }
        catch (PropagatedException ex) {
            if (ex.getCause() instanceof Exception) {
                throw this.constructRacerDataException("Error processing " + valueDescription + " value '" + fieldValue + "'", entryValues, ex.getCause());
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            throw this.constructRacerDataException("Error processing " + valueDescription + " value '" + fieldValue + "'", entryValues, ex);
        }
        return aRacer;
    }

    protected RaceEntryResult racerResultFromCompetitorEntry(String[] entryValues, Racer aRacer) throws RaceDataIOException {
        RaceEntryResult racerResult;
        String valueDescription = null;
        String fieldValue = null;
        try {
            String total;
            RaceClass<?> racerAgeClass;
            RaceClass<?> raceClass = racerAgeClass = aRacer.getAgeClass();
            valueDescription = "StartGroupCode";
            String startGroupCode = entryValues[10];
            if (this.startGroupCodesMap != null && startGroupCode.length() > 0) {
                raceClass = this.resolveRaceClassFromStartGroupCode(startGroupCode, raceClass, entryValues);
                if (racerAgeClass.isUnknown() && raceClass.isAgeGroupClass()) {
                    aRacer.setAgeClass(raceClass);
                }
            }
            if (raceClass == null || raceClass.isUnknown()) {
                throw this.constructRacerDataException("Unable to determine racer age class", entryValues);
            }
            String resultStatus = entryValues[2];
            boolean isFinisher = resultStatus.equals("QLF");
            String firstRun = entryValues[14];
            String secondRun = entryValues[15];
            String string = total = isFinisher ? entryValues[12] : resultStatus;
            if (!isFinisher) {
                char affectedRun = resultStatus.charAt(resultStatus.length() - 1);
                switch (affectedRun) {
                    case '1': {
                        if (firstRun == null || firstRun.length() == 0) {
                            firstRun = resultStatus;
                        }
                        resultStatus = "";
                        break;
                    }
                    case '2': {
                        if (secondRun == null || secondRun.length() == 0) {
                            secondRun = resultStatus;
                        }
                        resultStatus = "";
                    }
                }
            }
            valueDescription = "RaceEntryResult creation";
            racerResult = RaceEntryResult.createResult(aRacer.getBibNumber(), raceClass, aRacer.getLastName(), aRacer.getFirstName(), this.nRaceRuns);
            valueDescription = "timing data";
            switch (this.nRaceRuns) {
                case 1: {
                    racerResult.setTimingData(total);
                    break;
                }
                case 2: {
                    racerResult.setTimingData(firstRun, secondRun, total);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Invalid race runs count: " + this.nRaceRuns);
                }
            }
            racerResult.validateTimingData();
        }
        catch (PropagatedException ex) {
            if (ex.getCause() instanceof Exception) {
                throw this.constructRacerDataException("Error processing " + valueDescription + " value '" + fieldValue + "'", entryValues, ex.getCause());
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            throw this.constructRacerDataException("Error processing " + valueDescription + " value '" + fieldValue + "'", entryValues, ex);
        }
        return racerResult;
    }

    protected boolean shouldProcessCompetitorEntry(String[] entryValues) {
        if (this.processNonStarters) {
            return true;
        }
        return this.isStarter(entryValues);
    }

    @Override
    protected String toOriginalInputLine(String[] entryValues) {
        return new CSVFormatter(";").format(entryValues);
    }

    protected void validateRaceSpecification(USSASkiDataReader dataReader) throws RaceDataIOException {
        this.validateRaceSpecification(dataReader.getRaceType(), dataReader.getRaceDate(), dataReader.getRaceLocation());
    }
}

