/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.RaceDataReader;
import org.ussamasters.aces.racedata.models.RaceDate;
import org.ussamasters.aces.racedata.models.RaceLocation;
import org.ussamasters.aces.racedata.models.RaceType;

public abstract class RaceDataXMLReader
extends RaceDataReader {
    protected Document document;
    protected boolean loadHeaderOnly = false;
    protected String raceLocation;
    protected RaceDate raceDate;
    protected RaceType raceType;
    protected List<Map<String, Object>> competitorEntries;

    protected RaceDataXMLReader() {
    }

    protected void collectCompElementValue(Element compElement, String elementName, String colName, Map<String, Object> compValues) {
        String value = compElement.getChildTextTrim(elementName);
        if (value != null && value.length() > 0) {
            compValues.put(colName, this.resolveColValue(colName, value));
        }
    }

    protected Object resolveColValue(String colName, String value) {
        return value;
    }

    public Document getDocument() {
        return this.document;
    }

    public RaceDate getRaceDate() {
        return this.raceDate;
    }

    public RaceLocation getRaceLocation() {
        RaceLocation location = RaceLocation.getConstant(this.raceLocation);
        if (location == null) {
            location = RaceLocation.UNKNOWN;
        }
        return location;
    }

    public RaceType getRaceType() {
        return this.raceType;
    }

    public Element getRootElement() {
        return this.document.getRootElement();
    }

    protected boolean isSupportedFormatX(String textData) {
        this.loadHeaderOnly = true;
        try {
            this.load(textData);
        }
        catch (RaceDataIOException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void load(Reader aReader) throws RaceDataIOException {
        SAXBuilder aBuilder = new SAXBuilder();
        aBuilder.setExpandEntities(true);
        try {
            this.document = aBuilder.build(aReader);
            this.loadData();
        }
        catch (JDOMException ex) {
            throw new RaceDataIOException((Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new RaceDataIOException(ex);
        }
    }

    public void load(String textData) throws RaceDataIOException {
        try (BufferedReader aReader = new BufferedReader(new StringReader(textData));){
            this.load(aReader);
        }
        catch (IOException ex) {
            throw new RaceDataIOException((Exception)ex, "I/O Error loading XML race data: " + ex.getMessage());
        }
    }

    @Override
    public void loadFile(File aFile) throws RaceDataIOException {
        SAXBuilder aBuilder = new SAXBuilder();
        aBuilder.setExpandEntities(true);
        try {
            this.document = aBuilder.build(aFile);
            this.loadData();
        }
        catch (IOException | JDOMException ex) {
            throw new RaceDataIOException((Exception)ex);
        }
    }

    protected abstract void loadData() throws RaceDataIOException;
}

