/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ussamasters.aces.racedata.io.RaceDataCSVReader;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.io.RaceResultCSVReader;
import org.ussamasters.aces.racedata.models.FarWestClass_10yr;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.WorldCupPointsType;

public class RaceSeriesCSVReader
extends RaceDataCSVReader {
    public static final String CURRENT_FORMAT = "USSA Masters Race Calendar (CSV 3.0)";
    public static final List<String> SUPPORTED_FORMATS = Collections.unmodifiableList(Arrays.asList("USSA Masters Race Calendar (CSV 3.0)", "USSA Masters Race Calender(CSV 2.0)", "FWM Season Data (CSV 0.1)"));
    protected boolean loadRaceResults;
    protected File source;
    protected RaceSeries raceSeries;

    public RaceSeriesCSVReader(boolean loadRaceResults) {
        super(CURRENT_FORMAT, SUPPORTED_FORMATS);
        this.loadRaceResults = loadRaceResults;
    }

    public RaceSeries getData() {
        return this.raceSeries;
    }

    @Override
    protected void loadData() throws RaceDataIOException {
        String csvString;
        ArrayList<RaceIdentifier> races = new ArrayList<RaceIdentifier>();
        ArrayList<RaceResult> resultsData = new ArrayList<RaceResult>();
        this.readFileFormatLine();
        String seasonName = this.readLine();
        this.readSeasonLine();
        Class raceClassClass = this.isLoadingFormat("FWM Season Data (CSV 0.1)") ? FarWestClass_10yr.class : this.readRaceClassClassLine("race class");
        WorldCupPointsType scoringType = this.isLoadingFormat(CURRENT_FORMAT) ? this.readWorldCupPointsLine("world cup points") : WorldCupPointsType.DEFAULT;
        this.readBlankHeaderTerminationLine();
        while ((csvString = this.readNextCSVLine()) != null) {
            races.add(this.raceFromCSVString(csvString));
        }
        if (this.loadRaceResults) {
            for (RaceIdentifier raceId : races) {
                RaceResult raceResult = this.loadRaceResult(raceId, scoringType);
                if (raceResult == null) continue;
                resultsData.add(raceResult);
            }
        }
        this.raceSeries = new RaceSeries(seasonName, this.season, raceClassClass, scoringType, races);
        for (RaceResult raceResult : resultsData) {
            this.raceSeries.registerRaceData(raceResult);
        }
    }

    @Override
    public void loadFile(File aFile) throws RaceDataIOException {
        this.source = aFile;
        super.loadFile(aFile);
    }

    protected RaceResult loadRaceResult(RaceIdentifier aRace, WorldCupPointsType scoringType) throws RaceDataIOException {
        String raceResultsFileName = RaceDataIOServices.raceResultsFileName(aRace);
        File aFile = new File(this.source.getParentFile(), raceResultsFileName);
        if (!aFile.exists()) {
            throw new RaceDataIOException("Race results data file not found: " + aFile.getAbsolutePath());
        }
        return RaceResultCSVReader.loadFromFile(aFile, scoringType);
    }

    protected RaceIdentifier raceFromCSVString(String csvString) throws RaceDataIOException {
        String[] values = this.parseCSVString(csvString);
        try {
            return RaceDataIOServices.csvValuesToRace(values);
        }
        catch (IllegalArgumentException ex) {
            throw new RaceDataIOException(ex, csvString, "Unable to resolve race specification");
        }
    }

    public static RaceSeries loadCalendarFromFile(File aFile) throws RaceDataIOException {
        RaceSeriesCSVReader aLoader = new RaceSeriesCSVReader(false);
        aLoader.loadFile(aFile);
        return aLoader.getData();
    }

    public static RaceSeries loadCalendarFromFile(String aPathName) throws RaceDataIOException {
        return RaceSeriesCSVReader.loadCalendarFromFile(new File(aPathName));
    }

    public static RaceSeries loadFromFile(File aFile) throws RaceDataIOException {
        RaceSeriesCSVReader aLoader = new RaceSeriesCSVReader(true);
        aLoader.loadFile(aFile);
        return aLoader.getData();
    }

    public static RaceSeries loadFromFile(String aPathName) throws RaceDataIOException {
        return RaceSeriesCSVReader.loadFromFile(new File(aPathName));
    }
}

