/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import java.io.PrintWriter;
import org.ussamasters.aces.racedata.io.RaceDataCSVWriter;
import org.ussamasters.aces.racedata.io.RaceDataIOConstants;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerList;

public class RacerListCSVWriter
extends RaceDataCSVWriter {
    public static final String CURRENT_FORMAT = "USSA Masters Racer Data (CSV 2.1)";
    private static final String[] CURRENT_FORMAT_COLUMN_NAMES = RaceDataIOConstants.RACER_CSV_COLUMN_NAMES_2_1;
    protected RacerList racerList;

    public RacerListCSVWriter(RacerList racerList) {
        this.racerList = racerList;
    }

    protected String bibNumberToString(Racer aRacer) {
        String bibNumberString = aRacer.getBib();
        if (bibNumberString == null) {
            return null;
        }
        while (bibNumberString.length() < 3) {
            bibNumberString = "0" + bibNumberString;
        }
        return bibNumberString;
    }

    protected String racerToCSVString(Racer aRacer) {
        String[] values = new String[]{this.bibNumberToString(aRacer), aRacer.getLastName(), aRacer.getFirstName(), aRacer.getAgeClass().name, aRacer.getNationalClass() == null ? "" : aRacer.getNationalClass().name, aRacer.isBirthYearKnown() ? "" + aRacer.getBirthYear() : "", aRacer.getAffiliation().name, aRacer.getUSSALicense().toString(), ""};
        return this.toCSVString(values);
    }

    protected String racerToCSVStringVer1(Racer aRacer) {
        int nAliases = 0;
        String bibNumberString = aRacer.getBib();
        while (bibNumberString.length() < 3) {
            bibNumberString = "0" + bibNumberString;
        }
        String[] values = new String[8 + nAliases];
        values[0] = bibNumberString;
        values[1] = aRacer.getLastName();
        values[2] = aRacer.getFirstName();
        values[3] = aRacer.getAgeClass().name;
        values[4] = aRacer.getNationalClass() == null ? aRacer.getNationalClass().name : "";
        values[5] = aRacer.isBirthYearKnown() ? "" + aRacer.getBirthYear() : "";
        values[6] = aRacer.getAffiliation().name;
        return this.toCSVString(values);
    }

    @Override
    public void write(PrintWriter pw) {
        pw.println(CURRENT_FORMAT);
        this.writeSeasonLine(pw, this.racerList.getSeason());
        this.writeRaceOrganizationLine(pw, this.racerList.getAffiliation());
        this.writeRaceClassClassLine(pw, this.racerList.getAgeClassClass());
        pw.println();
        this.writeCSVColumnNamesComment(pw, CURRENT_FORMAT_COLUMN_NAMES);
        for (Racer aRacer : this.racerList.getRacers()) {
            pw.println(this.racerToCSVString(aRacer));
        }
    }
}

