/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import org.ussamasters.aces.racedata.models.FinishPositionPoints;
import org.ussamasters.aces.racedata.models.RaceDataConstant;

public class DivisionsCupPoints
extends FinishPositionPoints<DivisionsCupPoints>
implements RaceDataConstant {
    public static final DivisionsCupPoints ZERO;
    protected static final int maxPointsForPredefinedValue;
    protected static final DivisionsCupPoints[] predefinedValues;
    protected static final int nPointScoringPositions;
    protected static final DivisionsCupPoints[] finishPositionPointScores;

    public static DivisionsCupPoints forPoints(int points) {
        if (points < 0) {
            throw new IllegalArgumentException("Invalid value for Divisions Cup points: " + points);
        }
        return points <= maxPointsForPredefinedValue ? predefinedValues[points] : new DivisionsCupPoints(points);
    }

    public static DivisionsCupPoints forPosition(int position, int nCompetitorsInClass) {
        if (position <= 0) {
            throw new IllegalArgumentException("Invalid position for Divisions Cup points: " + position);
        }
        if (position > nPointScoringPositions) {
            return ZERO;
        }
        if (nCompetitorsInClass < nPointScoringPositions) {
            int delta = nPointScoringPositions - nCompetitorsInClass;
            return DivisionsCupPoints.forPoints(finishPositionPointScores[position - 1].intValue() - delta);
        }
        return finishPositionPointScores[position - 1];
    }

    protected DivisionsCupPoints(int points) {
        super(points);
    }

    public DivisionsCupPoints add(DivisionsCupPoints otherPoints) {
        if (otherPoints == ZERO) {
            return this;
        }
        if (this == ZERO) {
            return otherPoints;
        }
        return DivisionsCupPoints.forPoints(this.intValue() + otherPoints.intValue());
    }

    public String toString() {
        return this.getClass().getName() + (this == ZERO ? ".ZERO" : "{" + this.points + "}");
    }

    static {
        int[] divisionsCupPointsSpec = new int[]{5, 4, 3, 2, 1};
        ZERO = new DivisionsCupPoints(0);
        maxPointsForPredefinedValue = divisionsCupPointsSpec[0];
        predefinedValues = new DivisionsCupPoints[maxPointsForPredefinedValue + 1];
        DivisionsCupPoints.predefinedValues[0] = ZERO;
        for (int points = 1; points <= maxPointsForPredefinedValue; ++points) {
            DivisionsCupPoints.predefinedValues[points] = new DivisionsCupPoints(points);
        }
        nPointScoringPositions = divisionsCupPointsSpec.length;
        finishPositionPointScores = new DivisionsCupPoints[nPointScoringPositions];
        for (int i = 0; i < nPointScoringPositions; ++i) {
            int points = divisionsCupPointsSpec[i];
            DivisionsCupPoints.finishPositionPointScores[i] = predefinedValues[points];
        }
    }
}

