/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import org.ussamasters.aces.racedata.models.DivisionsCupPoints;
import org.ussamasters.aces.racedata.models.OrganizationScoringResult;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.ScoringResult;

public class DivisionsCupResult
extends OrganizationScoringResult {
    public static final int MIN_NUM_RACERS_PER_TEAM = 10;
    protected DivisionsCupPoints dcPoints;
    private float pointsPerStart;
    private boolean isQualifiedForStandingsPosition;

    public DivisionsCupResult(RaceOrganization affiliation, int nRacers, int numStarts, DivisionsCupPoints dcPoints) {
        super(affiliation, nRacers, numStarts);
        this.dcPoints = dcPoints;
        this.computeFinishStatistics();
    }

    @Override
    protected int compareByQualification(ScoringResult otherResult) {
        return this.isQualified() == ((DivisionsCupResult)otherResult).isQualified() ? 0 : (this.isQualified() ? -1 : 1);
    }

    public int compareTo(DivisionsCupResult otherResult) {
        int comparison = this.compareByQualification(otherResult);
        if (comparison != 0) {
            return comparison;
        }
        comparison = new Float(this.getPointsPerStart()).compareTo(new Float(otherResult.getPointsPerStart()));
        return comparison == 0 ? this.affiliation.name.compareTo(otherResult.affiliation.name) : -comparison;
    }

    protected void computeFinishStatistics() {
        float pps = (float)this.dcPoints.intValue() / (float)this.getNumberOfStarts();
        this.pointsPerStart = (float)((int)(pps * 1000.0f)) / 1000.0f;
        this.isQualifiedForStandingsPosition = this.affiliation.isUSSADivision() && this.nRacers >= 10;
    }

    public DivisionsCupPoints getDivisionsCupPoints() {
        return this.dcPoints;
    }

    public float getPointsPerStart() {
        return this.pointsPerStart;
    }

    public boolean isQualified() {
        return this.isQualifiedForStandingsPosition;
    }

    public String toString() {
        return String.format("%s<%s: %s. %s>", this.getClass().getSimpleName(), this.getAffiliation().name(), this.isQualified() ? this.getPositionString() : "-", Float.valueOf(this.getPointsPerStart()));
    }
}

