/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.NationalClassGroup;
import org.ussamasters.aces.racedata.models.NationalClassGroup_2000;
import org.ussamasters.aces.racedata.models.NationalClass_2000;
import org.ussamasters.aces.racedata.models.RaceClassRegistry;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.TenYearRangeRaceClass;

public class FarWestClass_10yr
extends TenYearRangeRaceClass<FarWestClass_10yr> {
    private static final Class<FarWestClass_10yr> THIS_CLASS = FarWestClass_10yr.class;
    public static final RaceClassType RACE_CLASS_TYPE = RaceClassType.farwest_masters;
    public static final FarWestClass_10yr M80;
    public static final FarWestClass_10yr W80;
    public static final FarWestClass_10yr W70;
    public static final FarWestClass_10yr M70;
    public static final FarWestClass_10yr W60;
    public static final FarWestClass_10yr W50;
    public static final FarWestClass_10yr WOP;
    public static final FarWestClass_10yr W40;
    public static final FarWestClass_10yr W30;
    public static final FarWestClass_10yr W20;
    public static final FarWestClass_10yr W18;
    public static final FarWestClass_10yr W00;
    public static final FarWestClass_10yr M60;
    public static final FarWestClass_10yr M50;
    public static final FarWestClass_10yr MOP;
    public static final FarWestClass_10yr M40;
    public static final FarWestClass_10yr M30;
    public static final FarWestClass_10yr M20;
    public static final FarWestClass_10yr M18;
    public static final FarWestClass_10yr M00;
    public static final FarWestClass_10yr MUNK;
    public static final FarWestClass_10yr WUNK;
    private static final String DESCRIPTION = "Far West masters 10-year age classes with men's and women's open seed";
    protected static Map<FarWestClass_10yr, String> classStartOrderCodeTable;
    protected static Map<NationalClass_2000, FarWestClass_10yr> nationalClassMap;

    public static FarWestClass_10yr forAge(Gender gender, int age) {
        return (FarWestClass_10yr)FarWestClass_10yr.forAge(gender, age, THIS_CLASS);
    }

    public static FarWestClass_10yr forNationalClass(NationalClass_2000 ussaClass) {
        return nationalClassMap.get(ussaClass);
    }

    public static FarWestClass_10yr forStartOrderSortCode(String sortCode) {
        for (FarWestClass_10yr fwClass : classStartOrderCodeTable.keySet()) {
            String classSortCode = classStartOrderCodeTable.get(fwClass);
            if (!classSortCode.equals(sortCode)) continue;
            return fwClass;
        }
        return null;
    }

    public static FarWestClass_10yr getConstant(int ordinalValue) {
        return FarWestClass_10yr.getConstant(ordinalValue, THIS_CLASS);
    }

    public static FarWestClass_10yr getConstant(String name) {
        return FarWestClass_10yr.getConstant(name, THIS_CLASS);
    }

    public static void registerSynonym(String synonym, String constantName) {
        FarWestClass_10yr.registerSynonym(synonym, constantName, THIS_CLASS);
    }

    public static List<FarWestClass_10yr> values() {
        return FarWestClass_10yr.values(THIS_CLASS);
    }

    protected FarWestClass_10yr(String name, int startAge, String description) {
        this(name, startAge, startAge + 10 - 1, description);
    }

    protected FarWestClass_10yr(String name, int startAge, int endAge, String description) {
        super(name, startAge, endAge, description, RaceOrganization.FAR_WEST);
    }

    @Override
    public RaceClassType getRaceClassType() {
        return RACE_CLASS_TYPE;
    }

    @Override
    public String getStartOrderSortCode() {
        return classStartOrderCodeTable.get(this);
    }

    @Override
    public boolean isDivisionClass() {
        return true;
    }

    @Override
    public boolean isAbilityGroupClass() {
        return this == WOP || this == MOP;
    }

    @Override
    public boolean isUnknown() {
        return this == MUNK || this == WUNK;
    }

    @Override
    protected void validateNameSuffix(String classNameSuffix) {
        if (classNameSuffix.equals("UNK")) {
            return;
        }
        if (classNameSuffix.equals("OP")) {
            return;
        }
        this.validateNameSuffixLength(classNameSuffix, 2);
        super.validateNameSuffix(classNameSuffix);
    }

    protected static Map<FarWestClass_10yr, String> constructClassStartOrderTable() {
        Object[][] startCodeSpecs = new Object[][]{{W80, "A"}, {M80, "B"}, {W70, "C"}, {M70, "D"}, {W60, "E"}, {W50, "F"}, {WOP, "G"}, {W40, "H"}, {W30, "I"}, {W20, "J"}, {W18, "K"}, {W00, "KX"}, {M60, "M"}, {M50, "N"}, {MOP, "O"}, {M40, "P"}, {M30, "Q"}, {M20, "R"}, {M18, "S"}, {M00, "SX"}};
        HashMap<FarWestClass_10yr, String> startCodeTable = new HashMap<FarWestClass_10yr, String>();
        for (int i = 0; i < startCodeSpecs.length; ++i) {
            startCodeTable.put((FarWestClass_10yr)startCodeSpecs[i][0], (String)startCodeSpecs[i][1]);
        }
        return startCodeTable;
    }

    protected static Map<NationalClass_2000, FarWestClass_10yr> constructNationalClassMap() {
        HashMap<NationalClass_2000, FarWestClass_10yr> mappingTable = new HashMap<NationalClass_2000, FarWestClass_10yr>();
        mappingTable.put(NationalClass_2000.MUNK, MUNK);
        mappingTable.put(NationalClass_2000.WUNK, WUNK);
        for (NationalClass_2000 nationalClass : NationalClass_2000.values()) {
            if (!nationalClass.isAgeGroupClass()) continue;
            mappingTable.put(nationalClass, FarWestClass_10yr.forAge(nationalClass.getGender(), nationalClass.startAge));
        }
        return mappingTable;
    }

    protected static void registerStandardSynonyms() {
        char altWomensPrefix = 'F';
        String[][] synonymSpecs = new String[][]{};
        FarWestClass_10yr.registerSynonyms(FarWestClass_10yr.standardOpenSeedSynonymSpecs(), THIS_CLASS);
        FarWestClass_10yr.registerSynonyms(synonymSpecs, THIS_CLASS);
        FarWestClass_10yr.registerGenderPrefixSynonyms(Gender.WOMEN, altWomensPrefix, THIS_CLASS);
    }

    static {
        W80 = new FarWestClass_10yr("W80", 80, 999, "Women 80+");
        M80 = new FarWestClass_10yr("M80", 80, 999, "Men 80+");
        W70 = new FarWestClass_10yr("W70", 70, "Women 70");
        M70 = new FarWestClass_10yr("M70", 70, "Men 70");
        W60 = new FarWestClass_10yr("W60", 60, "Women 60");
        W50 = new FarWestClass_10yr("W50", 50, "Women 50");
        WOP = new FarWestClass_10yr("WOP", -1, -1, "Women Open Seed");
        W40 = new FarWestClass_10yr("W40", 40, "Women 40");
        W30 = new FarWestClass_10yr("W30", 30, "Women 30");
        W20 = new FarWestClass_10yr("W20", 21, 29, "Women 20");
        W18 = new FarWestClass_10yr("W18", 18, 20, "Women 18-20");
        W00 = new FarWestClass_10yr("W00", 0, 17, "Women (under 18)");
        M60 = new FarWestClass_10yr("M60", 60, "Men 60");
        M50 = new FarWestClass_10yr("M50", 50, "Men 50");
        MOP = new FarWestClass_10yr("MOP", -1, -1, "Men Open Seed");
        M40 = new FarWestClass_10yr("M40", 40, "Men 40");
        M30 = new FarWestClass_10yr("M30", 30, "Men 30");
        M20 = new FarWestClass_10yr("M20", 21, 29, "Men 20");
        M18 = new FarWestClass_10yr("M18", 18, 20, "Men 18-20");
        M00 = new FarWestClass_10yr("M00", 0, 17, "Men (under 18)");
        MUNK = new FarWestClass_10yr("MUNK", -1, -1, "Men (unknown)");
        WUNK = new FarWestClass_10yr("WUNK", -1, -1, "Women (unknown)");
        nationalClassMap = FarWestClass_10yr.constructNationalClassMap();
        classStartOrderCodeTable = FarWestClass_10yr.constructClassStartOrderTable();
        FarWestClass_10yr.registerStandardSynonyms();
        RaceClassRegistry.registerDivisionRaceClass(THIS_CLASS, RACE_CLASS_TYPE, DESCRIPTION, 10, NationalClass_2000.class, NationalClassGroup_2000.class, NationalClassGroup.GROUP_TYPE);
    }
}

