/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RacerResult;

public abstract class NamedRacerResult
extends RacerResult {
    protected NamedRacerResult() {
    }

    public int compareByName(NamedRacerResult otherResult) {
        this.checkComparable(otherResult);
        int comparison = this.getLastName().compareTo(otherResult.getLastName());
        if (comparison == 0) {
            comparison = this.getFirstName().compareTo(otherResult.getFirstName());
        }
        return comparison;
    }

    protected int compareByNameIfTied(int comparison, RacerResult otherResult) {
        return comparison == 0 ? this.compareByName((NamedRacerResult)otherResult) : comparison;
    }

    @Override
    public int compareByPoints(RacerResult otherResult) {
        return this.compareByNameIfTied(super.compareByPoints(otherResult), otherResult);
    }

    public int compareByPosition(RacerResult otherResult) {
        return this.compareByNameIfTied(super.compareByPosition(otherResult), otherResult);
    }

    @Override
    public int compareByRacePoints(RacerResult otherResult) {
        return this.compareByNameIfTied(super.compareByRacePoints(otherResult), otherResult);
    }

    @Override
    public int compareByTime(RacerResult otherResult) {
        return this.compareByNameIfTied(super.compareByTime(otherResult), otherResult);
    }

    public String getBib() {
        return "" + this.getBibNumber();
    }

    public abstract int getBibNumber();

    public abstract String getFirstName();

    public abstract String getLastName();

    public abstract Gender getGender();

    public String getName() {
        return this.getLastName() + ", " + this.getFirstName();
    }

    public abstract RaceClass<?> getRaceClass();
}

