/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import java.util.List;
import org.ussamasters.aces.racedata.models.FiveYearRangeRaceClass;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.NationalClassGroup;
import org.ussamasters.aces.racedata.models.NationalClassGroup_2000;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassRegistry;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceOrganization;

public class NationalClass_2000
extends FiveYearRangeRaceClass<NationalClass_2000> {
    private static final Class<NationalClass_2000> THIS_CLASS = NationalClass_2000.class;
    public static final RaceClassType RACE_CLASS_TYPE = RaceClassType.us_masters;
    public static final NationalClass_2000 W14 = new NationalClass_2000("W14", 90, 999, "Women Class 14 (90+)", NationalClassGroup_2000.GROUP_C);
    public static final NationalClass_2000 M14 = new NationalClass_2000("M14", 90, 999, "Men Class 14 (90+)", NationalClassGroup_2000.GROUP_D);
    public static final NationalClass_2000 W13 = new NationalClass_2000("W13", 85, 999, "Women Class 13 (85-89)", NationalClassGroup_2000.GROUP_C);
    public static final NationalClass_2000 M13 = new NationalClass_2000("M13", 85, "Men Class 13 (85-89)", NationalClassGroup_2000.GROUP_D);
    public static final NationalClass_2000 W12 = new NationalClass_2000("W12", 80, "Women Class 12 (80-84)", NationalClassGroup_2000.GROUP_C);
    public static final NationalClass_2000 M12 = new NationalClass_2000("M12", 80, "Men Class 12 (80-84)", NationalClassGroup_2000.GROUP_D);
    public static final NationalClass_2000 W11 = new NationalClass_2000("W11", 75, "Women Class 11 (75-79)", NationalClassGroup_2000.GROUP_C);
    public static final NationalClass_2000 M11 = new NationalClass_2000("M11", 75, "Men Class 11 (75-79)", NationalClassGroup_2000.GROUP_D);
    public static final NationalClass_2000 W10 = new NationalClass_2000("W10", 70, "Women Class 10 (70-74)", NationalClassGroup_2000.GROUP_C);
    public static final NationalClass_2000 M10 = new NationalClass_2000("M10", 70, "Men Class 10 (70-74)", NationalClassGroup_2000.GROUP_D);
    public static final NationalClass_2000 W09 = new NationalClass_2000("W09", 65, "Women Class 9 (65-69)", NationalClassGroup_2000.GROUP_C);
    public static final NationalClass_2000 W08 = new NationalClass_2000("W08", 60, "Women Class 8 (60-64)", NationalClassGroup_2000.GROUP_C);
    public static final NationalClass_2000 W07 = new NationalClass_2000("W07", 55, "Women Class 7 (55-59)", NationalClassGroup_2000.GROUP_C);
    public static final NationalClass_2000 W06 = new NationalClass_2000("W06", 50, "Women Class 6 (50-54)", NationalClassGroup_2000.GROUP_C);
    public static final NationalClass_2000 W05 = new NationalClass_2000("W05", 45, "Women Class 5 (45-49)", NationalClassGroup_2000.GROUP_C);
    public static final NationalClass_2000 W04 = new NationalClass_2000("W04", 40, "Women Class 4 (40-44)", NationalClassGroup_2000.GROUP_C);
    public static final NationalClass_2000 W03 = new NationalClass_2000("W03", 35, "Women Class 3 (35-39)", NationalClassGroup_2000.GROUP_C);
    public static final NationalClass_2000 W02 = new NationalClass_2000("W02", 30, "Women Class 2 (30-34)", NationalClassGroup_2000.GROUP_C);
    public static final NationalClass_2000 W01 = new NationalClass_2000("W01", 21, 29, "Women Class 1 (21-29)", NationalClassGroup_2000.GROUP_C);
    public static final NationalClass_2000 W00 = new NationalClass_2000("W00", 0, 20, "Women Class 0 (under 21)", NationalClassGroup_2000.NONE);
    public static final NationalClass_2000 M09 = new NationalClass_2000("M09", 65, "Men Class 9 (65-69)", NationalClassGroup_2000.GROUP_D);
    public static final NationalClass_2000 M08 = new NationalClass_2000("M08", 60, "Men Class 8 (60-64)", NationalClassGroup_2000.GROUP_D);
    public static final NationalClass_2000 M07 = new NationalClass_2000("M07", 55, "Men Class 7 (55-59)", NationalClassGroup_2000.GROUP_B);
    public static final NationalClass_2000 M06 = new NationalClass_2000("M06", 50, "Men Class 6 (50-54)", NationalClassGroup_2000.GROUP_B);
    public static final NationalClass_2000 M05 = new NationalClass_2000("M05", 45, "Men Class 5 (45-49)", NationalClassGroup_2000.GROUP_B);
    public static final NationalClass_2000 M04 = new NationalClass_2000("M04", 40, "Men Class 4 (40-44)", NationalClassGroup_2000.GROUP_A);
    public static final NationalClass_2000 M03 = new NationalClass_2000("M03", 35, "Men Class 3 (35-39)", NationalClassGroup_2000.GROUP_A);
    public static final NationalClass_2000 M02 = new NationalClass_2000("M02", 30, "Men Class 2 (30-34)", NationalClassGroup_2000.GROUP_A);
    public static final NationalClass_2000 M01 = new NationalClass_2000("M01", 21, 29, "Men Class 1 (21-29)", NationalClassGroup_2000.GROUP_A);
    public static final NationalClass_2000 M00 = new NationalClass_2000("M00", 0, 20, "Men Class 0 (under 21)", NationalClassGroup_2000.NONE);
    public static final NationalClass_2000 MUNK = new NationalClass_2000("MUNK", -1, -1, "Men (unknown)", null);
    public static final NationalClass_2000 WUNK = new NationalClass_2000("WUNK", -1, -1, "Women  (unknown)", null);
    private static final String DESCRIPTION = "USSA masters 5-year age classes (20-90+)";

    public static NationalClass_2000 forAge(Gender gender, int age) {
        return (NationalClass_2000)NationalClass_2000.forAge(gender, age, THIS_CLASS);
    }

    public static NationalClass_2000 getConstant(int ordinalValue) {
        return NationalClass_2000.getConstant(ordinalValue, THIS_CLASS);
    }

    public static NationalClass_2000 getConstant(String name) {
        return NationalClass_2000.getConstant(name, THIS_CLASS);
    }

    public static boolean hasDirectMappingFromRaceClassClass(Class<? extends RaceClass<?>> raceClassClass) {
        return raceClassClass.equals(THIS_CLASS);
    }

    public static void registerSynonym(String synonym, String constantName) {
        NationalClass_2000.registerSynonym(synonym, constantName, THIS_CLASS);
    }

    public static List<NationalClass_2000> values() {
        return NationalClass_2000.values(THIS_CLASS);
    }

    protected NationalClass_2000(String name, int startAge, String description, NationalClassGroup_2000 group) {
        this(name, startAge, startAge + 5 - 1, description, group);
    }

    protected NationalClass_2000(String name, int startAge, int endAge, String description, NationalClassGroup_2000 group) {
        super(name, startAge, endAge, description, RaceOrganization.USSA, group);
    }

    @Override
    public RaceClassType getRaceClassType() {
        return RACE_CLASS_TYPE;
    }

    @Override
    public boolean isNationalClass() {
        return true;
    }

    @Override
    public boolean isUnknown() {
        return this == MUNK || this == WUNK;
    }

    @Override
    protected String toAttributeDescriptionString() {
        return super.toAttributeDescriptionString() + (this.isAgeGroupClass() && this.group != null ? " -> " + this.group.toConstantName() : "");
    }

    @Override
    protected void validateNameSuffix(String classNameSuffix) {
        if (classNameSuffix.equals("UNK")) {
            return;
        }
        this.validateNameSuffixLength(classNameSuffix, 2);
        super.validateNameSuffix(classNameSuffix);
    }

    protected static void registerStandardSynonyms() {
        char altWomensPrefix = 'F';
        NationalClass_2000.registerGenderPrefixSynonyms(Gender.WOMEN, altWomensPrefix, THIS_CLASS);
        NationalClass_2000.registerClassNumberSynonyms(THIS_CLASS, altWomensPrefix);
    }

    static {
        NationalClass_2000.registerStandardSynonyms();
        RaceClassRegistry.registerNationalRaceClass(THIS_CLASS, RACE_CLASS_TYPE, DESCRIPTION, 5, NationalClassGroup_2000.class, NationalClassGroup.GROUP_TYPE);
    }
}

