/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import org.ussamasters.aces.racedata.models.AllRacersCategory;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.models.StandingsSummaryData;

public abstract class RaceDataSummaryStatistics
implements Cloneable {
    public static final Object TYPE_COMPETITORS = new Object();
    public static final Object TYPE_QUALIFIERS = new Object();
    protected static final StandingsCategory[] CATEGORIES_ALL_MEN_WOMEN = new StandingsCategory[]{AllRacersCategory.ALL_RACERS, Gender.WOMEN, Gender.MEN};
    protected static final int INDEX_ALL = 0;
    protected static final int INDEX_FIRST_GENDER = 1;
    protected static final int INDEX_WOMEN = 1;
    protected static final int INDEX_MEN = 2;
    protected static final int UNKNOWN_COUNT = -1;
    private StandingsSummaryData[] competitorStatistics;
    private StandingsSummaryData[] qualifierStatistics;

    protected RaceDataSummaryStatistics() {
        this.clear();
    }

    public void clear() {
        this.competitorStatistics = this.constructStatistics(TYPE_COMPETITORS, CATEGORIES_ALL_MEN_WOMEN);
        this.qualifierStatistics = this.constructStatistics(TYPE_QUALIFIERS, CATEGORIES_ALL_MEN_WOMEN);
    }

    protected void clearNumberOfDataSources(StandingsSummaryData[] statistics) {
        for (int i = 0; i < statistics.length; ++i) {
            statistics[i].setNumberOfDataSources(0);
        }
    }

    protected void clearTotals(StandingsSummaryData[] statistics) {
        for (int i = 0; i < statistics.length; ++i) {
            statistics[i].clearTotal();
        }
    }

    public Object clone() {
        RaceDataSummaryStatistics copy;
        try {
            copy = (RaceDataSummaryStatistics)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new UnsupportedOperationException("Aargh: summary statistics clone failed: " + ex.getMessage());
        }
        copy.competitorStatistics = this.copyStatistics(this.competitorStatistics);
        copy.qualifierStatistics = this.copyStatistics(this.qualifierStatistics);
        return copy;
    }

    protected abstract void collectStatistics(RaceResult var1);

    protected StandingsSummaryData[] constructStatistics(Object type, Object[] categories) {
        int nCategories = categories.length;
        StandingsSummaryData[] statistics = new StandingsSummaryData[nCategories];
        for (int i = 0; i < nCategories; ++i) {
            statistics[i] = this.constructStatisticsEntry(TYPE_COMPETITORS, categories[i]);
        }
        return statistics;
    }

    protected StandingsSummaryData constructStatisticsEntry(Object type, Object category) {
        return new StandingsSummaryData(type, category);
    }

    protected StandingsSummaryData[] copyStatistics(StandingsSummaryData[] statistics) {
        if (statistics == null) {
            return null;
        }
        StandingsSummaryData[] copy = new StandingsSummaryData[statistics.length];
        for (int i = 0; i < statistics.length; ++i) {
            copy[i] = statistics[i].copy();
        }
        return copy;
    }

    protected void finishComputingStatistics() {
    }

    public StandingsSummaryData[] getCompetitorStatistics() {
        return this.competitorStatistics;
    }

    public int getNumberOfCompetitors() {
        return this.competitorStatistics[0].getTotal();
    }

    public int getNumberOfCompetitors(Gender gender) {
        return this.competitorStatistics[1 + gender.ord].getTotal();
    }

    public int getNumberOfQualifiers() {
        return this.qualifierStatistics[0].getTotal();
    }

    public int getNumberOfQualifiers(Gender gender) {
        return this.qualifierStatistics[1 + gender.ord].getTotal();
    }

    public StandingsSummaryData[] getQualifierStatistics() {
        return this.qualifierStatistics;
    }

    protected void initValues(int[] values, int initValue) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = initValue;
        }
    }

    protected void prepareToComputeStatistics() {
        this.clearTotals(this.competitorStatistics);
        this.clearTotals(this.qualifierStatistics);
    }

    protected void recordCompetitor(Gender gender) {
        this.competitorStatistics[0].incrementTotal();
        this.competitorStatistics[1 + gender.ord].incrementTotal();
    }

    protected void recordNumberOfCompetitorDataSources(int count) {
        this.recordNumberOfDataSources(this.competitorStatistics, count);
        this.recordNumberOfDataSources(this.qualifierStatistics, count);
    }

    protected void recordNumberOfDataSources(StandingsSummaryData[] statistics, int count) {
        for (int i = 0; i < statistics.length; ++i) {
            statistics[i].setNumberOfDataSources(count);
        }
    }

    protected void recordQualifier(Gender gender) {
        this.qualifierStatistics[0].incrementTotal();
        this.qualifierStatistics[1 + gender.ord].incrementTotal();
    }

    public String toString() {
        return String.format("%s <competitors: %s, qualifiers: %s>", this.getClass().getSimpleName(), this.getNumberOfCompetitors(), this.getNumberOfQualifiers());
    }
}

