/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import org.ussamasters.aces.racedata.models.RaceDate;
import org.ussamasters.aces.racedata.models.RaceLocation;
import org.ussamasters.aces.racedata.models.RaceType;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;

public class RaceIdentifier
implements Comparable<RaceIdentifier> {
    private static final String DEFAULT_QUALIFIER = "";
    private final RaceDate date;
    private final RaceLocation location;
    private final RaceType type;
    private String qualifier;
    private final SeasonIdentifier season;

    public static RaceIdentifier constructPlaceholder(SeasonIdentifier season) {
        return new RaceIdentifier(RaceDate.fromStandardString("31-Dec-" + Integer.toString(season.startYear)), RaceLocation.UNKNOWN, RaceType.GS, DEFAULT_QUALIFIER);
    }

    public RaceIdentifier(RaceDate date, RaceLocation location, RaceType type, String qualifier) {
        this.date = date;
        this.location = location;
        this.type = type;
        this.setQualifier(qualifier);
        this.season = SeasonIdentifier.forSeason(date.getSeasonEndYear());
    }

    protected RaceIdentifier(RaceIdentifier aRace) {
        this(aRace.getDate(), aRace.getLocation(), aRace.getType(), aRace.getQualifier());
    }

    @Override
    public int compareTo(RaceIdentifier other) {
        if (this.equals(other)) {
            return 0;
        }
        int comparisonCode = this.getDate().compareTo(other.getDate());
        if (comparisonCode != 0) {
            return comparisonCode;
        }
        comparisonCode = this.getLocation().name.compareTo(other.getLocation().name);
        if (comparisonCode != 0) {
            return comparisonCode;
        }
        comparisonCode = this.getType().basicType.compareByOrdinal(other.getType().basicType);
        if (comparisonCode != 0) {
            return 1 - comparisonCode;
        }
        return this.getQualifier().compareTo(other.getQualifier());
    }

    public boolean equals(Object obj) {
        return obj instanceof RaceIdentifier ? this.equals((RaceIdentifier)obj) : false;
    }

    public boolean equals(RaceIdentifier raceId) {
        return raceId.location == this.location && raceId.type == this.type && raceId.date.equals(this.date) && raceId.qualifier.equalsIgnoreCase(this.qualifier);
    }

    public SeasonIdentifier getSeason() {
        return this.season;
    }

    public int getSeasonYear() {
        return this.season.getSeasonYear();
    }

    public RaceDate getDate() {
        return this.date;
    }

    public RaceLocation getLocation() {
        return this.location;
    }

    public int getNumberOfRuns() {
        return this.type.nRuns;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public RaceType getType() {
        return this.type;
    }

    public int hashCode() {
        return this.location.hashCode() + this.type.hashCode() + this.date.hashCode() + this.qualifier.hashCode();
    }

    public boolean hasQualifier() {
        return !DEFAULT_QUALIFIER.equals(this.getQualifier());
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier == null || (qualifier = qualifier.trim()).length() == 0 ? DEFAULT_QUALIFIER : qualifier;
    }

    public String toDescriptionString() {
        return String.format("%s %s (%s%s)", this.location.fullName, this.getType().description, this.date.toRenderingString(), this.hasQualifier() ? ", " + this.qualifier : DEFAULT_QUALIFIER);
    }

    public String toReferenceString() {
        String optionalQualifierSuffix = this.hasQualifier() ? "-" + this.getQualifier() : DEFAULT_QUALIFIER;
        return String.format("%s-%s-%s%s", this.getDate().toDigitString(), this.getLocation().name, this.getType().name, optionalQualifierSuffix);
    }

    public String toString() {
        return String.format("%s {%s, %s, %s%s}", this.getClass().getName(), this.location.name, this.type.name, this.date.toStandardString(), this.hasQualifier() ? ", " + this.qualifier : DEFAULT_QUALIFIER);
    }
}

