/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.ussamasters.aces.racedata.models.RaceTime;
import org.ussamasters.aces.racedata.models.RaceType;
import org.ussamasters.aces.racedata.models.RaceValueInHundredths;
import org.ussamasters.aces.racedata.models.SeasonConfiguration;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.javax.io.ConstantLoader;
import org.ussamasters.javax.io.ConstantSpecifications;

public class RacePoints
extends RaceValueInHundredths<RacePoints> {
    private static final Class<RacePoints> THIS_CLASS = RacePoints.class;
    private static final String CONFIG_DIR_REF = "/" + THIS_CLASS.getPackage().getName().replaceAll("\\.", "/").replace("/models", "/configuration");
    public static final RacePoints ZERO = new RacePoints(0, 0);
    protected static final String HUNDREDTHS_SEPARATOR = ".";
    protected static final String TOKEN_SEPARATORS = ".";
    public static boolean USE_FLOAT_ARITH = true;
    public static final String BUILTIN_CONSTANT_SPECS = CONFIG_DIR_REF + "/constants/FFactors.yml";
    public static final String SPEC_FIELD_SEASONS = "seasons";
    public static final String SPEC_FIELD_SL = "SL";
    public static final String SPEC_FIELD_GS = "GS";
    public static final String SPEC_FIELD_SG = "SG";
    public static final String SPEC_FIELD_DH = "DH";
    public static final String SPEC_FIELD_SC = "SC";
    public static final String SPEC_FIELD_AC = "AC";
    public static final String SPEC_FIELD_P = "P";
    public static final List<String> CONSTANT_SPEC_FIELDS = Collections.unmodifiableList(Arrays.asList("seasons", "SL", "GS", "SG", "DH", "SC", "AC", "P"));
    public static final List<String> OPTIONAL_SPEC_FIELDS = Collections.unmodifiableList(Arrays.asList("SC", "AC", "P"));
    public static final List<String> SUPPORTED_RACE_TYPES = Collections.unmodifiableList(Arrays.asList("SL", "GS", "SG", "DH", "SC", "AC", "P"));

    public static RacePoints computePoints(RaceTime tCompetitor, RaceTime tWinner, int fValue) {
        if (tCompetitor.equals(tWinner)) {
            return ZERO;
        }
        float timeRatio = USE_FLOAT_ARITH ? tCompetitor.floatValue() / tWinner.floatValue() : (float)(tCompetitor.toHundredthsOfSeconds() / tWinner.toHundredthsOfSeconds());
        float rpValue = (timeRatio - 1.0f) * (float)fValue;
        return RacePoints.fromFloat(rpValue);
    }

    public static int getFFactor(RaceType raceType, SeasonIdentifier season) {
        return SeasonConfiguration.getSeasonConfig(season).getFFactor(raceType);
    }

    protected static RacePoints fromData(int[] data) {
        if (data.length != 2) {
            throw new IllegalArgumentException("RacePoints data must be {points, hundredths }: " + data);
        }
        return RacePoints.fromValues(data[0], data[1]);
    }

    public static RacePoints fromFloat(float floatValue) {
        return RacePoints.fromData(RacePoints.parseFloatRounded(floatValue));
    }

    public static RacePoints fromString(String pointsString) {
        return RacePoints.fromData(RacePoints.parsePointsString(pointsString));
    }

    public static RacePoints fromValues(int points, int hundredths) {
        if (points == 0 && hundredths == 0) {
            return ZERO;
        }
        return new RacePoints(points, hundredths);
    }

    public static void loadConstants(String fileRef) {
        ConstantSpecifications specs = ConstantLoader.loadSpecificationsFromFile(fileRef);
        specs.ensureWellFormed(CONSTANT_SPEC_FIELDS);
        for (Map<String, Object> entry : specs.getEntries()) {
            List seasons = (List)entry.get(SPEC_FIELD_SEASONS);
            HashMap<RaceType, Integer> fFactors = new HashMap<RaceType, Integer>();
            for (Map.Entry<String, Object> entryItem : entry.entrySet()) {
                String key = entryItem.getKey();
                if (key.equals(SPEC_FIELD_SEASONS)) continue;
                RaceType raceType = RaceType.getConstant(key);
                if (raceType == null || !SUPPORTED_RACE_TYPES.contains(key)) {
                    throw new IllegalArgumentException(String.format("Invalid F factor race type '%s' (%s)", key, entry));
                }
                if (fFactors.containsKey(raceType)) {
                    throw new IllegalArgumentException(String.format("Duplicate F factor for race type '%s' (%s)", key, entry));
                }
                int fValue = (Integer)entryItem.getValue();
                fFactors.put(raceType, fValue);
            }
            for (Integer seasonYear : seasons) {
                SeasonIdentifier season = SeasonIdentifier.forSeason(seasonYear);
                SeasonConfiguration.registerFFactors(season, fFactors);
            }
        }
    }

    public static int[] parsePointsString(String pointsString) {
        String errorMessage = "Illegal race points string: " + pointsString;
        StringTokenizer tokenizer = new StringTokenizer(pointsString.trim(), ".");
        int nTokens = tokenizer.countTokens();
        if (nTokens != 2) {
            throw new IllegalArgumentException(errorMessage);
        }
        int[] data = new int[nTokens];
        for (int i = 0; i < nTokens; ++i) {
            data[i] = RacePoints.parseInt(tokenizer.nextToken(), errorMessage);
        }
        RacePoints.validateParsedData(data, errorMessage);
        return data;
    }

    protected RacePoints(int points, int hundredths) {
        super(points, hundredths);
    }

    public RacePoints add(RacePoints rp) {
        return RacePoints.fromData(this.computeSum(rp));
    }

    public RacePoints difference(RacePoints rp) {
        return RacePoints.fromData(this.computeDifference(rp));
    }

    public String toString() {
        return Integer.toString(this.intValue()) + "." + this.toTwoDigitString(this.hundredthsValue());
    }

    public static void main(String[] args) {
        ConstantLoader.checkSpecificationLoading(BUILTIN_CONSTANT_SPECS);
        RacePoints.loadConstants(BUILTIN_CONSTANT_SPECS);
    }

    static {
        RacePoints.loadConstants(BUILTIN_CONSTANT_SPECS);
    }
}

