/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import org.ussamasters.aces.racedata.models.CompetitorResultValue;
import org.ussamasters.aces.racedata.models.DivisionsCupPoints;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RacePoints;
import org.ussamasters.aces.racedata.models.RaceTime;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.WorldCupPoints;

public class RaceStartResult
extends RacerResult {
    protected DivisionsCupPoints dcPoints;

    public RaceStartResult(RaceEntryResult aRacerResult) {
        this(aRacerResult.getResultValue(), aRacerResult.getPosition(), aRacerResult.isTied(), aRacerResult.getPoints(), aRacerResult.getRacePoints());
        if (!aRacerResult.isStarter()) {
            throw new IllegalArgumentException("Result is not a race start: " + aRacerResult.getName());
        }
    }

    public RaceStartResult(RaceTime resultTime, int position, WorldCupPoints<?> points, RacePoints racePoints) {
        this(resultTime, position, false, points, racePoints);
        if (!this.getResultValue().isStarter()) {
            throw new IllegalArgumentException("Result is not a race start: " + resultTime);
        }
    }

    protected RaceStartResult(CompetitorResultValue<?> result, int position, boolean isTied, WorldCupPoints<?> points, RacePoints racePoints) {
        this.setResultValue(result);
        this.setPosition(position);
        this.setTied(isTied);
        this.setPoints(points);
        this.setRacePoints(racePoints);
        this.setDivisionsCupPoints(DivisionsCupPoints.ZERO);
    }

    @Override
    public void clearPoints() {
        super.clearPoints();
        this.setDivisionsCupPoints(null);
    }

    @Override
    public boolean isStarter() {
        return true;
    }

    public int compareByPoints(RaceStartResult otherResult) {
        int comparison = super.compareByPoints(otherResult);
        return comparison == 0 ? this.compareByPosition(otherResult) : comparison;
    }

    public DivisionsCupPoints getDivisionsCupPoints() {
        return this.dcPoints;
    }

    public void setDivisionsCupPoints(DivisionsCupPoints dcPoints) {
        this.dcPoints = dcPoints;
    }

    public String toString() {
        return String.format("%s<%s>", this.getClass().getSimpleName(), this.toStringResultDetails());
    }

    protected String toStringResultDetails() {
        String result = this.getResultValue().toString();
        return this.isFinisher() ? String.format("%s - %s", this.getPositionString(), result) : result;
    }
}

