/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.reports;

import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.javax.execution.OperatingSystemHelper;
import com.glaivestone.javax.execution.StaticMethodAction;
import com.glaivestone.javax.io.FileSystemReference;
import com.glaivestone.javax.io.FileSystemServices;
import com.glaivestone.javax.io.FileType;
import com.glaivestone.javax.util.PropagatedException;
import com.glaivestone.toolbox.settings.SettingsSection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.logger.NullLogger;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.tools.DocumentInputSource;
import org.jdom2.Document;
import org.jdom2.input.DOMBuilder;
import org.jdom2.transform.JDOMSource;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.io.RaceDataXMLWriter;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.reports.RaceDataReportConstants;
import org.ussamasters.aces.racedata.reports.RaceDataReportOptions;
import org.ussamasters.aces.racedata.reports.RaceScoring;
import org.ussamasters.aces.racedata.reports.RaceScoringDocument;
import org.ussamasters.aces.racedata.reports.SeriesScoring;
import org.ussamasters.aces.racedata.reports.SeriesScoringDocument;
import org.ussamasters.aces.racedata.scoring.RaceStandings;
import org.ussamasters.aces.racedata.scoring.SeriesStandings;
import org.ussamasters.aces.racedata.scoring.Standings;
import org.xml.sax.InputSource;

public class RaceDataReportServices {
    private static final Class<RaceDataReportServices> THIS_CLASS = RaceDataReportServices.class;
    public static boolean DEBUG_REPORTS = false;
    public static final FileType[] ALL_REPORT_TYPES = new FileType[]{RaceDataReportConstants.FILE_TYPE_HTML, RaceDataReportConstants.FILE_TYPE_TEXT, RaceDataReportConstants.FILE_TYPE_PDF};
    public static final List<FileType> SUPPORTED_REPORT_TYPES = Collections.unmodifiableList(Arrays.asList(RaceDataReportConstants.FILE_TYPE_HTML, RaceDataReportConstants.FILE_TYPE_TEXT, RaceDataReportConstants.FILE_TYPE_PDF));
    public static final List<FileType> HTML_REPORTS_ONLY = Arrays.asList(RaceDataReportConstants.FILE_TYPE_HTML);
    public static final List<FileType> TEXT_REPORTS_ONLY = Arrays.asList(RaceDataReportConstants.FILE_TYPE_TEXT);
    public static final List<FileType> PDF_REPORTS_ONLY = Arrays.asList(RaceDataReportConstants.FILE_TYPE_PDF);
    public static final Class<?>[] VALIDATE_DIRECTORY_ACTION_PARM_TYPES = new Class[]{File.class};
    public static final Class<?> VALIDATE_DIRECTORY_ACTION_RETURN_TYPE = File.class;
    public static final EvaluableAction REALIZE_DIRECTORY_ACTION = StaticMethodAction.create(THIS_CLASS, "realizeDirectory", VALIDATE_DIRECTORY_ACTION_PARM_TYPES);
    public static final String REPORT_PARM_ORGANIZATION_TYPE = "organizationType";
    public static final String REPORT_PARM_INCLUDE_RACER_CLASS = "includeRacerClass";
    public static final String REPORT_PARM_INCLUDE_RACER_AFFILIATION = "includeRacerAffiliation";
    public static final String REPORT_PARM_INCLUDE_RACE_POINTS = "includeRacePoints";
    public static final String REPORT_PARM_TRUE = "yes";
    public static final String REPORT_PARM_FALSE = "no";
    protected static final List<FileType> FO_REPORT_TYPES = Collections.unmodifiableList(Arrays.asList(RaceDataReportConstants.FILE_TYPE_PDF));
    public static boolean VALIDATE_SCORING_DOC = false;
    public static boolean PARTITION_REPORTS_DIR_BY_TYPE = false;
    protected static RaceDataReportOptions reportOptions = RaceDataReportOptions.defaultSettings();
    protected static EvaluableAction validateReportDirectoryAction = REALIZE_DIRECTORY_ACTION;
    protected static TransformerFactory transformerFactory;

    private RaceDataReportServices() {
    }

    protected static Transformer createTransformer(Source stylesheet, String[][] parms) throws TransformerConfigurationException {
        int nParms = parms != null ? parms.length : 0;
        Transformer aTransformer = RaceDataReportServices.constructTransformer(stylesheet);
        for (int i = 0; i < nParms; ++i) {
            aTransformer.setParameter(parms[i][0], parms[i][1]);
        }
        return aTransformer;
    }

    protected static Transformer constructTransformer(Source stylesheet) throws TransformerConfigurationException {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory.newTransformer(stylesheet);
    }

    protected static void generateFormattedReport(FileType reportType, org.w3c.dom.Document foDocument, File reportFile) throws RaceDataIOException {
        File scoringDataDirectory = RaceDataReportServices.getReportOptions().getScoringDataDirectory();
        if (scoringDataDirectory != null && RaceDataReportServices.getReportOptions().getSaveReportFormattingSpecifications()) {
            String fileName = RaceDataReportConstants.FILE_TYPE_FO.composeFileName(FileSystemReference.getFileBaseName(reportFile.getName()));
            Document foJDOM = new DOMBuilder().build(foDocument);
            RaceDataXMLWriter writer = new RaceDataXMLWriter(foJDOM);
            RaceDataReportServices.validateScoringDataDirectory(scoringDataDirectory);
            writer.writeFileIn(scoringDataDirectory, fileName);
        }
        if (reportType != RaceDataReportConstants.FILE_TYPE_PDF) {
            throw new IllegalArgumentException("Formatting report type not yet supported: " + reportType);
        }
        try {
            FileOutputStream report = new FileOutputStream(reportFile);
            Driver foProcessor = new Driver((InputSource)new DocumentInputSource(foDocument), (OutputStream)report);
            foProcessor.setLogger((Logger)new NullLogger());
            foProcessor.setRenderer(1);
            foProcessor.run();
            report.flush();
            report.close();
        }
        catch (IOException ex) {
            throw new RaceDataIOException(ex);
        }
        catch (FOPException ex) {
            String msg = ex.getMessage();
            throw new RaceDataIOException((Exception)((Object)ex), msg);
        }
    }

    protected static void generateStandingsReport(FileType reportType, Document scoringDataDocument, String[][] reportParms, File stylesheetFile, File reportFile) throws RaceDataIOException {
        JDOMSource data = new JDOMSource(scoringDataDocument);
        StreamSource stylesheet = new StreamSource(stylesheetFile);
        boolean debugReportFile = DEBUG_REPORTS;
        if (debugReportFile) {
            System.out.println("\n####DEBUG: about to generate " + reportFile.toString());
            System.out.println("...Directory exists: " + (reportFile.getParentFile().isDirectory() ? REPORT_PARM_TRUE : "NO"));
            System.out.println("...File exists: " + (reportFile.isFile() ? REPORT_PARM_TRUE : "NO"));
            if (!reportFile.isFile()) {
                try {
                    reportFile.createNewFile();
                }
                catch (IOException ex) {
                    System.out.println("OOPS: error creating placeholder report file");
                    ex.printStackTrace();
                }
                System.out.println("CREATED PLACEHOLDER: " + (reportFile.isFile() ? REPORT_PARM_TRUE : "NO"));
            }
            System.out.println("Generating reportType " + reportType.toDescriptionString());
        }
        try {
            if (debugReportFile) {
                System.out.println("...create report generator XSL transformer");
            }
            Transformer reportGenerator = RaceDataReportServices.createTransformer(stylesheet, reportParms);
            if (FO_REPORT_TYPES.contains(reportType)) {
                DOMResult fo = new DOMResult();
                if (debugReportFile) {
                    System.out.println("...run report generator XSL transformation");
                }
                reportGenerator.transform((Source)data, fo);
                if (debugReportFile) {
                    System.out.println("...generateFormattedReport for " + reportType.toDescriptionString());
                }
                RaceDataReportServices.generateFormattedReport(reportType, (org.w3c.dom.Document)fo.getNode(), reportFile);
            } else {
                if (debugReportFile) {
                    System.out.println("...create report stream");
                }
                StreamResult report = new StreamResult(reportFile);
                reportGenerator.transform((Source)data, report);
            }
        }
        catch (TransformerException ex) {
            System.out.println("\n####OOPS:");
            ex.printStackTrace();
            throw new RaceDataIOException((Exception)ex, ex.getMessageAndLocation());
        }
    }

    public static List<File> getReportFiles(String rootFileName, FileType reportFileType, File reportsDirectory) {
        ArrayList<File> availableReports = new ArrayList<File>();
        if (!reportsDirectory.exists()) {
            return availableReports;
        }
        String normalizedRootFileName = rootFileName.toLowerCase();
        String extensionSuffix = "." + reportFileType.extension.toLowerCase();
        File[] allFiles = reportsDirectory.listFiles();
        for (int i = 0; i < allFiles.length; ++i) {
            File aFile = allFiles[i];
            String fileName = aFile.getName().toLowerCase();
            if (!fileName.startsWith(normalizedRootFileName) || !fileName.endsWith(extensionSuffix)) continue;
            availableReports.add(aFile);
        }
        return availableReports;
    }

    public static List<File> getReportFiles(String rootFileName, String scoringPolicyName, FileType reportFileType, File reportsDirectory) {
        ArrayList<File> availableReports = new ArrayList<File>();
        if (!reportsDirectory.exists()) {
            return availableReports;
        }
        String fileNamePrefix = rootFileName.toLowerCase() + "-" + scoringPolicyName.toLowerCase();
        File[] allFiles = reportsDirectory.listFiles();
        for (int i = 0; i < allFiles.length; ++i) {
            File aFile = allFiles[i];
            String fileName = aFile.getName().toLowerCase();
            if (!reportFileType.extension.equalsIgnoreCase(FileSystemReference.getFileExtension(fileName)) || !fileName.startsWith(fileNamePrefix) || fileName.lastIndexOf(45) != fileNamePrefix.length()) continue;
            availableReports.add(aFile);
        }
        return availableReports;
    }

    public static RaceDataReportOptions getReportOptions() {
        return reportOptions;
    }

    public static void openReport(File reportFile) {
        try {
            OperatingSystemHelper.current().openFile(reportFile);
        }
        catch (IOException e) {
            System.out.println("***Error: Unable to display results report file " + reportFile.getAbsolutePath());
        }
    }

    public static String raceResultsRootFileName(RaceStandings raceStandings) {
        return RaceDataIOServices.raceResultsRootFileName(raceStandings.getRaceResult().getRaceId());
    }

    protected static File realizeDirectory(File aDirectory) throws RaceDataIOException {
        try {
            aDirectory = FileSystemServices.getCurrent().realizeDirectory(aDirectory);
        }
        catch (IOException ex) {
            throw new RaceDataIOException((Exception)ex, "Unable to create directory: " + aDirectory.getAbsolutePath());
        }
        return aDirectory;
    }

    public static void setReportOptions(SettingsSection reportOptionSettings) {
        reportOptions = reportOptionSettings != null ? new RaceDataReportOptions(reportOptionSettings) : RaceDataReportOptions.defaultSettings();
    }

    public static void setReportOptions(RaceDataReportOptions reportOptionSettings) {
        reportOptions = reportOptionSettings != null ? reportOptionSettings : RaceDataReportOptions.defaultSettings();
    }

    public static void setValidateReportDirectoryAction(EvaluableAction anAction) {
        if (anAction == null) {
            throw new IllegalArgumentException("Validate report directory action may not be null");
        }
        validateReportDirectoryAction = anAction;
    }

    protected static File validateReportsDirectory(File reportsDirectory) throws RaceDataIOException {
        try {
            return (File)validateReportDirectoryAction.evaluate(reportsDirectory);
        }
        catch (PropagatedException exWrapper) {
            Throwable ex = exWrapper.getCause();
            if (ex instanceof RaceDataIOException) {
                throw (RaceDataIOException)ex;
            }
            if (ex instanceof Exception) {
                throw new RaceDataIOException((Exception)ex);
            }
            if (ex instanceof Error) {
                throw (Error)ex;
            }
            throw exWrapper;
        }
    }

    protected static File validateScoringDataDirectory(File scoringDataDirectory) throws RaceDataIOException {
        return RaceDataReportServices.realizeDirectory(scoringDataDirectory);
    }

    public static void writeRaceResultsReports(RaceResult raceResult, RacerList racerInfo, List<FileType> reportTypes, File reportsDirectory, boolean displayReports) throws RaceDataIOException {
        RaceScoring scoringData = new RaceScoring(raceResult, racerInfo);
        Document scoringDataDocument = new RaceScoringDocument(scoringData, racerInfo).getDocument();
        boolean includeAffiliationSetting = RaceDataReportServices.getReportOptions().getIncludeRacerAffiliationInReports();
        String[][] reportParms = new String[][]{{REPORT_PARM_ORGANIZATION_TYPE, null}, {REPORT_PARM_INCLUDE_RACER_CLASS, null}, {REPORT_PARM_INCLUDE_RACER_AFFILIATION, includeAffiliationSetting && racerInfo != null ? REPORT_PARM_TRUE : REPORT_PARM_FALSE}, {REPORT_PARM_INCLUDE_RACE_POINTS, null}};
        File scoringDataDirectory = RaceDataReportServices.getReportOptions().getScoringDataDirectory();
        if (scoringDataDirectory != null && RaceDataReportServices.getReportOptions().getSaveReportScoringData()) {
            RaceDataXMLWriter writer = new RaceDataXMLWriter(scoringDataDocument);
            String fileName = writer.composeFileName(RaceDataIOServices.raceResultsRootFileName(scoringData.getRaceId()));
            RaceDataReportServices.validateScoringDataDirectory(scoringDataDirectory);
            writer.writeFileIn(scoringDataDirectory, fileName);
        }
        if (DEBUG_REPORTS) {
            System.out.println("\n####Writing race results reports");
            System.out.println("...reportsDirectory.getPath(): " + reportsDirectory.getPath());
            System.out.println("...reportsDirectory.getAbsolutePath(): " + reportsDirectory.getAbsolutePath());
        }
        RaceDataReportServices.validateReportsDirectory(reportsDirectory);
        if (DEBUG_REPORTS) {
            System.out.println("...reportsDirectory found: " + (reportsDirectory.isDirectory() ? "ok" : "***NOT FOUND**"));
        }
        for (FileType reportType : reportTypes) {
            File stylesheetFile = RaceDataReportServices.getReportOptions().getRaceReportTransformation(reportType);
            reportParms[3][1] = reportType == RaceDataReportConstants.FILE_TYPE_TEXT && !RaceDataReportServices.getReportOptions().getIncludeRacePointsInTextReports() ? REPORT_PARM_FALSE : REPORT_PARM_TRUE;
            for (RaceStandings standings : scoringData.getStandings()) {
                StandingsOrganizationType organizationType = standings.getOrganizationType();
                String reportFileName = reportType.composeFileName(standings.standardReferenceName());
                File reportFile = new File(reportsDirectory, reportFileName);
                reportParms[0][1] = organizationType.name();
                String string = reportParms[1][1] = RaceClass.getAllRaceClasses().contains(organizationType.categoryClass()) ? REPORT_PARM_FALSE : REPORT_PARM_TRUE;
                if (DEBUG_REPORTS) {
                    System.out.println("...reportFile.getPath(): " + reportFile.getPath());
                }
                RaceDataReportServices.generateStandingsReport(reportType, scoringDataDocument, reportParms, stylesheetFile, reportFile);
                if (!displayReports) continue;
                RaceDataReportServices.openReport(reportFile);
            }
        }
    }

    public static void writeSeriesStandingsReports(SeriesScoring scoringData, List<FileType> reportTypes, File reportsDirectory, boolean displayReports) throws RaceDataIOException {
        Document scoringDataDocument = new SeriesScoringDocument(scoringData).getDocument();
        boolean includeAffiliationSetting = RaceDataReportServices.getReportOptions().getIncludeRacerAffiliationInReports();
        String[][] reportParms = new String[][]{{REPORT_PARM_ORGANIZATION_TYPE, null}, {REPORT_PARM_INCLUDE_RACER_CLASS, null}, {REPORT_PARM_INCLUDE_RACER_AFFILIATION, null}};
        File scoringDataDirectory = RaceDataReportServices.getReportOptions().getScoringDataDirectory();
        if (scoringDataDirectory != null && RaceDataReportServices.getReportOptions().getSaveReportScoringData()) {
            RaceDataXMLWriter writer = new RaceDataXMLWriter(scoringDataDocument);
            String fileName = writer.composeFileName(RaceDataIOServices.seriesStandingsRootFileName((SeriesStandings)scoringData.getStandings().get(0)));
            RaceDataReportServices.validateScoringDataDirectory(scoringDataDirectory);
            writer.writeFileIn(scoringDataDirectory, fileName);
        }
        RaceDataReportServices.validateReportsDirectory(reportsDirectory);
        for (FileType reportType : reportTypes) {
            File stylesheetFile = RaceDataReportServices.getReportOptions().getSeriesReportTransformation(reportType);
            for (Standings ss : scoringData.getStandings()) {
                SeriesStandings standings = (SeriesStandings)ss;
                StandingsOrganizationType organizationType = standings.getOrganizationType();
                String reportFileName = reportType.composeFileName(RaceDataIOServices.seriesStandingsBaseFileName(standings));
                File reportFile = new File(reportsDirectory, reportFileName);
                reportParms[0][1] = organizationType.name();
                reportParms[1][1] = RaceClass.getAllRaceClasses().contains(organizationType.categoryClass()) ? REPORT_PARM_FALSE : REPORT_PARM_TRUE;
                reportParms[2][1] = includeAffiliationSetting && !organizationType.categoryClass().equals(RaceOrganization.class) ? REPORT_PARM_TRUE : REPORT_PARM_FALSE;
                RaceDataReportServices.generateStandingsReport(reportType, scoringDataDocument, reportParms, stylesheetFile, reportFile);
                if (!displayReports) continue;
                RaceDataReportServices.openReport(reportFile);
            }
        }
    }
}

