/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.reports;

import com.glaivestone.javax.lang.ConstantValueWithDescription;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.DocType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.models.AllRacersCategory;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.NamedRacerResult;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassRegistry;
import org.ussamasters.aces.racedata.models.RaceDate;
import org.ussamasters.aces.racedata.models.RaceDescriptor;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.ScoringResult;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.models.StandingsSummaryData;
import org.ussamasters.aces.racedata.models.USSALicense;
import org.ussamasters.aces.racedata.reports.ScoringData;
import org.ussamasters.aces.racedata.reports.StandingsReportPolicy;
import org.ussamasters.aces.racedata.reports.StandingsReportPolicyRegistry;
import org.ussamasters.aces.racedata.scoring.CategoryResultsList;
import org.ussamasters.aces.racedata.scoring.Standings;

public abstract class ScoringDataDocument {
    public static boolean EMIT_DOCTYPE_DECL = false;
    public static boolean EMIT_SCHEMA_DECL = false;
    public static final String NAMESPACE_ATTR_PREFIX = "xmlns";
    public static final String XSI_NAMESPACE_PREFIX = "xsi";
    public static final String XSI_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final Namespace XSI_NAMESPACE = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    public static final String NO_NAMESPACE_SCHEMA_ATTR = "noNamespaceSchemaLocation";
    public static final String EN_DATE = "date";
    public static final String AN_DATE_DAY = "day";
    public static final String AN_DATE_MONTH = "month";
    public static final String AN_DATE_YEAR = "year";
    public static final String EN_NAME = "name";
    public static final String AN_NAME = "name";
    public static final String EN_DESCRIPTION = "description";
    public static final String AN_ABBREVIATION = "abbrev";
    public static final String AN_CLASSES = "classes";
    public static final String AN_RACER_STATUS = "status";
    public static final String EN_POSITION = "position";
    public static final String AN_TIED = "tie";
    public static final String AN_SUMMARY_CATEGORY = "category";
    public static final String AN_NUM_STARTERS = "nStarters";
    public static final String AN_NUM_QUALIFIERS = "nQualifiers";
    public static final String AN_NUM_STARTS = "nStarts";
    public static final String AN_NUM_FINISHES = "nFinishes";
    public static final String EN_RACE = "race";
    public static final String EN_LOCATION = "location";
    public static final String EN_DISCIPLINE = "discipline";
    public static final String EN_RACE_ID = "raceID";
    public static final String EN_NRUNS = "nRuns";
    public static final String EN_COURSE_ARRANGEMENT = "courses";
    public static final String EN_SCORING_SECTION = "scoring";
    public static final String EN_COMPETITORS_SECTION = "competitors";
    public static final String EN_COMPETITOR = "competitor";
    public static final String AN_RACER_ID = "id";
    public static final String EN_GENDER = "gender";
    public static final String EN_CLASS = "class";
    public static final String EN_LAST_NAME = "lastName";
    public static final String EN_FIRST_NAME = "firstName";
    public static final String EN_BIB = "bib";
    public static final String EN_LICENSE = "license";
    public static final String EN_AFFILIATION = "affiliation";
    public static final String EN_YEAR_BORN = "yearBorn";
    public static final String EN_STANDINGS_SECTION = "standings";
    public static final String AN_SINGLE_CATEGORY = "singleCategory";
    public static final String EN_STANDINGS_SUMMARY = "standingsSummary";
    public static final String EN_SUMMARY_COMPETITORS = "competitorSummary";
    public static final String EN_GROUP_STANDINGS = "groupStandings";
    public static final String EN_COMPETITOR_RESULT = "racerResult";
    public static final String AN_RACER_ID_REF = "racerID";
    public static final String AN_RACER_AGE_CLASS = "ageClass";
    public static final String EN_AUX_INFO_SECTION = "auxInfo";
    public static final String EN_AUX_INFO_SOFTWARE_NAME = "softwareName";
    public static final String EN_AUX_INFO_SOFTWARE_VERSION = "softwareVersion";
    public static final String EN_AUX_INFO_SOFTWARE_DESCRIPTION = "softwareDescription";
    public static final String ATTR_VALUE_YES = "yes";
    public static final String ATTR_VALUE_NO = "no";
    public static final String RACER_ID_PREFIX = "rid";
    public static final String GENDER_MEN = "M";
    public static final String GENDER_WOMEN = "F";
    public static final String VALUE_TIED = "yes";
    public static final String VALUE_SINGLE_CATEGORY_STANDINGS = "yes";
    public static final String STATUS_DID_NOT_START = "DNS";
    public static final String STATUS_NOT_QUALIFIED = "DNQ";
    public static final String STATUS_QUALIFIED = "QLF";
    public static final Object ALL_RACERS_CATEGORY = AllRacersCategory.ALL_RACERS;
    public static final String VALUE_CATEGORY_ALL = "all";
    public static String softwareName = "ACE Scoring";
    public static String softwareVersion = "5.0";
    public static String supportHref = "http://www.glaivestone.com";
    protected Document document;
    protected Element rootElement;
    protected StandingsReportPolicy reportPolicy;

    protected ScoringDataDocument() {
    }

    protected Element addTextElement(String elementName, String text, Element parent) {
        Element anElement = this.createTextElement(elementName, text);
        parent.addContent((Content)anElement);
        return anElement;
    }

    protected void appendOptionalCompetitorElements(Racer aRacer, Element competitorElement) {
        RaceOrganization affiliation;
        if (aRacer == null) {
            return;
        }
        USSALicense license = aRacer.getUSSALicense();
        if (USSALicense.isValid(license.toString())) {
            competitorElement.addContent((Content)this.createTextElement(EN_LICENSE, license.toString()));
        }
        if ((affiliation = aRacer.getAffiliation()) != null && affiliation.isRecognizedOrganization()) {
            Element anElement = this.createConstantElement(EN_AFFILIATION, affiliation);
            anElement.setAttribute(AN_ABBREVIATION, affiliation.abbreviation);
            competitorElement.addContent((Content)anElement);
        }
        if (aRacer.isBirthYearKnown()) {
            competitorElement.addContent((Content)this.createTextElement(EN_YEAR_BORN, "" + aRacer.getBirthYear()));
        }
    }

    protected void buildDocument() {
        this.initDocument();
        this.buildDocumentContent();
    }

    protected void buildDocumentContent() {
    }

    protected Element createAuxInfoSection() {
        Element aSection = new Element(EN_AUX_INFO_SECTION);
        this.addTextElement(EN_AUX_INFO_SOFTWARE_NAME, softwareName, aSection);
        this.addTextElement(EN_AUX_INFO_SOFTWARE_VERSION, softwareVersion, aSection);
        this.addTextElement(EN_AUX_INFO_SOFTWARE_DESCRIPTION, softwareName + " " + softwareVersion + " (" + supportHref + ")", aSection);
        return aSection;
    }

    protected Element createCompetitorElement(NamedRacerResult racerResult, RaceClass<?> aRaceClass) {
        Element anElement = new Element(EN_COMPETITOR);
        anElement.setAttribute(AN_RACER_ID, this.toRacerID(racerResult));
        anElement.addContent((Content)this.createGenderElement(racerResult.getGender()));
        this.addTextElement(EN_CLASS, aRaceClass.name, anElement);
        this.addTextElement(EN_LAST_NAME, racerResult.getLastName(), anElement);
        this.addTextElement(EN_FIRST_NAME, racerResult.getFirstName(), anElement);
        this.addTextElement(EN_BIB, racerResult.getBib(), anElement);
        this.appendOptionalCompetitorElements(this.getScoringData().getRacer(racerResult), anElement);
        return anElement;
    }

    protected Element createCompetitorElement(Racer aRacer, RaceClass<?> aRaceClass) {
        Element anElement = new Element(EN_COMPETITOR);
        anElement.setAttribute(AN_RACER_ID, this.toRacerID(aRacer));
        anElement.addContent((Content)this.createGenderElement(aRacer.getGender()));
        this.addTextElement(EN_CLASS, aRaceClass.name, anElement);
        this.addTextElement(EN_LAST_NAME, aRacer.getLastName(), anElement);
        this.addTextElement(EN_FIRST_NAME, aRacer.getFirstName(), anElement);
        this.addTextElement(EN_BIB, aRacer.getBib(), anElement);
        this.appendOptionalCompetitorElements(aRacer, anElement);
        return anElement;
    }

    protected Element createCompetitorPositionElement(NamedRacerResult racerResult) {
        Element anElement = this.createTextElement(EN_POSITION, "" + racerResult.getPosition());
        if (racerResult.isTied()) {
            anElement.setAttribute(AN_TIED, "yes");
        }
        return anElement;
    }

    protected Element createCompetitorResultElement(NamedRacerResult racerResult, Object category) {
        Element anElement = new Element(EN_COMPETITOR_RESULT);
        anElement.setAttribute(AN_RACER_ID_REF, this.toRacerID(racerResult));
        return anElement;
    }

    protected Element createConstantElement(String elementName, ConstantValueWithDescription<?> aConstant) {
        return this.createNamedTextElement(elementName, aConstant.name(), aConstant.description());
    }

    protected Element createConstantElement(String elementName, String name, String description) {
        return this.createNamedTextElement(elementName, name, description);
    }

    protected Element createNamedTextElement(String elementName, String name, String text) {
        Element anElement = this.createTextElement(elementName, text);
        anElement.setAttribute("name", name);
        return anElement;
    }

    protected Element createDateElement(RaceDate aDate) {
        Element anElement = this.createTextElement(EN_DATE, aDate.toRenderingString());
        anElement.setAttribute(AN_DATE_YEAR, Integer.toString(aDate.getYear()));
        anElement.setAttribute(AN_DATE_MONTH, Integer.toString(aDate.getMonthIndex()));
        anElement.setAttribute(AN_DATE_DAY, Integer.toString(aDate.getDay()));
        return anElement;
    }

    protected Element createGenderElement(Gender gender) {
        return this.createTextElement(EN_GENDER, this.toGenderString(gender));
    }

    protected Element createRaceClassesConstantElement(Class<? extends RaceClass<?>> raceClassClass) {
        return this.createConstantElement(AN_CLASSES, RaceDataIOServices.raceClassToLiteral(raceClassClass), RaceClassRegistry.current().getDescription(raceClassClass));
    }

    protected Element createRaceElement(RaceDescriptor aRace) {
        Element anElement = new Element(EN_RACE);
        this.addTextElement(EN_RACE_ID, aRace.getRaceId().toReferenceString(), anElement);
        anElement.addContent((Content)this.createDateElement(aRace.getDate()));
        anElement.addContent((Content)this.createConstantElement(EN_LOCATION, aRace.getLocation().name, aRace.getLocation().fullName));
        this.addTextElement(EN_DISCIPLINE, aRace.getType().basicType.name, anElement);
        this.addTextElement(EN_NRUNS, Integer.toString(aRace.getNumberOfRuns()), anElement);
        anElement.addContent((Content)this.createRaceClassesConstantElement(aRace.getRaceClassClass()));
        anElement.addContent((Content)this.createConstantElement(EN_COURSE_ARRANGEMENT, aRace.getCourseArrangement()));
        return anElement;
    }

    protected Element createStandingsSection(Standings standings) {
        StandingsOrganizationType orgType = standings.getOrganizationType();
        Element aSection = this.createStandingsSectionElement(standings);
        aSection.addContent((Content)this.createStandingsSummaryElement(standings));
        for (StandingsCategory standingsCategory : standings.categories()) {
            CategoryResultsList<?> categoryResultsList = standings.getCategoryResults(standingsCategory);
            if (!this.shouldWriteCategoryResults(categoryResultsList)) continue;
            Element groupStandings = new Element(EN_GROUP_STANDINGS);
            groupStandings.setAttribute("name", orgType.categoryName(standingsCategory));
            this.addTextElement(EN_DESCRIPTION, orgType.categoryDescription(standingsCategory), groupStandings);
            int nQualifiers = 0;
            ScoringResult lastQualifier = null;
            for (Object rr : categoryResultsList) {
                NamedRacerResult racerResult = (NamedRacerResult)rr;
                if (!this.shouldWriteRacerEntry(racerResult)) continue;
                groupStandings.addContent((Content)this.createCompetitorResultElement(racerResult, standingsCategory));
                if (!this.isQualified(racerResult)) continue;
                lastQualifier = racerResult;
                ++nQualifiers;
            }
            if (lastQualifier != null && lastQualifier.isTied()) {
                groupStandings.setAttribute(AN_NUM_QUALIFIERS, "" + nQualifiers);
            }
            aSection.addContent((Content)groupStandings);
        }
        return aSection;
    }

    protected Element createStandingsSectionElement(Standings standings) {
        Element anElement = new Element(EN_STANDINGS_SECTION);
        anElement.setAttribute("name", standings.organizationTypeName());
        if (standings.getOrganizationType().categories().size() == 1) {
            anElement.setAttribute(AN_SINGLE_CATEGORY, "yes");
        }
        this.addTextElement(EN_DESCRIPTION, standings.organizationDescription(), anElement);
        return anElement;
    }

    protected Element createStandingsSummaryElement(Standings standings) {
        Element anElement = new Element(EN_STANDINGS_SUMMARY);
        StandingsSummaryData[] competitorStats = standings.getCompetitorStatistics();
        StandingsSummaryData[] qualifierStats = standings.getQualifierStatistics();
        for (int i = 0; i < competitorStats.length; ++i) {
            Element statsElement = this.createSummaryCompetitorsElement(competitorStats[i], qualifierStats[i]);
            anElement.addContent((Content)statsElement);
        }
        return anElement;
    }

    protected Element createSummaryCompetitorsElement(StandingsSummaryData competitorStats, StandingsSummaryData qualifierStats) {
        Element anElement = new Element(EN_SUMMARY_COMPETITORS);
        anElement.setAttribute(AN_SUMMARY_CATEGORY, this.toCategoryString(competitorStats.getCategory()));
        anElement.setAttribute(AN_NUM_STARTERS, "" + competitorStats.getTotal());
        anElement.setAttribute(AN_NUM_QUALIFIERS, "" + qualifierStats.getTotal());
        return anElement;
    }

    protected Element createTextElement(String elementName, String text) {
        return new Element(elementName).setText(text);
    }

    protected Element getRootElement() {
        return this.rootElement;
    }

    public Document getDocument() {
        if (this.document == null) {
            this.buildDocument();
        }
        return this.document;
    }

    protected abstract ScoringData<?> getScoringData();

    protected abstract void initDocument();

    protected void initDocument(String rootNodeName, DocType docType, String schemaURI) {
        String defaultNamespaceURI = EMIT_SCHEMA_DECL ? schemaURI : null;
        this.rootElement = new Element(rootNodeName, defaultNamespaceURI);
        this.document = new Document(this.rootElement, (DocType)(EMIT_DOCTYPE_DECL ? docType : null));
        if (!EMIT_DOCTYPE_DECL) {
            this.document.getContent().add(0, new Comment(docType.toString()));
        }
        if (EMIT_SCHEMA_DECL) {
            // empty if block
        }
    }

    protected void initDocument(String rootNodeName, String dtdURI, String schemaURI) {
        this.initDocument(rootNodeName, new DocType(rootNodeName, dtdURI), schemaURI);
    }

    protected boolean isAbilityClassCategory(Object category) {
        return category instanceof RaceClass && ((RaceClass)category).isAbilityGroupClass();
    }

    protected boolean isAgeClassCategory(Object category) {
        return category instanceof RaceClass && ((RaceClass)category).isAgeGroupClass();
    }

    protected abstract boolean isQualified(NamedRacerResult var1);

    protected void setReportPolicy(Standings standings) {
        this.setReportPolicy(StandingsReportPolicyRegistry.getReportPolicy(standings.categoryClass()));
    }

    protected void setReportPolicy(StandingsReportPolicy reportPolicy) {
        this.reportPolicy = reportPolicy;
    }

    protected boolean shouldWriteCategoryResults(CategoryResultsList<?> categoryResultsList) {
        return categoryResultsList != null && categoryResultsList.size() > 0;
    }

    protected boolean shouldWriteRacerEntry(NamedRacerResult racerResult) {
        return true;
    }

    protected String toCategoryString(Object category) {
        if (category == ALL_RACERS_CATEGORY) {
            return VALUE_CATEGORY_ALL;
        }
        if (category instanceof Gender) {
            return this.toGenderString((Gender)category);
        }
        throw new IllegalArgumentException("UNKNOWN STATISTICS CATEGORY: " + category);
    }

    protected String toGenderString(Gender gender) {
        return gender == Gender.MEN ? GENDER_MEN : GENDER_WOMEN;
    }

    protected String toRacerID(NamedRacerResult racerResult) {
        return RACER_ID_PREFIX + racerResult.getBibNumber();
    }

    protected String toRacerID(Racer aRacer) {
        return RACER_ID_PREFIX + aRacer.getBibNumber();
    }
}

