/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.reports;

import java.util.ArrayList;
import java.util.List;
import org.ussamasters.aces.racedata.models.NamedRacerResult;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.ScoringElement;
import org.ussamasters.aces.racedata.models.StandingsType;
import org.ussamasters.aces.racedata.reports.ScoringData;
import org.ussamasters.aces.racedata.scoring.SeriesStandings;
import org.ussamasters.aces.racedata.scoring.SeriesStandingsScoringPolicy;

public class SeriesScoring
extends ScoringData<SeriesStandings> {
    protected RaceSeries raceSeries;
    protected StandingsType standingsType;
    protected SeriesStandingsScoringPolicy scoringPolicy;

    public SeriesScoring(SeriesStandings seriesStandings) {
        this(SeriesScoring.toStandingsList(seriesStandings));
    }

    public SeriesScoring(List<SeriesStandings> standings) {
        super(standings);
        this.initialize();
    }

    protected static List<SeriesStandings> toStandingsList(SeriesStandings seriesStandings) {
        ArrayList<SeriesStandings> standings = new ArrayList<SeriesStandings>();
        standings.add(seriesStandings);
        return standings;
    }

    public String getDescription() {
        return ((SeriesStandings)this.getFirstStandings()).getDescription();
    }

    @Override
    public Racer getRacer(NamedRacerResult racerResult) {
        return ((RaceSeriesResult)racerResult).getRacer();
    }

    public RaceSeries getRaceSeries() {
        return this.raceSeries;
    }

    public ScoringElement getScoringElement() {
        return this.scoringPolicy.getScoringElement();
    }

    public SeriesStandingsScoringPolicy getScoringPolicy() {
        return this.scoringPolicy;
    }

    public StandingsType getStandingsType() {
        return this.standingsType;
    }

    protected void initialize() {
        SeriesStandings first = (SeriesStandings)this.getFirstStandings();
        this.raceSeries = first.getRaceSeries();
        this.standingsType = first.getType();
        this.scoringPolicy = first.getScoringPolicy();
    }
}

