/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassRegistry;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.SeriesRacerSummary;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.scoring.BasicRacerResultOrganizer;
import org.ussamasters.aces.racedata.scoring.RaceDataScoringException;
import org.ussamasters.aces.racedata.scoring.RaceStandings;
import org.ussamasters.aces.racedata.scoring.RacerResultOrganizingPolicy;

public abstract class BasicRaceSeriesResultsOrganizer
extends BasicRacerResultOrganizer<RaceStartResult, RaceSeriesResult> {
    protected static final Comparator<SeriesRacerSummary> MULTI_CATEGORY_RACER_SORTER = new Comparator<SeriesRacerSummary>(){

        @Override
        public int compare(SeriesRacerSummary rs1, SeriesRacerSummary rs2) {
            return rs1.getRacer().compareByAgeClass(rs2.getRacer());
        }
    };
    protected static final List<RaceClassType> DIVISIONS_WITH_GROUP_D_SCORING_HACK = Collections.unmodifiableList(Arrays.asList(RaceClassType.farwest_masters, RaceClassType.intermountain_masters));
    private RaceSeries raceSeries;
    private Map<String, Racer> registeredRacersTable;
    private Map<String, SeriesRacerSummary> racerSummaryTable;
    private List<SeriesRacerSummary> multiCategoryRacers;
    private int raceIndex;
    private Map<String, Map<StandingsCategory, RaceSeriesResult>> racerCategoryResultsIndex;

    protected BasicRaceSeriesResultsOrganizer(RaceSeries raceSeries, RacerList registeredRacers, RacerResultOrganizingPolicy<RaceStartResult> organizingPolicy) {
        super(organizingPolicy);
        this.initRegisteredRacersTable(registeredRacers);
        this.raceSeries = raceSeries;
    }

    protected void clearRaceIndex() {
        this.raceIndex = -1;
    }

    public void clearStandings() {
        for (SeriesRacerSummary seriesRacerSummary : this.racerSummaries()) {
            seriesRacerSummary.clearResults();
        }
        for (Map map : this.racerCategoryResultsIndex.values()) {
            for (RaceSeriesResult seriesResult : map.values()) {
                seriesResult.clearResults();
            }
        }
    }

    protected List<SeriesRacerSummary> computeMultiCategoryRacers() {
        ArrayList<SeriesRacerSummary> mcRacers = new ArrayList<SeriesRacerSummary>();
        for (SeriesRacerSummary racerSummary : this.racerSummaries()) {
            if (!racerSummary.hasStartsInMultipleCategories()) continue;
            mcRacers.add(racerSummary);
        }
        Collections.sort(mcRacers, MULTI_CATEGORY_RACER_SORTER);
        return mcRacers;
    }

    protected RaceSeriesResult constructSeriesResult(SeriesRacerSummary racerSummary, RaceClass<?> raceClass, StandingsCategory category) {
        return new RaceSeriesResult(racerSummary, raceClass, category, this.getNumberOfRaces());
    }

    protected SeriesRacerSummary findOrCreateRacerSummary(String bib) {
        SeriesRacerSummary racerSummary = this.racerSummaryTable.get(bib);
        if (racerSummary == null) {
            racerSummary = new SeriesRacerSummary(this.getRacer(bib));
            this.racerSummaryTable.put(bib, racerSummary);
        }
        return racerSummary;
    }

    protected RaceSeriesResult findOrCreateSeriesResult(String bib, StandingsCategory category, RaceClass<?> raceClass) {
        RaceSeriesResult seriesResult;
        Map<StandingsCategory, RaceSeriesResult> categoryResultsIndex = this.racerCategoryResultsIndex.get(bib);
        if (categoryResultsIndex == null) {
            categoryResultsIndex = new HashMap<StandingsCategory, RaceSeriesResult>();
            this.racerCategoryResultsIndex.put(bib, categoryResultsIndex);
        }
        if ((seriesResult = categoryResultsIndex.get(category)) == null) {
            SeriesRacerSummary racerSummary = this.findOrCreateRacerSummary(bib);
            seriesResult = this.constructSeriesResult(racerSummary, raceClass, category);
            categoryResultsIndex.put(category, seriesResult);
            super.storeResultEntry(category, seriesResult);
        }
        return seriesResult;
    }

    @Override
    protected void finishResultsOrganizing() {
        super.finishResultsOrganizing();
        this.multiCategoryRacers = this.computeMultiCategoryRacers();
        this.clearRaceIndex();
    }

    public List<SeriesRacerSummary> getMultiCategoryRacers() {
        return this.multiCategoryRacers;
    }

    public int getNumberOfRaces() {
        return this.getRaceSeries().size();
    }

    protected RaceClass<?> getRaceClass(RaceEntryResult racerResult) {
        return racerResult.getRaceClass();
    }

    public Racer getRacer(String bib) {
        return this.registeredRacersTable.get(bib);
    }

    public SeriesRacerSummary getRacerSummary(String bib) {
        return this.racerSummaryTable.get(bib);
    }

    public RaceSeries getRaceSeries() {
        return this.raceSeries;
    }

    protected void initRegisteredRacersTable(RacerList registeredRacers) {
        this.registeredRacersTable = new HashMap<String, Racer>();
        for (Racer aRacer : registeredRacers.getRacers()) {
            this.registeredRacersTable.put(aRacer.getBib(), aRacer);
        }
    }

    protected boolean mayHaveMultiCategoryRacers() {
        return this.getOrganizingPolicy().mayHaveMultiCategoryRacers();
    }

    @Override
    protected void performResultsOrganization() {
        for (RaceResult raceResult : this.raceResults()) {
            this.processRaceResult(raceResult);
            ++this.raceIndex;
        }
    }

    @Override
    protected void prepareToOrganizeResults() {
        super.prepareToOrganizeResults();
        this.racerSummaryTable = new HashMap<String, SeriesRacerSummary>();
        this.raceIndex = 0;
        this.racerCategoryResultsIndex = new HashMap<String, Map<StandingsCategory, RaceSeriesResult>>();
    }

    protected RaceResult prepareRaceResultForProcessing(RaceResult raceResult) {
        if (this.isOrganizedByClass()) {
            return raceResult;
        }
        if (this.categoryClass().equals(Gender.class) && DIVISIONS_WITH_GROUP_D_SCORING_HACK.contains(RaceClassRegistry.current().getRaceClassType(this.getRaceSeries().getRaceClassClass())) && RaceStandings.isNationalsCourseSplitWithSeparateGroupDMensCourse(raceResult)) {
            return this.prepareRaceResultForProcessingWithGroupDGenderHack(raceResult);
        }
        return this.prepareRaceResultForProcessingNormal(raceResult);
    }

    protected RaceResult prepareRaceResultForProcessingNormal(RaceResult raceResult) {
        RaceStandings raceStandings = RaceStandings.computeStandings(raceResult, this.getOrganizationType());
        if (raceStandings == null) {
            throw new RaceDataScoringException(String.format("Standings organization %s not supported on %s", this.getOrganizationType(), raceResult));
        }
        return raceStandings.getRaceResult();
    }

    protected RaceResult prepareRaceResultForProcessingWithGroupDGenderHack(RaceResult raceResult) {
        RaceStandings standings = RaceStandings.constructStandings(raceResult, this.getOrganizationType());
        standings.computeStandings();
        return standings.getRaceResult();
    }

    @Override
    protected void processRaceResult(RaceResult raceResult) {
        super.processRaceResult(this.prepareRaceResultForProcessing(raceResult));
    }

    protected RaceStartResult getResultForStandings(RaceEntryResult racerResult) {
        return (RaceStartResult)this.getOrganizingPolicy().getResult(racerResult);
    }

    @Override
    protected void processRacerResult(RaceEntryResult racerResult) {
        RaceStartResult seriesStartResult = this.getResultForStandings(racerResult);
        if (seriesStartResult == null) {
            return;
        }
        StandingsCategory category = this.getCategory(racerResult);
        RaceSeriesResult seriesResult = this.findOrCreateSeriesResult(racerResult.getBib(), category, this.getRaceClass(racerResult));
        seriesResult.putStartResult(this.raceIndex, seriesStartResult);
    }

    protected List<RaceResult> raceResults() {
        return this.getRaceSeries().getRaceResults();
    }

    protected Collection<SeriesRacerSummary> racerSummaries() {
        return this.racerSummaryTable.values();
    }

    public String toString() {
        return String.format("%s<%s, %s>", this.getClass().getSimpleName(), this.getOrganizationType().name(), this.getOrganizingPolicy());
    }

    @Override
    protected void validateOrganization() {
        super.validateOrganization();
        int nMultiCategoryRacers = this.getMultiCategoryRacers().size();
        if (nMultiCategoryRacers > 0 && !this.mayHaveMultiCategoryRacers()) {
            throw new IllegalStateException("Multi-category racers not expected for organization by " + this.getOrganizationType().name() + " (" + nMultiCategoryRacers + " found)");
        }
    }
}

