/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.StandardOrganizationType;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.scoring.BasicEventStandings;
import org.ussamasters.aces.racedata.scoring.BasicRaceSeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.BernardCupScoringPolicy;
import org.ussamasters.aces.racedata.scoring.SeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.SeriesStandings;
import org.ussamasters.aces.racedata.scoring.SeriesStandingsScoringPolicy;

public class BernardCupStandings
extends BasicEventStandings {
    protected static final StandingsOrganizationType BERNARD_CUP_ORGANIZATION_TYPE = StandardOrganizationType.BY_GENDER;

    public static BernardCupStandings computeStandings(String eventShortName, RaceSeries raceSeries, RacerList registeredRacers) {
        BernardCupStandings standings = new BernardCupStandings(eventShortName, raceSeries, registeredRacers);
        standings.computeStandings();
        return standings;
    }

    public static SeriesStandings forRaceSeries(String eventShortName, RaceSeries raceSeries, RacerList registeredRacers, StandingsOrganizationType organizationType) {
        if (organizationType != BERNARD_CUP_ORGANIZATION_TYPE) {
            throw new IllegalArgumentException("Invalid results organization: " + organizationType.name());
        }
        return new BernardCupStandings(eventShortName, raceSeries, registeredRacers);
    }

    public BernardCupStandings(String eventShortName, RaceSeries raceSeries, RacerList registeredRacers) {
        super(eventShortName, raceSeries, (BasicRaceSeriesResultsOrganizer)SeriesResultsOrganizer.forRaceSeries(raceSeries, registeredRacers, BERNARD_CUP_ORGANIZATION_TYPE));
        this.setScoringPolicy(new BernardCupScoringPolicy());
    }

    @Override
    public void computeStandings(SeriesStandingsScoringPolicy scoringPolicy) {
        if (scoringPolicy != this.getScoringPolicySpecification()) {
            throw new UnsupportedOperationException("Only standard Bernard Cup standings computation is allowed");
        }
        super.computeStandings(scoringPolicy);
    }
}

