/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.ussamasters.aces.racedata.models.DivisionsCupPoints;
import org.ussamasters.aces.racedata.models.DivisionsCupResult;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.scoring.CategoryResultsList;
import org.ussamasters.aces.racedata.scoring.DivisionsCupScoringPolicy;
import org.ussamasters.aces.racedata.scoring.DivisionsCupSeriesResultsOrganizer;

public class DivisionsCup80ScoringPolicy
extends DivisionsCupScoringPolicy {
    public static final boolean BEST_80_BY_RACER = true;
    public static final boolean BEST_80_BY_STARTS = false;
    public static Comparator<RaceSeriesResult> compareRacersByDivCupPoints = new Comparator<RaceSeriesResult>(){

        @Override
        public int compare(RaceSeriesResult racer1Result, RaceSeriesResult racer2Result) {
            return racer1Result.getDivisionsCupPoints().compareTo(racer2Result.getDivisionsCupPoints());
        }
    };
    public static Comparator<RaceStartResult> compareStartsByDivCupPoints = new Comparator<RaceStartResult>(){

        @Override
        public int compare(RaceStartResult racer1Result, RaceStartResult racer2Result) {
            return racer1Result.getDivisionsCupPoints().compareTo(racer2Result.getDivisionsCupPoints());
        }
    };

    @Override
    protected void computeDivisionTotals() {
        int i;
        int i2;
        DivisionsCupSeriesResultsOrganizer myResultsData = (DivisionsCupSeriesResultsOrganizer)this.getResultsData();
        int nOrganizations = RaceOrganization.values().size();
        int[] nDivisionRacers = new int[nOrganizations];
        int[] nDivisionStarts = new int[nOrganizations];
        int[] nDivisionPoints = new int[nOrganizations];
        for (i2 = 0; i2 < nOrganizations; ++i2) {
            nDivisionRacers[i2] = 0;
        }
        for (i2 = 0; i2 < nOrganizations; ++i2) {
            nDivisionStarts[i2] = 0;
        }
        for (i2 = 0; i2 < nOrganizations; ++i2) {
            nDivisionPoints[i2] = 0;
        }
        for (StandingsCategory category : myResultsData.getCategories()) {
            int nRacers;
            RaceOrganization affiliation = (RaceOrganization)category;
            CategoryResultsList categoryResultsList = myResultsData.getCategoryResults(affiliation);
            if (categoryResultsList == null) continue;
            i = affiliation.ord;
            nDivisionRacers[i] = nRacers = categoryResultsList.size();
            ArrayList resultsByRacer = new ArrayList(categoryResultsList);
            Collections.sort(resultsByRacer, compareRacersByDivCupPoints);
            int numToCount = (int)Math.ceil((double)nRacers * 0.8);
            for (int j = 0; j < numToCount; ++j) {
                RaceSeriesResult seriesResult = (RaceSeriesResult)resultsByRacer.get(j);
                nDivisionStarts[i] = nDivisionStarts[i] + seriesResult.getNumberOfStarts();
                nDivisionPoints[i] = nDivisionPoints[i] + seriesResult.getDivisionsCupPoints().intValue();
            }
        }
        ArrayList<DivisionsCupResult> divisionResultsList = new ArrayList<DivisionsCupResult>();
        for (StandingsCategory category : myResultsData.getCategories()) {
            RaceOrganization affiliation = (RaceOrganization)category;
            i = affiliation.ord;
            if (nDivisionRacers[i] <= 0) continue;
            DivisionsCupResult aResult = new DivisionsCupResult(affiliation, nDivisionRacers[i], nDivisionStarts[i], DivisionsCupPoints.forPoints(nDivisionPoints[i]));
            divisionResultsList.add(aResult);
        }
        Collections.sort(divisionResultsList, DIVISION_RESULT_SORTER);
        this.assignDivisionFinishPositions(divisionResultsList);
        myResultsData.setDivisionResults(divisionResultsList);
    }

    @Override
    protected String getScoringQualificationDescription() {
        return "all races (best 80%)";
    }

    @Override
    public String name() {
        return "DivisionsCup80";
    }
}

