/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ussamasters.aces.racedata.models.CourseArrangement;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.ScoringElement;
import org.ussamasters.aces.racedata.models.StandardOrganizationType;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.scoring.BasicEventStandings;
import org.ussamasters.aces.racedata.scoring.BasicRaceSeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.MustFinishAllRacesScoringPolicy;
import org.ussamasters.aces.racedata.scoring.SeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.SeriesStandings;
import org.ussamasters.aces.racedata.scoring.SeriesStandingsScoringPolicy;

public class EventStandings
extends BasicEventStandings {
    public static boolean allowGenderStandingsHACK = false;
    public static final List<StandingsOrganizationType> STANDARD_ORGANIZATION_TYPES = EventStandings.constructStandardOrganizationTypes();

    public EventStandings(String eventShortName, RaceSeries raceSeries, SeriesResultsOrganizer resultsData) {
        super(eventShortName, raceSeries, (BasicRaceSeriesResultsOrganizer)resultsData);
    }

    public static SeriesStandings computeStandings(String eventShortName, RaceSeries raceSeries, RacerList registeredRacers, StandingsOrganizationType organizationType, ScoringElement scoringElement) {
        SeriesStandings standings = EventStandings.forRaceSeries(eventShortName, raceSeries, registeredRacers, organizationType);
        SeriesStandingsScoringPolicy scoringPolicy = MustFinishAllRacesScoringPolicy.forElement(scoringElement);
        standings.computeStandings(scoringPolicy);
        return standings;
    }

    public static SeriesStandings computeStandingsByRacePointsInClass(String eventShortName, RaceSeries raceSeries, RacerList registeredRacers) {
        return EventStandings.computeStandings(eventShortName, raceSeries, registeredRacers, StandardOrganizationType.BY_CLASS, ScoringElement.RACE_POINTS);
    }

    public static SeriesStandings computeStandingsByWorldCupPointsInClass(String eventShortName, RaceSeries raceSeries, RacerList registeredRacers) {
        return EventStandings.computeStandings(eventShortName, raceSeries, registeredRacers, StandardOrganizationType.BY_CLASS, ScoringElement.POINTS);
    }

    public static SeriesStandings forRaceSeries(RaceSeries raceSeries, RacerList registeredRacers, StandingsOrganizationType organizationType) {
        throw new UnsupportedOperationException("Combined event short name is required");
    }

    public static SeriesStandings forRaceSeries(String eventShortName, RaceSeries raceSeries, RacerList registeredRacers, StandingsOrganizationType organizationType) {
        StandingsOrganizationType actualOrganizationType = EventStandings.getActualOrganizationType(organizationType, raceSeries);
        if (actualOrganizationType == null) {
            return null;
        }
        return new EventStandings(eventShortName, raceSeries, SeriesResultsOrganizer.forRaceSeries(raceSeries, registeredRacers, actualOrganizationType));
    }

    public static StandingsOrganizationType getActualOrganizationType(StandingsOrganizationType organizationType, RaceSeries raceSeries) {
        StandingsOrganizationType actualOrganizationType = EventStandings.getActualOrganizationType(organizationType, raceSeries.getRaceClassClass());
        return EventStandings.isActualOrganizationSupported(actualOrganizationType, raceSeries) ? actualOrganizationType : null;
    }

    protected static boolean isActualOrganizationSupported(StandingsOrganizationType actualOrganizationType, CourseArrangement courseArrangement) {
        if (actualOrganizationType == null) {
            return false;
        }
        if (actualOrganizationType.isSupportedOnCourseArrangement(courseArrangement)) {
            return true;
        }
        return allowGenderStandingsHACK && actualOrganizationType.categoryClass().equals(Gender.class) && courseArrangement == CourseArrangement.SEPARATE_COURSES_BY_NATIONAL_GROUPS_AB_CD;
    }

    protected static boolean isActualOrganizationSupported(StandingsOrganizationType actualOrganizationType, RaceSeries raceSeries) {
        if (actualOrganizationType == null) {
            return false;
        }
        if (!actualOrganizationType.isSupportedOnRaceClass(raceSeries.getRaceClassClass())) {
            return false;
        }
        for (int i = 0; i < raceSeries.size(); ++i) {
            if (EventStandings.isActualOrganizationSupported(actualOrganizationType, raceSeries.getRaceData(i).getCourseArrangement())) continue;
            return false;
        }
        return true;
    }

    public static boolean isSupportedOrganization(StandingsOrganizationType organizationType, RaceSeries raceSeries) {
        StandingsOrganizationType actualOrganizationType = EventStandings.getActualOrganizationType(organizationType, raceSeries.getRaceClassClass());
        return EventStandings.isActualOrganizationSupported(actualOrganizationType, raceSeries);
    }

    protected static List<StandingsOrganizationType> constructStandardOrganizationTypes() {
        ArrayList<StandingsOrganizationType> standardTypes = new ArrayList<StandingsOrganizationType>();
        standardTypes.add(StandardOrganizationType.BY_CLASS);
        standardTypes.add(StandardOrganizationType.BY_GENDER);
        standardTypes.add(StandardOrganizationType.BY_NATIONAL_GROUP);
        standardTypes.add(StandardOrganizationType.BY_NATIONAL_GROUP_YOW);
        standardTypes.add(StandardOrganizationType.BY_FIS_MASTERS_GROUP);
        standardTypes.add(StandardOrganizationType.BY_ALL_RACERS);
        return Collections.unmodifiableList(standardTypes);
    }
}

