/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.RaceTime;
import org.ussamasters.aces.racedata.models.ScoringElement;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.scoring.BasicRaceSeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.CategoryResultsList;
import org.ussamasters.aces.racedata.scoring.MedalCountsResult;
import org.ussamasters.aces.racedata.scoring.MedalCountsResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.StandardSeriesScoringPolicy;

public class MedalCountsScoringPolicy
extends StandardSeriesScoringPolicy {
    public static final Comparator<MedalCountsResult> ORGANIZATION_RESULT_SORTER = new Comparator<MedalCountsResult>(){

        @Override
        public int compare(MedalCountsResult r1, MedalCountsResult r2) {
            return r1.compareTo(r2);
        }
    };

    public MedalCountsScoringPolicy() {
        super(ScoringElement.POINTS);
    }

    protected void assignTeamFinishPositions(List<MedalCountsResult> teamResults) {
        int position = -1000;
        int[] previousValues = null;
        MedalCountsResult previousResult = null;
        for (int i = 0; i < teamResults.size(); ++i) {
            MedalCountsResult aResult = teamResults.get(i);
            if (aResult.isQualified()) {
                int[] currentValues = aResult.medalCounts;
                if (Arrays.equals(currentValues, previousValues)) {
                    this.assignTie(aResult, previousResult);
                } else {
                    position = i + 1;
                    this.assignFinishPosition(aResult, position);
                    previousValues = currentValues;
                }
            } else {
                this.assignTeamNonFinisherPositions(teamResults, i);
                return;
            }
            previousResult = aResult;
        }
    }

    protected void assignTeamNonFinisherPositions(List<MedalCountsResult> teamResultsList, int firstNonFinisherIndex) {
        for (int i = firstNonFinisherIndex; i < teamResultsList.size(); ++i) {
            MedalCountsResult aResult = teamResultsList.get(i);
            if (aResult.isQualified()) {
                throw new IllegalStateException("Team results list not sorted by qualified/non-qualified order");
            }
            aResult.clearPosition();
        }
    }

    @Override
    protected void computeSeriesTotals(StandingsCategory category, RaceSeriesResult seriesResult, List<RaceStartResult> starts) {
        RaceTime totalTime = RaceTime.ZERO;
        int medalPoints = 0;
        for (RaceStartResult racerResult : starts) {
            if (racerResult == null || !racerResult.isFinisher()) continue;
            totalTime = totalTime.add(racerResult.getTime());
            int position = racerResult.getPosition();
            if (position <= 0 || position > 3) continue;
            medalPoints += racerResult.getPoints().intValue();
        }
        seriesResult.setTime(totalTime);
        seriesResult.setPoints(this.getPointsFactory().forPoints(medalPoints));
        if (!this.isQualifiedForSeriesStandings(seriesResult)) {
            this.markRacerAsUnqualifiedForStandings(seriesResult);
        }
    }

    @Override
    public void computeStandings(BasicRaceSeriesResultsOrganizer seriesResultsData) {
        super.computeStandings(seriesResultsData);
        this.computeTeamTotals();
    }

    protected void computeTeamTotals() {
        int i;
        MedalCountsResultsOrganizer myResultsData = (MedalCountsResultsOrganizer)this.getResultsData();
        int nOrganizations = RaceOrganization.values().size();
        int[] nRacers = new int[nOrganizations];
        int[] nMen = new int[nOrganizations];
        int[] nWomen = new int[nOrganizations];
        int[] nStarts = new int[nOrganizations];
        int[] nMedalists = new int[nOrganizations];
        int[][] medalCounts = new int[nOrganizations][4];
        for (StandingsCategory category : myResultsData.getCategories()) {
            RaceOrganization affiliation = (RaceOrganization)category;
            CategoryResultsList categoryResultsList = myResultsData.getCategoryResults(affiliation);
            if (categoryResultsList == null) continue;
            i = affiliation.ord;
            for (RaceSeriesResult seriesResult : categoryResultsList) {
                Gender gender = seriesResult.getGender();
                int n = i;
                nRacers[n] = nRacers[n] + 1;
                if (gender == Gender.MEN) {
                    int n2 = i;
                    nMen[n2] = nMen[n2] + 1;
                } else if (gender == Gender.WOMEN) {
                    int n3 = i;
                    nWomen[n3] = nWomen[n3] + 1;
                } else {
                    throw new RuntimeException("Invalid series racer gender: " + gender);
                }
                nStarts[i] = nStarts[i] + seriesResult.getNumberOfStarts();
                boolean isMedalist = false;
                for (RaceStartResult racerResult : seriesResult.starts()) {
                    int position;
                    if (racerResult == null || (position = racerResult.getPosition()) <= 0 || position > 3) continue;
                    int[] nArray = medalCounts[i];
                    nArray[0] = nArray[0] + 1;
                    int[] nArray2 = medalCounts[i];
                    int n4 = position;
                    nArray2[n4] = nArray2[n4] + 1;
                    isMedalist = true;
                }
                if (!isMedalist) continue;
                int n5 = i;
                nMedalists[n5] = nMedalists[n5] + 1;
            }
        }
        ArrayList<MedalCountsResult> teamResultsList = new ArrayList<MedalCountsResult>(nOrganizations);
        for (StandingsCategory category : myResultsData.getCategories()) {
            RaceOrganization affiliation = (RaceOrganization)category;
            i = affiliation.ord;
            if (nRacers[i] <= 0) continue;
            MedalCountsResult aResult = new MedalCountsResult(affiliation, nRacers[i], nMen[i], nWomen[i], nStarts[i], nMedalists[i], medalCounts[i]);
            teamResultsList.add(aResult);
        }
        Collections.sort(teamResultsList, ORGANIZATION_RESULT_SORTER);
        this.assignTeamFinishPositions(teamResultsList);
        myResultsData.setTeamResults(teamResultsList);
    }

    @Override
    protected boolean isQualifiedForSeriesStandings(RaceSeriesResult seriesResult) {
        return super.isQualifiedForSeriesStandings(seriesResult) && seriesResult.getPoints().intValue() > 0;
    }

    @Override
    protected String getScoringElementDescription(ScoringElement aScoringElement) {
        return "medal counts";
    }

    @Override
    public String name() {
        return "MedalCounts";
    }
}

