/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import com.glaivestone.javax.execution.EvaluableAction;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.scoring.RaceDataScoringException;
import org.ussamasters.aces.racedata.scoring.RacerResultOrganizingPolicy;
import org.ussamasters.aces.racedata.scoring.SeriesResultsOrganizer;

public class SeasonResultsOrganizer
extends SeriesResultsOrganizer {
    private boolean isOrganizedByClass = RaceClass.getAllRaceClasses().contains(this.categoryClass());
    private Class<? extends RaceClass<?>> seasonRaceClassClass;
    private EvaluableAction categoryConverter;

    public static SeriesResultsOrganizer forRaceSeries(RaceSeries seasonRaces, RacerList registeredRacers, StandingsOrganizationType organizationType) {
        return new SeasonResultsOrganizer(seasonRaces, registeredRacers, SeasonResultsOrganizer.getOrganizingPolicy(organizationType));
    }

    public SeasonResultsOrganizer(RaceSeries seasonRaces, RacerList registeredRacers, RacerResultOrganizingPolicy<RaceStartResult> organizingPolicy) {
        super(seasonRaces, registeredRacers, organizingPolicy);
        this.seasonRaceClassClass = seasonRaces.getRaceClassClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StandingsCategory convertCategory(StandingsCategory category) {
        StandingsCategory actualCategory;
        EvaluableAction evaluableAction = this.categoryConverter;
        synchronized (evaluableAction) {
            actualCategory = (StandingsCategory)this.categoryConverter.evaluate(category);
        }
        return actualCategory;
    }

    @Override
    protected StandingsCategory getCategory(RaceEntryResult racerResult) {
        StandingsCategory category = super.getCategory(racerResult);
        if (this.categoryConverter != null) {
            category = this.convertCategory(category);
        }
        return category;
    }

    @Override
    protected RaceClass<?> getRaceClass(RaceEntryResult racerResult) {
        RaceClass raceClass = racerResult.getRaceClass();
        if (this.isOrganizedByClass && this.categoryConverter != null) {
            raceClass = (RaceClass)this.convertCategory(raceClass);
        }
        return raceClass;
    }

    @Override
    protected void processRaceResult(RaceResult raceResult) {
        Class<RaceClass<?>> raceClassClass;
        this.categoryConverter = null;
        if (this.isOrganizedByClass && !(raceClassClass = raceResult.getRaceClassClass()).equals(this.seasonRaceClassClass)) {
            this.categoryConverter = RaceClass.getConverter(raceClassClass, this.seasonRaceClassClass);
            if (this.categoryConverter == null) {
                throw new RaceDataScoringException(String.format("Cannot convert race class %s to standings organization class  %s", raceClassClass.getSimpleName(), this.seasonRaceClassClass.getSimpleName()));
            }
        }
        super.processRaceResult(raceResult);
    }
}

