/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import org.ussamasters.aces.racedata.models.CourseArrangement;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.models.StandingsType;
import org.ussamasters.aces.racedata.scoring.SeasonResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.SeasonSummaryStatistics;
import org.ussamasters.aces.racedata.scoring.SeriesStandings;
import org.ussamasters.aces.racedata.scoring.SeriesSummaryStatistics;

public class SeasonStandings
extends SeriesStandings {
    public static boolean allowGenderStandingsHACK = false;

    public static SeriesStandings forRaceSeries(RaceSeries seasonRaces, RacerList registeredRacers, StandingsOrganizationType organizationType) {
        StandingsOrganizationType actualOrganizationType = SeasonStandings.getActualOrganizationType(organizationType, seasonRaces);
        if (actualOrganizationType == null) {
            return null;
        }
        return new SeasonStandings(seasonRaces, (SeasonResultsOrganizer)SeasonResultsOrganizer.forRaceSeries(seasonRaces, registeredRacers, actualOrganizationType));
    }

    public static StandingsOrganizationType getActualOrganizationType(StandingsOrganizationType organizationType, RaceSeries raceSeries) {
        StandingsOrganizationType actualOrganizationType = SeasonStandings.getActualOrganizationType(organizationType, raceSeries.getRaceClassClass());
        return SeasonStandings.isActualOrganizationSupported(actualOrganizationType, raceSeries) ? actualOrganizationType : null;
    }

    protected static boolean isActualOrganizationSupported(StandingsOrganizationType actualOrganizationType, CourseArrangement courseArrangement) {
        if (actualOrganizationType == null) {
            return false;
        }
        if (actualOrganizationType.isSupportedOnCourseArrangement(courseArrangement)) {
            return true;
        }
        return allowGenderStandingsHACK && actualOrganizationType.categoryClass().equals(Gender.class) && courseArrangement == CourseArrangement.SEPARATE_COURSES_BY_NATIONAL_GROUPS_AB_CD;
    }

    protected static boolean isActualOrganizationSupported(StandingsOrganizationType actualOrganizationType, RaceSeries raceSeries) {
        if (actualOrganizationType == null) {
            return false;
        }
        if (!actualOrganizationType.isSupportedOnRaceClass(raceSeries.getRaceClassClass())) {
            return false;
        }
        for (int i = 0; i < raceSeries.size(); ++i) {
            if (SeasonStandings.isActualOrganizationSupported(actualOrganizationType, raceSeries.getRaceData(i).getCourseArrangement())) continue;
            return false;
        }
        return true;
    }

    public static boolean isSupportedOrganization(StandingsOrganizationType organizationType, RaceSeries raceSeries) {
        StandingsOrganizationType actualOrganizationType = SeasonStandings.getActualOrganizationType(organizationType, raceSeries.getRaceClassClass());
        return SeasonStandings.isActualOrganizationSupported(actualOrganizationType, raceSeries);
    }

    public static String rootReferenceName(StandingsType standingsType) {
        if (standingsType != StandingsType.SEASON) {
            throw new IllegalArgumentException("Invalid standings type for season standings: " + standingsType);
        }
        return "SS";
    }

    protected SeasonStandings(RaceSeries seasonRaces, SeasonResultsOrganizer seriesResultsData) {
        super(StandingsType.SEASON, seasonRaces, seriesResultsData);
    }

    @Override
    protected SeriesSummaryStatistics constructSummaryStatistics() {
        return new SeasonSummaryStatistics();
    }

    @Override
    public String rootReferenceName() {
        return SeasonStandings.rootReferenceName(this.getType());
    }
}

