/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.ScoringElement;
import org.ussamasters.aces.racedata.models.SeriesRacerSummary;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.models.StandingsSummaryData;
import org.ussamasters.aces.racedata.models.StandingsType;
import org.ussamasters.aces.racedata.scoring.BasicRaceSeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.CategoryResultsList;
import org.ussamasters.aces.racedata.scoring.RacerResultOrganizingPolicy;
import org.ussamasters.aces.racedata.scoring.ScoringPolicy;
import org.ussamasters.aces.racedata.scoring.SeasonSummaryStatistics;
import org.ussamasters.aces.racedata.scoring.SeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.SeriesStandingsScoringPolicy;
import org.ussamasters.aces.racedata.scoring.SeriesSummaryStatistics;
import org.ussamasters.aces.racedata.scoring.Standings;
import org.ussamasters.javax.lang.SubclassResponsibility;

public class SeriesStandings
extends Standings {
    private String description;
    private RaceSeries raceSeries;
    private BasicRaceSeriesResultsOrganizer resultsData;
    private SeriesSummaryStatistics summaryStatistics;
    private SeriesStandingsScoringPolicy scoringPolicy;
    private SeriesStandingsScoringPolicy policyUsed;

    public static SeriesStandings forRaceSeries(RaceSeries raceSeries, RacerList registeredRacers, StandingsOrganizationType organizationType) {
        StandingsOrganizationType actualOrganizationType = SeriesStandings.getActualOrganizationType(organizationType, raceSeries);
        if (actualOrganizationType == null) {
            return null;
        }
        return new SeriesStandings(StandingsType.SERIES, raceSeries, SeriesResultsOrganizer.forRaceSeries(raceSeries, registeredRacers, actualOrganizationType));
    }

    public static StandingsOrganizationType getActualOrganizationType(StandingsOrganizationType organizationType, RaceSeries raceSeries) {
        StandingsOrganizationType actualOrganizationType = SeriesStandings.getActualOrganizationType(organizationType, raceSeries.getRaceClassClass());
        return SeriesStandings.isActualOrganizationSupported(actualOrganizationType, raceSeries) ? actualOrganizationType : null;
    }

    protected static boolean isActualOrganizationSupported(StandingsOrganizationType actualOrganizationType, RaceSeries raceSeries) {
        if (actualOrganizationType == null) {
            return false;
        }
        if (!actualOrganizationType.isSupportedOnRaceClass(raceSeries.getRaceClassClass())) {
            return false;
        }
        for (int i = 0; i < raceSeries.size(); ++i) {
            if (actualOrganizationType.isSupportedOnCourseArrangement(raceSeries.getRaceData(i).getCourseArrangement())) continue;
            return false;
        }
        return true;
    }

    public static boolean isSupportedOrganization(StandingsOrganizationType organizationType, RaceSeries raceSeries) {
        StandingsOrganizationType actualOrganizationType = SeriesStandings.getActualOrganizationType(organizationType, raceSeries.getRaceClassClass());
        return SeriesStandings.isActualOrganizationSupported(actualOrganizationType, raceSeries);
    }

    public static String rootReferenceName(StandingsType standingsType) {
        return standingsType.name + "Standings";
    }

    protected SeriesStandings(StandingsType standingsType, RaceSeries raceSeries, BasicRaceSeriesResultsOrganizer resultsData) {
        super(standingsType, resultsData.getOrganizationType());
        this.raceSeries = raceSeries;
        this.resultsData = resultsData;
        this.policyUsed = null;
    }

    public SeriesStandings(RaceSeries raceSeries, RacerList registeredRacers, RacerResultOrganizingPolicy<RaceStartResult> organizingPolicy) {
        this(StandingsType.SERIES, raceSeries, new SeriesResultsOrganizer(raceSeries, registeredRacers, organizingPolicy));
    }

    public void clearStandings() {
        this.resultsData.clearStandings();
    }

    @Override
    public void computeStandings() {
        if (this.scoringPolicy == null) {
            throw new SubclassResponsibility();
        }
        this.computeStandings(this.scoringPolicy);
    }

    @Override
    public void computeStandings(ScoringPolicy scoringPolicy) {
        this.computeStandings((SeriesStandingsScoringPolicy)scoringPolicy);
    }

    public void computeStandings(SeriesStandingsScoringPolicy scoringPolicy) {
        if (this.policyUsed != null) {
            if (scoringPolicy == this.policyUsed) {
                return;
            }
            this.clearStandings();
        } else {
            this.resultsData.organizeResults();
        }
        scoringPolicy.computeStandings(this.resultsData);
        this.computeSummaryStatistics();
        this.setDescription(scoringPolicy.getDescription(this.getOrganizationType()));
        this.policyUsed = scoringPolicy;
    }

    protected void computeSummaryStatistics() {
        this.summaryStatistics = this.constructSummaryStatistics();
        this.summaryStatistics.computeStatistics(this);
    }

    protected SeriesSummaryStatistics constructSummaryStatistics() {
        return new SeriesSummaryStatistics();
    }

    public Set<? extends StandingsCategory> getCategories() {
        return this.resultsData.getCategories();
    }

    public CategoryResultsList<RaceSeriesResult> getCategoryResults(StandingsCategory category) {
        return this.resultsData.getCategoryResults(category);
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public StandingsSummaryData[] getCompetitorStatistics() {
        return this.getSummaryStatistics().getCompetitorStatistics();
    }

    public List<SeriesRacerSummary> getMultiCategoryRacers() {
        return this.resultsData.getMultiCategoryRacers();
    }

    public int getNumberOfRaces() {
        return this.resultsData.getNumberOfRaces();
    }

    @Override
    public StandingsSummaryData[] getQualifierStatistics() {
        return this.getSummaryStatistics().getQualifierStatistics();
    }

    public RaceIdentifier getRace(int index) {
        return this.getRaceSeries().getRace(index);
    }

    public Racer getRacer(String bib) {
        return this.resultsData.getRacer(bib);
    }

    public SeriesRacerSummary getRacerSummary(String bib) {
        return this.resultsData.getRacerSummary(bib);
    }

    public RaceSeries getRaceSeries() {
        return this.resultsData.getRaceSeries();
    }

    protected BasicRaceSeriesResultsOrganizer getResultsData() {
        return this.resultsData;
    }

    public SeriesStandingsScoringPolicy getScoringPolicy() {
        return this.policyUsed;
    }

    protected SeriesStandingsScoringPolicy getScoringPolicySpecification() {
        return this.scoringPolicy;
    }

    public ScoringElement getScoringElement() {
        return this.policyUsed.getScoringElement();
    }

    public SeasonSummaryStatistics getSeasonSummaryStatistics() {
        return this.getType() == StandingsType.SEASON ? (SeasonSummaryStatistics)this.summaryStatistics : null;
    }

    public SeriesSummaryStatistics getSummaryStatistics() {
        return this.summaryStatistics;
    }

    protected void initialize() {
    }

    protected Collection<SeriesRacerSummary> racerSummaries() {
        return Collections.unmodifiableCollection(this.resultsData.racerSummaries());
    }

    public String referenceNameScoringPolicyQualifer() {
        if (this.policyUsed == null) {
            return null;
        }
        return this.policyUsed.name();
    }

    @Override
    public String rootReferenceName() {
        return SeriesStandings.rootReferenceName(this.getType());
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected void setScoringPolicy(SeriesStandingsScoringPolicy scoringPolicy) {
        this.scoringPolicy = scoringPolicy;
    }

    @Override
    public String standardReferenceName() {
        return String.format("%s-%s-%s", this.rootReferenceName(), this.referenceNameScoringPolicyQualifer(), this.organizationTypeName());
    }

    public String toString() {
        return String.format("%s<%s, %s>", this.getClass().getSimpleName(), this.organizationTypeName(), this.getScoringPolicy());
    }
}

