/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.Collection;
import java.util.List;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceDataSummaryStatistics;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.SeriesRacerSummary;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.models.StandingsSummaryData;
import org.ussamasters.aces.racedata.scoring.CategoryResultsList;
import org.ussamasters.aces.racedata.scoring.SeriesStandings;

public class SeriesSummaryStatistics
extends RaceDataSummaryStatistics {
    public static final Object TYPE_SERIES_STARTS = new Object();
    private StandingsSummaryData[] competitorStartsStatistics;

    @Override
    public void clear() {
        super.clear();
        this.competitorStartsStatistics = this.constructStatistics(TYPE_SERIES_STARTS, CATEGORIES_ALL_MEN_WOMEN);
    }

    @Override
    public Object clone() {
        SeriesSummaryStatistics copy = (SeriesSummaryStatistics)super.clone();
        copy.competitorStartsStatistics = this.copyStatistics(this.competitorStartsStatistics);
        return copy;
    }

    public SeriesSummaryStatistics copy() {
        return (SeriesSummaryStatistics)this.clone();
    }

    protected void collectCategoryStatistics(Object category, List<RaceSeriesResult> categoryResultsList) {
        for (RaceSeriesResult racerResult : categoryResultsList) {
            this.collectStatistics(racerResult);
        }
    }

    protected void collectStatistics(Collection<SeriesRacerSummary> racerSummaries) {
        for (SeriesRacerSummary racerSummary : racerSummaries) {
            this.collectStatistics(racerSummary);
        }
    }

    @Override
    protected void collectStatistics(RaceResult raceResult) {
        this.competitorStartsStatistics[0].incrementTotal(raceResult.getNumberOfCompetitors());
        this.competitorStartsStatistics[2].incrementTotal(raceResult.getNumberOfCompetitors(Gender.MEN));
        this.competitorStartsStatistics[1].incrementTotal(raceResult.getNumberOfCompetitors(Gender.WOMEN));
    }

    protected void collectStatistics(RaceSeries raceSeries) {
        for (RaceResult race : raceSeries.getRaceResults()) {
            this.collectStatistics(race);
        }
    }

    protected void collectStatistics(SeriesRacerSummary racerSummary) {
        Gender gender = racerSummary.getGender();
        int nStarts = racerSummary.getNumberOfStarts();
        if (nStarts > 0) {
            this.recordCompetitor(gender);
        }
    }

    protected void collectStatistics(RaceSeriesResult racerResult) {
        if (racerResult.isFinisher()) {
            this.recordQualifier(racerResult.getGender());
        }
    }

    public void computeStatistics(SeriesStandings seriesStandings) {
        this.prepareToComputeStatistics();
        this.collectStatistics(seriesStandings.getRaceSeries());
        this.collectStatistics(seriesStandings.racerSummaries());
        for (StandingsCategory standingsCategory : seriesStandings.getCategories()) {
            CategoryResultsList<RaceSeriesResult> categoryResultsList = seriesStandings.getCategoryResults(standingsCategory);
            if (categoryResultsList == null) continue;
            this.collectCategoryStatistics(standingsCategory, categoryResultsList);
        }
        this.recordNumberOfCompetitorDataSources(seriesStandings.getNumberOfRaces());
        this.finishComputingStatistics();
    }

    @Override
    protected void finishComputingStatistics() {
        super.finishComputingStatistics();
        for (int i = 0; i < this.competitorStartsStatistics.length; ++i) {
            this.competitorStartsStatistics[i].setNumberOfDataSources(this.getCompetitorStatistics()[i].getTotal());
        }
    }

    public int getAverageNumberOfStartsPerRacer() {
        return this.competitorStartsStatistics[0].getAverage();
    }

    public int getAverageNumberOfStartsPerRacer(Gender gender) {
        return this.competitorStartsStatistics[1 + gender.ord].getAverage();
    }

    public StandingsSummaryData[] getCompetitorStartsStatistics() {
        return this.competitorStartsStatistics;
    }

    public StandingsSummaryData[] getDivisionStartsStatistics() {
        return null;
    }

    public int getNumberOfStarts() {
        return this.competitorStartsStatistics[0].getTotal();
    }

    public int getNumberOfStarts(Gender gender) {
        return this.competitorStartsStatistics[1 + gender.ord].getTotal();
    }

    public StandingsSummaryData[] getRaceStartsStatistics() {
        return null;
    }

    @Override
    protected void prepareToComputeStatistics() {
        super.prepareToComputeStatistics();
        this.clearTotals(this.competitorStartsStatistics);
    }
}

