/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.List;
import org.ussamasters.aces.racedata.models.AllRacersCategory;
import org.ussamasters.aces.racedata.models.FISMastersGroup;
import org.ussamasters.aces.racedata.models.NationalClassGroup;
import org.ussamasters.aces.racedata.models.NationalClassGroupYOW;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.StandardOrganizationType;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.models.StandingsSummaryData;
import org.ussamasters.aces.racedata.models.StandingsType;
import org.ussamasters.aces.racedata.scoring.CategoryResultsList;
import org.ussamasters.aces.racedata.scoring.ScoringPolicy;

public abstract class Standings {
    private StandingsType standingsType;
    private StandingsOrganizationType organizationType;

    public static StandingsOrganizationType getActualOrganizationType(StandingsOrganizationType organizationType, Class<? extends RaceClass<?>> raceClassClass) {
        Class<? extends StandingsCategory> categoryClass = organizationType.categoryClass();
        if (categoryClass.equals(RaceClass.class)) {
            return StandardOrganizationType.forCategoryClass(raceClassClass);
        }
        if (categoryClass.equals(NationalClassGroup.class)) {
            return ((StandardOrganizationType)organizationType).getActualOrganizationType(raceClassClass);
        }
        if (categoryClass.equals(NationalClassGroupYOW.class)) {
            return ((StandardOrganizationType)organizationType).getActualOrganizationType(raceClassClass);
        }
        if (categoryClass.equals(FISMastersGroup.class)) {
            return ((StandardOrganizationType)organizationType).getActualOrganizationType(raceClassClass);
        }
        return organizationType;
    }

    protected Standings(StandingsType standingsType, StandingsOrganizationType organizationType) {
        this.standingsType = standingsType;
        this.organizationType = organizationType;
    }

    public Class<? extends StandingsCategory> categoryClass() {
        return this.organizationType.categoryClass();
    }

    public List<? extends StandingsCategory> categories() {
        return this.organizationType.categories();
    }

    public abstract void computeStandings();

    public abstract void computeStandings(ScoringPolicy var1);

    public abstract CategoryResultsList<?> getCategoryResults(StandingsCategory var1);

    public abstract StandingsSummaryData[] getCompetitorStatistics();

    public StandingsOrganizationType getOrganizationType() {
        return this.organizationType;
    }

    public abstract StandingsSummaryData[] getQualifierStatistics();

    public StandingsType getType() {
        return this.standingsType;
    }

    public boolean isOrganizedByClass() {
        return RaceClass.getAllRaceClasses().contains(this.categoryClass());
    }

    public boolean isOrganizedByOverallFinish() {
        return this.categoryClass().equals(AllRacersCategory.class);
    }

    public String organizationDescription() {
        return this.organizationType.description();
    }

    public String organizationTypeName() {
        return this.organizationType.name();
    }

    public String referenceNameOrganizationQualifier() {
        return this.organizationTypeName();
    }

    public abstract String rootReferenceName();

    public String standardReferenceName() {
        return this.rootReferenceName() + "-" + this.organizationTypeName();
    }
}

