/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.utils;

import com.glaivestone.javax.lang.SystemConstants;
import com.glaivestone.toolbox.mv.text.TextLogWindow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.ussamasters.aces.racedata.models.Country;
import org.ussamasters.aces.racedata.models.FarWestClass_10yr;
import org.ussamasters.aces.racedata.models.NationalClass_2000;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassRegistry;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceLocation;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;

public class RaceDataConstantReporter {
    public static String describeCountries() {
        StringBuffer sb = new StringBuffer();
        int nConstants = 0;
        sb.append("RaceLocation Constants:");
        sb.append(SystemConstants.NEW_LINE);
        for (Country aConstant : Country.values()) {
            ++nConstants;
            sb.append(aConstant.toDescriptionString() + " - " + aConstant);
            sb.append(SystemConstants.NEW_LINE);
        }
        sb.append("(" + nConstants + " constants)");
        sb.append(SystemConstants.NEW_LINE);
        return sb.toString();
    }

    public static String describeLocations() {
        StringBuffer sb = new StringBuffer();
        int nConstants = 0;
        sb.append("RaceLocation Constants:");
        sb.append(SystemConstants.NEW_LINE);
        for (RaceLocation aConstant : RaceLocation.values()) {
            ++nConstants;
            sb.append(aConstant.toDescriptionString() + " - " + aConstant);
            sb.append(SystemConstants.NEW_LINE);
        }
        sb.append("(" + nConstants + " constants)");
        sb.append(SystemConstants.NEW_LINE);
        return sb.toString();
    }

    public static String describeSeasons() {
        StringBuffer sb = new StringBuffer();
        int nConstants = 0;
        sb.append("SeasonIdentifier Constants:");
        sb.append(SystemConstants.NEW_LINE);
        for (SeasonIdentifier aConstant : SeasonIdentifier.values()) {
            ++nConstants;
            sb.append(aConstant.name() + " - " + aConstant.toDescriptionString());
            sb.append(SystemConstants.NEW_LINE);
        }
        sb.append("CURRENT = " + SeasonIdentifier.CURRENT.toDescriptionString());
        sb.append(SystemConstants.NEW_LINE);
        sb.append("(" + nConstants + " constants)");
        sb.append(SystemConstants.NEW_LINE);
        return sb.toString();
    }

    public static String describeRaceClass(Class<? extends RaceClass<?>> raceClassClass, List<? extends RaceClass<?>> raceClasses) {
        StringBuffer sb = new StringBuffer();
        sb.append(raceClassClass.getSimpleName() + ":");
        sb.append(SystemConstants.NEW_LINE);
        for (RaceClass<?> raceClass : raceClasses) {
            sb.append(raceClass.toDescriptionString());
            sb.append(SystemConstants.NEW_LINE);
        }
        sb.append("(" + raceClasses.size() + " constants)");
        sb.append(SystemConstants.NEW_LINE);
        return sb.toString();
    }

    public static String describeUSSAClassToFWClassMapping() {
        StringBuffer sb = new StringBuffer();
        sb.append("NationalClass -> FarWestClass:");
        sb.append(SystemConstants.NEW_LINE);
        for (NationalClass_2000 ussaClass : NationalClass_2000.values()) {
            FarWestClass_10yr fwClass = FarWestClass_10yr.forNationalClass(ussaClass);
            sb.append("   " + ussaClass + " -> " + fwClass);
            if (ussaClass.isAgeGroupClass() && ussaClass.group != null) {
                sb.append(" (" + ussaClass.group.toConstantName() + ")");
            }
            sb.append(SystemConstants.NEW_LINE);
        }
        return sb.toString();
    }

    public static List<Class<? extends RaceClass<?>>> getAllRaceClassClasses() {
        RaceClassRegistry infoRegistry = RaceClassRegistry.current();
        HashMap classFlavors = new HashMap();
        for (Class<RaceClass<?>> raceClassClass : RaceClass.getAllRaceClasses()) {
            RaceClassType flavor = infoRegistry.getRaceClassType(raceClassClass);
            ArrayList classesList = (ArrayList)classFlavors.get(flavor);
            if (classesList == null) {
                classesList = new ArrayList();
                classFlavors.put(flavor, classesList);
            }
            classesList.add(raceClassClass);
        }
        ArrayList orderedClasses = new ArrayList();
        for (RaceClassType flavor : RaceClassType.values()) {
            List classesList = (List)classFlavors.get(flavor);
            if (classesList == null) continue;
            Collections.sort(classesList, new Comparator<Class<?>>(){

                @Override
                public int compare(Class<?> c1, Class<?> c2) {
                    return c1.getSimpleName().compareTo(c2.getSimpleName());
                }
            });
            orderedClasses.addAll(classesList);
        }
        return orderedClasses;
    }

    public static void main(String[] args) {
        TextLogWindow tw = TextLogWindow.createWindow("FWM Race Data Constants Reports");
        tw.println("--====== USSA Masters Race Classes ======");
        tw.println();
        for (Class<? extends RaceClass<?>> clazz : RaceDataConstantReporter.getAllRaceClassClasses()) {
            tw.println(RaceDataConstantReporter.describeRaceClass(clazz, RaceClass.getRaceClassValues(clazz)));
            tw.println();
        }
        tw.println("--====== USSA NationalClass Constants for (10 yr) Far West classes ======");
        tw.println();
        tw.println(RaceDataConstantReporter.describeUSSAClassToFWClassMapping());
        tw.println();
        tw.println("--====== Countries ======");
        tw.println();
        tw.println(RaceDataConstantReporter.describeCountries());
        tw.println();
        tw.println("--====== Race Locations ======");
        tw.println();
        tw.println(RaceDataConstantReporter.describeLocations());
        tw.println();
        tw.println("--====== Seasons ======");
        tw.println();
        tw.println(RaceDataConstantReporter.describeSeasons());
        tw.println();
        tw.println("...done");
    }
}

