/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.models;

import java.util.StringTokenizer;

public class BibNumberRange {
    public static final String RANGE_SPEC_SEPARATOR = "..";
    public static final String RANGE_SPEC_OPEN_ENDED = "+";
    public static final BibNumberRange[] EMPTY_ARRAY = new BibNumberRange[0];
    public static final Class<? extends BibNumberRange[]> ARRAY_TYPE = EMPTY_ARRAY.getClass();
    public final int firstNumber;
    public final int lastNumber;

    public static boolean contains(int aBibNumber, BibNumberRange[] ranges) {
        for (int i = 0; i < ranges.length; ++i) {
            if (!ranges[i].contains(aBibNumber)) continue;
            return true;
        }
        return false;
    }

    public static BibNumberRange fromSpecificationString(String rangeSpec) {
        int indexSeparator = rangeSpec.indexOf(RANGE_SPEC_SEPARATOR);
        if (indexSeparator != -1) {
            return new BibNumberRange(Integer.parseInt(rangeSpec.substring(0, indexSeparator)), Integer.parseInt(rangeSpec.substring(indexSeparator + 2)));
        }
        if (rangeSpec.endsWith(RANGE_SPEC_OPEN_ENDED)) {
            return new BibNumberRange(Integer.parseInt(rangeSpec.substring(0, rangeSpec.length() - 1)));
        }
        throw new IllegalArgumentException("Invalid BibNumberRange specification: " + rangeSpec);
    }

    public static boolean hasOverlap(BibNumberRange[] someRanges, BibNumberRange[] otherRanges) {
        BibNumberRange aRange;
        int i;
        for (i = 0; i < someRanges.length; ++i) {
            aRange = someRanges[i];
            if (!aRange.containedIn(otherRanges)) continue;
            return true;
        }
        for (i = 0; i < otherRanges.length; ++i) {
            aRange = otherRanges[i];
            if (!aRange.containedIn(someRanges)) continue;
            return true;
        }
        return false;
    }

    public static BibNumberRange[] parseBibRangeSpec(String specString) {
        StringTokenizer tokenizer = new StringTokenizer(specString, ",");
        int count = tokenizer.countTokens();
        BibNumberRange[] ranges = new BibNumberRange[count];
        for (int i = 0; i < count; ++i) {
            String rangeSpec = tokenizer.nextToken().trim();
            ranges[i] = BibNumberRange.fromSpecificationString(rangeSpec);
        }
        return ranges;
    }

    public static String toDescriptionString(BibNumberRange[] ranges) {
        if (ranges.length == 1) {
            return ranges[0].toSpecificationString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < ranges.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(ranges[i].toSpecificationString());
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toSpecificationString(BibNumberRange[] ranges) {
        if (ranges.length == 1) {
            return ranges[0].toSpecificationString();
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ranges.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(ranges[i].toSpecificationString());
        }
        return sb.toString();
    }

    public BibNumberRange(int firstNumber) {
        this(firstNumber, Integer.MAX_VALUE);
    }

    public BibNumberRange(int firstNumber, int lastNumber) {
        this.firstNumber = firstNumber;
        this.lastNumber = lastNumber;
    }

    public boolean contains(int aBibNumber) {
        return aBibNumber >= this.firstNumber && aBibNumber <= this.lastNumber;
    }

    public boolean contains(BibNumberRange aRange) {
        return this.contains(aRange.firstNumber) || this.contains(aRange.lastNumber);
    }

    public boolean containedIn(BibNumberRange[] targetRanges) {
        for (int i = 0; i < targetRanges.length; ++i) {
            if (!targetRanges[i].contains(this)) continue;
            return true;
        }
        return false;
    }

    public BibNumberRange copy() {
        return new BibNumberRange(this.firstNumber, this.lastNumber);
    }

    public String toString() {
        return String.format("%s<<%s>>", this.getClass().getSimpleName(), this.toSpecificationString());
    }

    public String toSpecificationString() {
        return this.lastNumber == Integer.MAX_VALUE ? this.firstNumber + RANGE_SPEC_OPEN_ENDED : this.firstNumber + RANGE_SPEC_SEPARATOR + this.lastNumber;
    }
}

