/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.models;

import org.ussamasters.aces.racedata.models.PolicyID;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.tools.foundation.models.BibNumberRange;
import org.ussamasters.aces.tools.foundation.models.PBARacerListManagementPolicy;
import org.ussamasters.aces.tools.foundation.models.RacerListManagementPolicySpecification;

public class FarWestDivisionRacerListManagementPolicy
extends PBARacerListManagementPolicy {
    private static final Class<FarWestDivisionRacerListManagementPolicy> THIS_CLASS = FarWestDivisionRacerListManagementPolicy.class;
    public static final PolicyID POLICY_ID = PolicyID.defineConstant("farWestDivisionRacerListManagementPolicy", "RacerListManagement", "Far West masters division racers list (permanent bib assignments for division racers)");
    public static final RaceOrganization BIB_ALLOCATION_ORGANIZATION = RaceOrganization.FAR_WEST;
    public static final BibNumberRange[] PERMANENT_BIBS = new BibNumberRange[]{new BibNumberRange(1, 899)};
    public static final BibNumberRange[] SERIES_TRACKING_BIBS = new BibNumberRange[]{new BibNumberRange(1000)};
    public static final RacerListManagementPolicySpecification DEFAULT_POLICY_SPEC = FarWestDivisionRacerListManagementPolicy.createPolicySpec(POLICY_ID, BIB_ALLOCATION_ORGANIZATION, PERMANENT_BIBS, SERIES_TRACKING_BIBS, THIS_CLASS);

    public FarWestDivisionRacerListManagementPolicy() {
        super(BIB_ALLOCATION_ORGANIZATION, PERMANENT_BIBS, SERIES_TRACKING_BIBS);
    }

    public FarWestDivisionRacerListManagementPolicy(RacerListManagementPolicySpecification policySpec) {
        super(policySpec);
    }

    public FarWestDivisionRacerListManagementPolicy(RaceOrganization bibAllocationOrganization, BibNumberRange[] permanentBibs, BibNumberRange[] seriesTrackingBibs) {
        super(bibAllocationOrganization, permanentBibs, seriesTrackingBibs);
        if (bibAllocationOrganization != BIB_ALLOCATION_ORGANIZATION) {
            throw new IllegalArgumentException("Invalid bib allocation organization: " + bibAllocationOrganization);
        }
    }

    @Override
    public void configureOptions(RacerListManagementPolicySpecification policySpec) {
        if (policySpec.policyID != POLICY_ID) {
            throw new IllegalArgumentException("Invalid policy ID: " + policySpec);
        }
        this.bibAllocationOrganization = BIB_ALLOCATION_ORGANIZATION;
        super.configureOptions(policySpec);
    }

    @Override
    protected void validateConfiguration(RacerListManagementPolicySpecification policySpec) {
        if (policySpec.policyID != POLICY_ID) {
            throw new IllegalArgumentException("Invalid policy ID: " + policySpec);
        }
        if (this.bibAllocationOrganization != BIB_ALLOCATION_ORGANIZATION) {
            throw new IllegalArgumentException("Bib management organization must be Far West division");
        }
        super.validateConfiguration(policySpec);
    }

    static {
        FarWestDivisionRacerListManagementPolicy.registerDefaultSpec(DEFAULT_POLICY_SPEC);
    }
}

