/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.models;

import org.ussamasters.aces.racedata.models.PolicyID;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.tools.foundation.models.BibNumberRange;
import org.ussamasters.aces.tools.foundation.models.PBARacerListManagementPolicy;
import org.ussamasters.aces.tools.foundation.models.RacerListManagementPolicySpecification;

public class IntermountainDivisionRacerListManagementPolicy
extends PBARacerListManagementPolicy {
    private static final Class<IntermountainDivisionRacerListManagementPolicy> THIS_CLASS = IntermountainDivisionRacerListManagementPolicy.class;
    public static final PolicyID POLICY_ID = PolicyID.defineConstant("intermountainDivisionRacerListManagementPolicy", "RacerListManagement", "Intermountain masters division racers list (permanent bib assignments for division racers)");
    public static final RaceOrganization BIB_ALLOCATION_ORGANIZATION = RaceOrganization.INTERMOUNTAIN;
    public static final BibNumberRange[] PERMANENT_BIBS = new BibNumberRange[]{new BibNumberRange(1, 299), new BibNumberRange(501, 505)};
    public static final BibNumberRange[] SERIES_TRACKING_BIBS = new BibNumberRange[]{new BibNumberRange(1000)};
    public static final RacerListManagementPolicySpecification DEFAULT_POLICY_SPEC = IntermountainDivisionRacerListManagementPolicy.createPolicySpec(POLICY_ID, BIB_ALLOCATION_ORGANIZATION, PERMANENT_BIBS, SERIES_TRACKING_BIBS, THIS_CLASS);

    public IntermountainDivisionRacerListManagementPolicy() {
        super(BIB_ALLOCATION_ORGANIZATION, PERMANENT_BIBS, SERIES_TRACKING_BIBS);
    }

    public IntermountainDivisionRacerListManagementPolicy(RacerListManagementPolicySpecification policySpec) {
        super(policySpec);
    }

    public IntermountainDivisionRacerListManagementPolicy(RaceOrganization bibAllocationOrganization, BibNumberRange[] permanentBibs, BibNumberRange[] seriesTrackingBibs) {
        super(bibAllocationOrganization, permanentBibs, seriesTrackingBibs);
        if (bibAllocationOrganization != BIB_ALLOCATION_ORGANIZATION) {
            throw new IllegalArgumentException("Invalid bib allocation organization: " + bibAllocationOrganization);
        }
    }

    @Override
    public void configureOptions(RacerListManagementPolicySpecification policySpec) {
        if (policySpec.policyID != POLICY_ID) {
            throw new IllegalArgumentException("Invalid policy spec: " + policySpec);
        }
        this.bibAllocationOrganization = BIB_ALLOCATION_ORGANIZATION;
        super.configureOptions(policySpec);
    }

    @Override
    protected void validateConfiguration(RacerListManagementPolicySpecification policySpec) {
        if (policySpec.policyID != POLICY_ID) {
            throw new IllegalArgumentException("Invalid policy ID: " + policySpec);
        }
        if (this.bibAllocationOrganization != BIB_ALLOCATION_ORGANIZATION) {
            throw new IllegalArgumentException("Bib management organization must be Intermountain division");
        }
        super.validateConfiguration(policySpec);
    }

    static {
        IntermountainDivisionRacerListManagementPolicy.registerDefaultSpec(DEFAULT_POLICY_SPEC);
    }
}

