/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.models;

import org.ussamasters.aces.racedata.models.ParameterSpecification;
import org.ussamasters.aces.racedata.models.ParameterType;
import org.ussamasters.aces.racedata.models.PolicyID;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.tools.foundation.models.RacerListManagementPolicy;
import org.ussamasters.aces.tools.foundation.models.RacerListManagementPolicySpecification;
import org.ussamasters.aces.tools.foundation.processors.ValidationResolver;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;

public class SeriesRacerListManagementPolicy
extends RacerListManagementPolicy {
    private static final Class<SeriesRacerListManagementPolicy> THIS_CLASS = SeriesRacerListManagementPolicy.class;
    public static final PolicyID POLICY_ID = PolicyID.defineConstant("seriesRacerListManagementPolicy", "RacerListManagement", "generic series racer list (arbitrary bib assignments for race series)");
    public static final String PARM_SERIES_ORGANIZER = "seriesOrganizer";
    public static final RacerListManagementPolicySpecification DEFAULT_POLICY_SPEC = SeriesRacerListManagementPolicy.createPolicySpec(RaceOrganization.UNKNOWN);

    public SeriesRacerListManagementPolicy() {
        super(POLICY_ID);
    }

    public SeriesRacerListManagementPolicy(RacerListManagementPolicySpecification policySpec) {
        super(policySpec);
    }

    public static RacerListManagementPolicySpecification createPolicySpec(RaceOrganization seriesOrganizer) {
        return new RacerListManagementPolicySpecification(POLICY_ID, new ParameterSpecification[]{RacerListManagementPolicySpecification.TRACK_RACERS_BY_BIB, SeriesRacerListManagementPolicy.createSeriesOrganizerParmSpec(seriesOrganizer)}, RacerListManagementPolicySpecification.createStandardConstructionAction(THIS_CLASS));
    }

    public static ParameterSpecification createSeriesOrganizerParmSpec(RaceOrganization seriesOrganizer) {
        return new ParameterSpecification(PARM_SERIES_ORGANIZER, "Series organizer", "Organization responsible for the race series", ParameterType.STRING, false, seriesOrganizer.name);
    }

    @Override
    public void configureOptions(RacerListManagementPolicySpecification policySpec) {
        this.validateConfiguration(policySpec);
    }

    @Override
    public RacerListManagementPolicy copy() {
        return new SeriesRacerListManagementPolicy();
    }

    @Override
    public boolean isRaceTempBibNumber(int bibNumber) {
        return false;
    }

    @Override
    public void validateBibNumber(int bibNumber, RaceOrganization affiliation, String racerName, ValidationResolver validationResolver, ValidationResult validationResult) {
    }

    protected void validateConfiguration(RacerListManagementPolicySpecification policySpec) {
        if (policySpec.policyID != POLICY_ID) {
            throw new IllegalArgumentException("Invalid policy ID: " + policySpec);
        }
    }

    static {
        SeriesRacerListManagementPolicy.registerDefaultSpec(DEFAULT_POLICY_SPEC);
    }
}

