/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.models;

import com.glaivestone.javax.io.FileSystemReference;
import com.glaivestone.javax.io.FileType;
import com.glaivestone.javax.lang.ClassX;
import com.glaivestone.toolbox.settings.SettingsSection;
import com.glaivestone.toolbox.settings.StandardSettingsFileHolder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ussamasters.aces.racedata.io.RaceDataIOConstants;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.WorldCupPointsType;

public abstract class SeriesScoringSpecification
extends StandardSettingsFileHolder {
    public static final FileType FILE_TYPE = RaceDataIOConstants.FILE_TYPE_CFG;
    private static final String SETTING_NAME = "name";
    private static final String SETTING_DESCRIPTION = "description";
    private static final String SETTING_AGE_CLASSES = "ageClasses";
    private static final String SETTING_WORLD_CUP_POINTS = "worldCupPoints";
    private static final String SETTING_RACE_LIST = "raceList";
    private String shortName;
    private SeasonIdentifier season;
    private List<String> raceSpecifications;

    public SeriesScoringSpecification(File backingFile, SeasonIdentifier season) throws IOException {
        super(backingFile);
        this.setSeason(season);
    }

    protected SeriesScoringSpecification(SettingsSection settings, SeasonIdentifier season) {
        super(settings);
        this.setSeason(season);
    }

    protected SeriesScoringSpecification(SettingsSection settings, String name, String shortName, SeasonIdentifier season, Class<? extends RaceClass<?>> ageClassClass, WorldCupPointsType scoringType) {
        this(settings, season);
        this.setName(name);
        this.shortName = shortName;
        this.setAgeClassClass(ageClassClass);
        this.setWorldCupPointsType(scoringType);
    }

    public void addRace(RaceIdentifier raceID) {
        this.addRace(RaceDataIOServices.csvStringFromRace(raceID));
    }

    public void addRace(String raceSpecification) {
        this.getRaceSpecifications().add(raceSpecification);
        Collections.sort(this.getRaceSpecifications());
        this.setRaceListEntries(this.getRaceSpecifications());
    }

    protected abstract String fileNamePrefix();

    public Class<? extends RaceClass<?>> getAgeClassClass() {
        return RaceDataIOServices.raceClassFromLiteral(this.getSettings().getStringValue(SETTING_AGE_CLASSES), this.getSeason());
    }

    public String getDescription() {
        return this.getStringValue(SETTING_DESCRIPTION);
    }

    public String getName() {
        return this.getSettings().getStringValue(SETTING_NAME);
    }

    protected List<String> getRaceListEntries() {
        return this.getSettings().getStringValueList(SETTING_RACE_LIST);
    }

    public List<RaceIdentifier> getRaces() {
        List<String> raceIdSpecs = this.getRaceSpecifications();
        ArrayList<RaceIdentifier> raceIDs = new ArrayList<RaceIdentifier>(raceIdSpecs.size());
        for (String raceSpec : raceIdSpecs) {
            raceIDs.add(this.toRaceID(raceSpec));
        }
        return raceIDs;
    }

    public RaceIdentifier getRace(int index) {
        return this.toRaceID(this.getRaceSpecification(index));
    }

    public String getRaceSpecification(int index) {
        return this.getRaceSpecifications().get(index);
    }

    public List<String> getRaceSpecifications() {
        if (this.raceSpecifications == null) {
            this.raceSpecifications = this.getRaceListEntries();
        }
        return this.raceSpecifications;
    }

    public SeasonIdentifier getSeason() {
        return this.season;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void removeRace(RaceIdentifier raceID) {
        this.removeRace(RaceDataIOServices.csvStringFromRace(raceID));
    }

    public WorldCupPointsType getWorldCupPointsType() {
        return RaceDataIOServices.worldCupPointsTypeFromLiteral(this.getSettings().getStringValue(SETTING_WORLD_CUP_POINTS));
    }

    public void removeRace(String raceSpecification) {
        this.getRaceSpecifications().remove(raceSpecification);
        this.setRaceListEntries(this.getRaceSpecifications());
    }

    public void setAgeClassClass(Class<? extends RaceClass<?>> ageClassClass) {
        if (!ClassX.isProperSubclass(ageClassClass, RaceClass.class)) {
            throw new IllegalArgumentException("Age class not a RaceClass subclass: " + ageClassClass);
        }
        this.getSettings().setStringValue(SETTING_AGE_CLASSES, RaceDataIOServices.raceClassToLiteral(ageClassClass));
    }

    public void setDescription(String description) {
        this.getSettings().setStringValue(SETTING_DESCRIPTION, description);
    }

    @Override
    public void setFile(File aFile) {
        String fileName = FileSystemReference.getFileBaseName(aFile.getName());
        String fileNamePrefix = this.fileNamePrefix();
        if (!fileName.toLowerCase().startsWith(fileNamePrefix.toLowerCase())) {
            throw new IllegalArgumentException("Scoring specifications file name does not start with required prefix " + fileNamePrefix + ": " + aFile.getAbsolutePath());
        }
        String fileNameSuffix = fileName.substring(fileNamePrefix.length());
        if (this.shortName != null) {
            if (!fileNameSuffix.toLowerCase().equals(this.shortName.toLowerCase())) {
                throw new IllegalArgumentException("Cannot change event name from " + fileNamePrefix + this.shortName + ": " + aFile.getAbsolutePath());
            }
        } else {
            this.shortName = fileNameSuffix;
        }
        super.setFile(aFile);
    }

    public void setName(String name) {
        this.getSettings().setStringValue(SETTING_NAME, name);
    }

    public void setSeason(SeasonIdentifier season) {
        this.season = season;
    }

    protected void setRaceListEntries(List<String> raceList) {
        this.getSettings().setStringValueList(SETTING_RACE_LIST, raceList);
    }

    public void setWorldCupPointsType(WorldCupPointsType scoringType) {
        this.getSettings().setStringValue(SETTING_WORLD_CUP_POINTS, RaceDataIOServices.worldCupPointsTypeToLiteral(scoringType));
    }

    protected RaceIdentifier toRaceID(String raceSpec) {
        try {
            return RaceDataIOServices.csvStringToRace(raceSpec);
        }
        catch (RaceDataIOException ex) {
            throw new IllegalStateException("INTRACTABLE RACE ID, THIS CAN'T BE HAPPENINDG");
        }
    }
}

