/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.models;

import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.javax.execution.StaticMethodAction;
import com.glaivestone.toolbox.settings.SettingsSection;
import java.lang.reflect.Method;
import org.ussamasters.aces.tools.foundation.models.ToolID;

public class ToolInfo {
    public final ToolID toolID;
    public final Class<?> toolClass;
    protected final SettingsSection toolConfigSettings;
    protected EvaluableAction openAction;

    public ToolInfo(ToolID toolID, Class<?> toolClass, SettingsSection toolConfigSettings) {
        this.toolID = toolID;
        this.toolClass = toolClass;
        this.toolConfigSettings = toolConfigSettings;
    }

    protected EvaluableAction constructOpenAction() {
        String openSelector = this.toolConfigSettings.getStringValue("openMethod", "open");
        return StaticMethodAction.create(this.toolClass, openSelector);
    }

    public String getDisplayName() {
        return this.toolConfigSettings.getStringValue("displayName");
    }

    public String getIconReference() {
        return this.toolConfigSettings.getStringValue("toolIcon");
    }

    public EvaluableAction getOpenAction() {
        if (this.openAction == null) {
            this.openAction = this.constructOpenAction();
        }
        return this.openAction;
    }

    public SettingsSection getToolInstallationConfigSettings() {
        return this.toolConfigSettings;
    }

    public void installTool() {
        Class[] parmTypes;
        Method installMethod;
        String installSelector = this.toolConfigSettings.getStringValue("installMethod");
        if (installSelector != null && (installMethod = StaticMethodAction.findMethod(this.toolClass, installSelector, parmTypes = new Class[]{ToolInfo.class})) != null) {
            StaticMethodAction.create(this.toolClass, installMethod, new Object[]{this}).evaluate();
        }
    }

    public void openTool() {
        if (this.getOpenAction() == null) {
            throw new UnsupportedOperationException("Tool launch failed: no open action implemented by " + this.toolClass.getName());
        }
        this.getOpenAction().evaluate();
    }

    public String toString() {
        return String.format("%s<%s, %s, %s>", this.getClass().getSimpleName(), this.toolID, this.toolClass, this.toolConfigSettings);
    }
}

